/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;

public class StreamSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamSource/feature";
    private String publicId;
    private String systemId;
    private InputStream inputStream;
    private Reader reader;

    public StreamSource() {
    }

    public StreamSource(File f2) {
        this.setSystemId(f2);
    }

    public StreamSource(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public StreamSource(InputStream inputStream, String systemId) {
        this.setInputStream(inputStream);
        this.setSystemId(systemId);
    }

    public StreamSource(Reader reader) {
        this.setReader(reader);
    }

    public StreamSource(Reader reader, String systemId) {
        this.setReader(reader);
        this.setSystemId(systemId);
    }

    public StreamSource(String systemId) {
        this.systemId = systemId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setSystemId(File f2) {
        String fpath = f2.getAbsolutePath();
        if (File.separatorChar != '/') {
            fpath = fpath.replace(File.separatorChar, '/');
        }
        this.systemId = fpath.startsWith("/") ? "file://" + fpath : "file:///" + fpath;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

