/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.util.StringManager;

public class ResponseStream
extends ServletOutputStream {
    protected boolean closed = false;
    protected boolean commit = false;
    protected int count = 0;
    protected int length = -1;
    protected Response response = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected OutputStream stream = null;
    protected boolean suspended = false;

    public ResponseStream(Response response) {
        this.response = response;
        this.stream = response.getStream();
        this.suspended = response.isSuspended();
    }

    public void close() throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseStream.suspended"));
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.close.closed"));
        }
        this.response.getResponse().flushBuffer();
        this.closed = true;
    }

    boolean closed() {
        return this.closed;
    }

    public void flush() throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseStream.suspended"));
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.flush.closed"));
        }
        if (this.commit) {
            this.response.getResponse().flushBuffer();
        }
    }

    boolean getCommit() {
        return this.commit;
    }

    boolean isSuspended() {
        return this.suspended;
    }

    void reset() {
        this.count = 0;
    }

    void setCommit(boolean commit) {
        this.commit = commit;
    }

    void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void write(int b10) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        if (this.length > 0 && this.count >= this.length) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
        ((ResponseBase)this.response).write(b10);
        ++this.count;
    }

    public void write(byte[] b10) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(b10, 0, b10.length);
    }

    public void write(byte[] b10, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        int actual = len;
        if (this.length > 0 && this.count + len >= this.length) {
            actual = this.length - this.count;
        }
        ((ResponseBase)this.response).write(b10, off, actual);
        this.count += actual;
        if (actual < len) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
    }
}

