/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    private ArrayList filters = new ArrayList();
    private Iterator iterator = null;
    private Servlet servlet = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;

    void addFilter(ApplicationFilterConfig filterConfig) {
        this.filters.add(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (System.getSecurityManager() != null) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e10 = pe.getException();
                if (e10 instanceof ServletException) {
                    throw (ServletException)e10;
                }
                if (e10 instanceof IOException) {
                    throw (IOException)e10;
                }
                if (e10 instanceof RuntimeException) {
                    throw (RuntimeException)e10;
                }
                throw new ServletException(e10.getMessage(), e10);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.iterator == null) {
            this.iterator = ((AbstractList)this.filters).iterator();
        }
        if (this.iterator.hasNext()) {
            ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.iterator.next();
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, request, response);
                filter.doFilter(request, response, this);
                this.support.fireInstanceEvent("afterFilter", filter, request, response);
            }
            catch (IOException e10) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e10);
                }
                throw e10;
            }
            catch (ServletException e11) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e11);
                }
                throw e11;
            }
            catch (RuntimeException e12) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e12);
                }
                throw e12;
            }
            catch (Throwable e13) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, e13);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e13);
            }
            return;
        }
        try {
            this.support.fireInstanceEvent("beforeService", this.servlet, request, response);
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                this.servlet.service((HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                this.servlet.service(request, response);
            }
            this.support.fireInstanceEvent("afterService", this.servlet, request, response);
        }
        catch (IOException e14) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e14);
            throw e14;
        }
        catch (ServletException e15) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e15);
            throw e15;
        }
        catch (RuntimeException e16) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, (Throwable)e16);
            throw e16;
        }
        catch (Throwable e17) {
            this.support.fireInstanceEvent("afterService", this.servlet, request, response, e17);
            throw new ServletException(sm.getString("filterChain.servlet"), e17);
        }
    }

    void release() {
        this.filters.clear();
        this.iterator = this.iterator;
        this.servlet = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport support) {
        this.support = support;
    }
}

