/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class FastEngineMapper
implements ContainerListener,
Lifecycle,
Mapper,
PropertyChangeListener {
    private HashMap cache = new HashMap();
    private Host defaultHost = null;
    private int debug = 0;
    private StandardEngine engine = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;

    private void addAlias(String alias, Host host) {
        if (this.debug >= 3) {
            this.engine.log("Adding alias '" + alias + "' for host '" + host.getName() + "'");
        }
        this.cache.put(alias.toLowerCase(), host);
    }

    private void addHost(Host host) {
        if (this.debug >= 3) {
            this.engine.log("Adding host '" + host.getName() + "'");
        }
        host.addContainerListener(this);
        this.addAlias(host.getName(), host);
        String[] aliases = host.findAliases();
        int i2 = 0;
        while (i2 < aliases.length) {
            this.addAlias(aliases[i2], host);
            ++i2;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void containerEvent(ContainerEvent event) {
        Container source = (Container)event.getSource();
        String type = event.getType();
        if (source == this.engine) {
            if ("addChild".equals(type)) {
                this.addHost((Host)event.getData());
            } else if ("removeChild".equals(type)) {
                this.removeHost((Host)event.getData());
            }
        } else if (source instanceof Host) {
            if ("addAlias".equals(type)) {
                this.addAlias((String)event.getData(), (Host)source);
            } else if ("removeAlias".equals(type)) {
                this.removeAlias((String)event.getData());
            }
        }
    }

    private Host findHost(String name) {
        return (Host)this.cache.get(name.toLowerCase());
    }

    public Container getContainer() {
        return this.engine;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Container map(Request request, boolean update) {
        Host host;
        this.debug = this.engine.getDebug();
        String server = request.getRequest().getServerName();
        if (server == null) {
            server = this.engine.getDefaultHost();
            if (update) {
                request.setServerName(server);
            }
        }
        if (server == null) {
            return null;
        }
        if (this.debug >= 1) {
            this.engine.log("Mapping server name '" + server + "'");
        }
        if (this.debug >= 2) {
            this.engine.log(" Trying a cache match");
        }
        if ((host = (Host)this.cache.get(server)) == null && this.defaultHost != null) {
            if (this.debug >= 2) {
                this.engine.log(" Mapping to default host");
            }
            host = this.defaultHost;
            this.addAlias(server, host);
        }
        return host;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof Engine && "defaultHost".equals(event.getPropertyName())) {
            this.setDefaultHost((String)event.getNewValue());
        }
    }

    private void removeAlias(String alias) {
        if (this.debug >= 3) {
            this.engine.log("Removing alias '" + alias + "'");
        }
        this.cache.remove(alias.toLowerCase());
    }

    private void removeHost(Host host) {
        if (this.debug >= 3) {
            this.engine.log("Removing host '" + host.getName() + "'");
        }
        host.removeContainerListener(this);
        ArrayList<String> removes = new ArrayList<String>();
        Iterator<Object> keys = this.cache.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!host.equals((Host)this.cache.get(key))) continue;
            removes.add(key);
        }
        keys = ((AbstractList)removes).iterator();
        while (keys.hasNext()) {
            this.removeAlias((String)keys.next());
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardEngine)) {
            throw new IllegalArgumentException(sm.getString("httpEngineMapper.container"));
        }
        this.engine = (StandardEngine)container;
    }

    private void setDefaultHost(String name) {
        if (this.debug >= 3) {
            this.engine.log("Setting default host '" + name + "'");
        }
        this.defaultHost = name == null ? null : (Host)this.engine.findChild(name);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("fastEngineMapper.alreadyStarted", this.engine.getName()));
        }
        this.started = true;
        this.engine.addContainerListener(this);
        this.engine.addPropertyChangeListener(this);
        this.setDefaultHost(this.engine.getDefaultHost());
        Container[] children = this.engine.findChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.addHost((Host)children[i2]);
            ++i2;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("fastEngineMapper.notStarted", this.engine.getName()));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.engine.removePropertyChangeListener(this);
        this.setDefaultHost(null);
        this.engine.removeContainerListener(this);
        this.cache.clear();
    }
}

