/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public final class StandardContextMapper
implements Mapper {
    private StandardContext context = null;
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public Container getContainer() {
        return this.context;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Container map(Request request, boolean update) {
        int slash;
        int debug = this.context.getDebug();
        if (update && request.getWrapper() != null) {
            return request.getWrapper();
        }
        String contextPath = ((HttpServletRequest)request.getRequest()).getContextPath();
        String requestURI = ((HttpServletRequest)request.getRequest()).getRequestURI();
        String relativeURI = requestURI.substring(contextPath.length());
        if (debug >= 1) {
            this.context.log("Mapping contextPath='" + contextPath + "' with requestURI='" + requestURI + "' and relativeURI='" + relativeURI + "'");
        }
        try {
            relativeURI = RequestUtil.URLDecode(relativeURI);
            this.validate(relativeURI);
            if (debug >= 1) {
                this.context.log("Decoded relativeURI='" + relativeURI + "'");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(sm.getString("standardContext.urlDecode", relativeURI));
        }
        Wrapper wrapper = null;
        String servletPath = relativeURI;
        String pathInfo = null;
        String name = null;
        if (wrapper == null) {
            if (debug >= 2) {
                this.context.log("  Trying exact match");
            }
            if ((name = this.context.findServletMapping(relativeURI)) != null) {
                wrapper = (Wrapper)this.context.findChild(name);
            }
            if (wrapper != null) {
                servletPath = relativeURI;
                pathInfo = null;
            }
        }
        if (wrapper == null) {
            if (debug >= 2) {
                this.context.log("  Trying prefix match");
            }
            servletPath = relativeURI;
            while (true) {
                if ((name = this.context.findServletMapping(String.valueOf(servletPath) + "/*")) != null) {
                    wrapper = (Wrapper)this.context.findChild(name);
                }
                if (wrapper != null) {
                    pathInfo = relativeURI.substring(servletPath.length());
                    if (pathInfo.length() != 0) break;
                    pathInfo = null;
                    break;
                }
                slash = servletPath.lastIndexOf(47);
                if (slash < 0) break;
                servletPath = servletPath.substring(0, slash);
            }
        }
        if (wrapper == null) {
            String last;
            int period;
            if (debug >= 2) {
                this.context.log("  Trying extension match");
            }
            if ((slash = relativeURI.lastIndexOf(47)) >= 0 && (period = (last = relativeURI.substring(slash)).lastIndexOf(46)) >= 0) {
                String pattern = "*" + last.substring(period);
                name = this.context.findServletMapping(pattern);
                if (name != null) {
                    wrapper = (Wrapper)this.context.findChild(name);
                }
                if (wrapper != null) {
                    servletPath = relativeURI;
                    pathInfo = null;
                }
            }
        }
        if (wrapper == null) {
            if (debug >= 2) {
                this.context.log("  Trying default match");
            }
            if ((name = this.context.findServletMapping("/")) != null) {
                wrapper = (Wrapper)this.context.findChild(name);
            }
            if (wrapper != null) {
                servletPath = relativeURI;
                pathInfo = null;
            }
        }
        if (debug >= 1 && wrapper != null) {
            this.context.log(" Mapped to servlet '" + wrapper.getName() + "' with servlet path '" + servletPath + "' and path info '" + pathInfo + "' and update=" + update);
        }
        if (update) {
            request.setWrapper(wrapper);
            ((HttpRequest)request).setServletPath(servletPath);
            ((HttpRequest)request).setPathInfo(pathInfo);
        }
        return wrapper;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardContext)) {
            throw new IllegalArgumentException(sm.getString("httpContextMapper.container"));
        }
        this.context = (StandardContext)container;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    private void validate(String relativeURI) {
        int n2 = relativeURI.length();
        int i2 = 0;
        while (i2 < n2) {
            char c10 = relativeURI.charAt(i2);
            if (c10 < ' ' || c10 == '\u007f') {
                throw new IllegalArgumentException(sm.getString("standardContext.urlValidate", relativeURI));
            }
            ++i2;
        }
    }
}

