/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardService
implements Lifecycle,
Service {
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;

    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e10) {
                    e10.printStackTrace(System.err);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException lifecycleException) {}
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardService.initialize.initialized"));
        }
        this.initialized = true;
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i2 = 0;
            while (i2 < this.connectors.length) {
                this.connectors[i2].initialize();
                ++i2;
            }
        }
    }

    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int j2 = -1;
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (connector == this.connectors[i2]) {
                    j2 = i2;
                    break;
                }
                ++i2;
            }
            if (j2 < 0) {
                Object var3_5 = null;
                return;
            }
            if (this.started && this.connectors[j2] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[j2])).stop();
                }
                catch (LifecycleException lifecycleException) {}
            }
            this.connectors[j2].setContainer(null);
            connector.setService(null);
            int k2 = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            int i3 = 0;
            while (i3 < this.connectors.length) {
                if (i3 != j2) {
                    results[k2++] = this.connectors[i3];
                }
                ++i3;
            }
            this.connectors = results;
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setContainer(Container container) {
        block11: {
            Container oldContainer = this.container;
            if (oldContainer != null && oldContainer instanceof Engine) {
                ((Engine)oldContainer).setService(null);
            }
            this.container = container;
            if (this.container != null && this.container instanceof Engine) {
                ((Engine)this.container).setService(this);
            }
            if (this.started && this.container != null && this.container instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.container)).start();
                }
                catch (LifecycleException lifecycleException) {}
            }
            Connector[] connectorArray = this.connectors;
            synchronized (connectorArray) {
                int i2 = 0;
                while (i2 < this.connectors.length) {
                    this.connectors[i2].setContainer(this.container);
                    ++i2;
                }
            }
            if (!this.started || oldContainer == null || !(oldContainer instanceof Lifecycle)) break block11;
            try {
                ((Lifecycle)((Object)oldContainer)).stop();
            }
            catch (LifecycleException lifecycleException) {}
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardService.start.started"));
        }
        System.out.println(sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Connector[] connectorArray = this.container;
        synchronized (connectorArray) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
        }
        connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (this.connectors[i2] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i2])).start();
                }
                ++i2;
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardService.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        System.out.println(sm.getString("standardService.stop.name", this.name));
        this.started = false;
        Object object = this.connectors;
        synchronized (object) {
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (this.connectors[i2] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i2])).stop();
                }
                ++i2;
            }
        }
        object = this.container;
        synchronized (object) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).stop();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

