/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.util.RequestUtil;

public final class SecurityCollection {
    private String description = null;
    private String[] methods = new String[0];
    private String name = null;
    private String[] patterns = new String[0];

    public SecurityCollection() {
        this(null, null);
    }

    public SecurityCollection(String name) {
        this(name, null);
    }

    public SecurityCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public void addMethod(String method) {
        if (method == null) {
            return;
        }
        String[] results = new String[this.methods.length + 1];
        int i2 = 0;
        while (i2 < this.methods.length) {
            results[i2] = this.methods[i2];
            ++i2;
        }
        results[this.methods.length] = method;
        this.methods = results;
    }

    public void addPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        pattern = RequestUtil.URLDecode(pattern);
        String[] results = new String[this.patterns.length + 1];
        int i2 = 0;
        while (i2 < this.patterns.length) {
            results[i2] = this.patterns[i2];
            ++i2;
        }
        results[this.patterns.length] = pattern;
        this.patterns = results;
    }

    public boolean findMethod(String method) {
        if (this.methods.length == 0) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.methods.length) {
            if (this.methods[i2].equals(method)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public String[] findMethods() {
        return this.methods;
    }

    public boolean findPattern(String pattern) {
        int i2 = 0;
        while (i2 < this.patterns.length) {
            if (this.patterns[i2].equals(pattern)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public String[] findPatterns() {
        return this.patterns;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void removeMethod(String method) {
        if (method == null) {
            return;
        }
        int n2 = -1;
        int i2 = 0;
        while (i2 < this.methods.length) {
            if (this.methods[i2].equals(method)) {
                n2 = i2;
                break;
            }
            ++i2;
        }
        if (n2 >= 0) {
            int j2 = 0;
            String[] results = new String[this.methods.length - 1];
            int i3 = 0;
            while (i3 < this.methods.length) {
                if (i3 != n2) {
                    results[j2++] = this.methods[i3];
                }
                ++i3;
            }
            this.methods = results;
        }
    }

    public void removePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        int n2 = -1;
        int i2 = 0;
        while (i2 < this.patterns.length) {
            if (this.patterns[i2].equals(pattern)) {
                n2 = i2;
                break;
            }
            ++i2;
        }
        if (n2 >= 0) {
            int j2 = 0;
            String[] results = new String[this.patterns.length - 1];
            int i3 = 0;
            while (i3 < this.patterns.length) {
                if (i3 != n2) {
                    results[j2++] = this.patterns[i3];
                }
                ++i3;
            }
            this.patterns = results;
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityCollection[");
        sb.append(this.name);
        if (this.description != null) {
            sb.append(", ");
            sb.append(this.description);
        }
        sb.append("]");
        return sb.toString();
    }
}

