/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WebappClassLoader
extends URLClassLoader
implements Reloader,
Lifecycle {
    protected DirContext resources = null;
    protected ArrayList available = new ArrayList();
    protected HashMap resourceEntries = new HashMap();
    protected HashMap notFoundResources = new HashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList required = new ArrayList();
    private ArrayList permissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected boolean started = false;
    private Permission allPermission = new AllPermission();

    public WebappClassLoader(ClassLoader parent, DirContext resources) {
        super(new URL[0], parent);
        this.resources = resources;
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(DirContext resources) {
        super(new URL[0]);
        this.resources = resources;
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i2;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addJar(" + jar + ")");
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            String[] result = new String[this.jarNames.length + 1];
            i2 = 0;
            while (i2 < this.jarNames.length) {
                result[i2] = this.jarNames[i2];
                ++i2;
            }
            result[this.jarNames.length] = jarName;
            this.jarNames = result;
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        i2 = 0;
        while (i2 < this.jarFiles.length) {
            result2[i2] = this.jarFiles[i2];
            ++i2;
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        try {
            long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
            String[] result = new String[this.paths.length + 1];
            i2 = 0;
            while (i2 < this.paths.length) {
                result[i2] = this.paths[i2];
                ++i2;
            }
            result[this.paths.length] = jar;
            this.paths = result;
            long[] result3 = new long[this.lastModifiedDates.length + 1];
            i2 = 0;
            while (i2 < this.lastModifiedDates.length) {
                result3[i2] = this.lastModifiedDates[i2];
                ++i2;
            }
            result3[this.lastModifiedDates.length] = lastModified;
            this.lastModifiedDates = result3;
        }
        catch (NamingException namingException) {}
        File[] result4 = new File[this.jarRealFiles.length + 1];
        i2 = 0;
        while (i2 < this.jarRealFiles.length) {
            result4[i2] = this.jarRealFiles[i2];
            ++i2;
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            Iterator extensions = Extension.getAvailable(manifest).iterator();
            while (extensions.hasNext()) {
                this.available.add(extensions.next());
            }
            extensions = Extension.getRequired(manifest).iterator();
            while (extensions.hasNext()) {
                this.required.add(extensions.next());
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL url = new URL(repository);
            super.addURL(url);
        }
        catch (MalformedURLException e10) {
            throw new IllegalArgumentException(e10.toString());
        }
    }

    synchronized void addRepository(String repository, File file) {
        if (repository == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addRepository(" + repository + ")");
        }
        String[] result = new String[this.repositories.length + 1];
        int i2 = 0;
        while (i2 < this.repositories.length) {
            result[i2] = this.repositories[i2];
            ++i2;
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        i2 = 0;
        while (i2 < this.files.length) {
            result2[i2] = this.files[i2];
            ++i2;
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    public Extension[] findAvailable() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator available = ((AbstractList)this.available).iterator();
        while (available.hasNext()) {
            results.add(available.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof WebappClassLoader)) continue;
            extensions = ((WebappClassLoader)loader).findAvailable();
            int i2 = 0;
            while (i2 < extensions.length) {
                results.add(extensions[i2]);
                ++i2;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        int i2;
        if (this.debug >= 3) {
            this.log("    findClass(" + name + ")");
        }
        if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i2));
            }
            catch (Exception se) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      findClassInternal(" + name + ")");
            }
            try {
                clazz = this.findClassInternal(name);
            }
            catch (AccessControlException ace) {
                ace.printStackTrace();
                throw new ClassNotFoundException(name);
            }
            catch (RuntimeException e10) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", e10);
                }
                throw e10;
            }
            if (clazz == null) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException accessControlException) {
                    throw new ClassNotFoundException(name);
                }
                catch (RuntimeException e11) {
                    if (this.debug >= 4) {
                        this.log("      -->RuntimeException Rethrown", e11);
                    }
                    throw e11;
                }
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e12) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", e12);
            }
            throw e12;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    protected Class findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = String.valueOf(tempPath) + ".class";
        ResourceEntry entry = null;
        if (this.securityManager != null) {
            PrivilegedFindResource dp2 = new PrivilegedFindResource(name, classPath);
            entry = (ResourceEntry)AccessController.doPrivileged(dp2);
        } else {
            entry = this.findResourceInternal(name, classPath);
        }
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            packageName = name.substring(0, pos);
        }
        Package pkg = null;
        if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
            if (entry.manifest == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                this.definePackage(packageName, entry.manifest, entry.source);
            }
        }
        CodeSource codeSource = new CodeSource(entry.source, entry.certificates);
        if (this.securityManager != null && pkg != null) {
            boolean sealCheck = true;
            if (pkg.isSealed()) {
                sealCheck = pkg.isSealed(entry.source);
            } else {
                boolean bl2 = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
            }
            if (!sealCheck) {
                throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
            }
        }
        ResourceEntry resourceEntry = entry;
        synchronized (resourceEntry) {
            if (entry.loadedClass == null) {
                entry.loadedClass = clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, codeSource);
            } else {
                clazz = entry.loadedClass;
            }
        }
        return clazz;
    }

    protected Class findLoadedClass0(String name) {
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public Extension[] findRequired() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator required = ((AbstractList)this.required).iterator();
        while (required.hasNext()) {
            results.add(required.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof WebappClassLoader)) continue;
            extensions = ((WebappClassLoader)loader).findRequired();
            int i2 = 0;
            while (i2 < extensions.length) {
                results.add(extensions[i2]);
                ++i2;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public URL findResource(String name) {
        if (this.debug >= 3) {
            this.log("    findResource(" + name + ")");
        }
        URL url = null;
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry == null) {
            if (this.securityManager != null) {
                PrivilegedFindResource dp2 = new PrivilegedFindResource(name, name);
                entry = (ResourceEntry)AccessController.doPrivileged(dp2);
            } else {
                entry = this.findResourceInternal(name, name);
            }
        }
        if (entry != null) {
            url = entry.source;
        }
        if (url == null) {
            url = super.findResource(name);
        }
        if (this.debug >= 3) {
            if (url != null) {
                this.log("    --> Returning '" + url.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    protected ResourceEntry findResourceInternal(String name, String path) {
        Object jarFakeUrl;
        if (!this.started) {
            this.log("Lifecycle error : CL stopped");
            return null;
        }
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null) {
            return entry;
        }
        int contentLength = -1;
        InputStream binaryStream = null;
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        Resource resource = null;
        int i2 = 0;
        while (entry == null && i2 < repositoriesLength) {
            try {
                String fullPath = String.valueOf(this.repositories[i2]) + path;
                resource = (Resource)this.resources.lookup(fullPath);
                entry = new ResourceEntry();
                try {
                    entry.source = new File(this.files[i2], path).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(fullPath);
                contentLength = (int)attributes.getContentLength();
                entry.lastModified = attributes.getLastModified();
                try {
                    binaryStream = resource.streamContent();
                }
                catch (IOException iOException) {
                    return null;
                }
                String[] stringArray = this.paths;
                synchronized (stringArray) {
                    long[] result2 = new long[this.lastModifiedDates.length + 1];
                    int j2 = 0;
                    while (j2 < this.lastModifiedDates.length) {
                        result2[j2] = this.lastModifiedDates[j2];
                        ++j2;
                    }
                    result2[this.lastModifiedDates.length] = entry.lastModified;
                    this.lastModifiedDates = result2;
                    String[] result = new String[this.paths.length + 1];
                    j2 = 0;
                    while (j2 < this.paths.length) {
                        result[j2] = this.paths[j2];
                        ++j2;
                    }
                    result[this.paths.length] = fullPath;
                    this.paths = result;
                }
            }
            catch (NamingException namingException) {}
            ++i2;
        }
        if (entry == null && this.notFoundResources.containsKey(name)) {
            return null;
        }
        JarEntry jarEntry = null;
        i2 = 0;
        while (entry == null && i2 < jarFilesLength) {
            jarEntry = this.jarFiles[i2].getJarEntry(path);
            if (jarEntry != null) {
                entry = new ResourceEntry();
                try {
                    jarFakeUrl = this.jarRealFiles[i2].toURL().toString();
                    jarFakeUrl = "jar:" + (String)jarFakeUrl + "!/" + path;
                    entry.source = new URL((String)jarFakeUrl);
                }
                catch (MalformedURLException e10) {
                    e10.printStackTrace();
                    return null;
                }
                entry.certificates = jarEntry.getCertificates();
                contentLength = (int)jarEntry.getSize();
                try {
                    entry.manifest = this.jarFiles[i2].getManifest();
                    binaryStream = this.jarFiles[i2].getInputStream(jarEntry);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ++i2;
        }
        if (entry == null) {
            jarFakeUrl = this.notFoundResources;
            synchronized (jarFakeUrl) {
                this.notFoundResources.put(name, name);
            }
            return null;
        }
        byte[] binaryContent = new byte[contentLength];
        try {
            int n2;
            int pos = 0;
            while ((n2 = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                pos += n2;
            }
            binaryStream.close();
        }
        catch (IOException e11) {
            e11.printStackTrace();
            return null;
        }
        catch (Exception e12) {
            e12.printStackTrace();
            return null;
        }
        entry.binaryContent = binaryContent;
        WebappClassLoader pos = this;
        synchronized (pos) {
            ResourceEntry entry2 = (ResourceEntry)this.resourceEntries.get(name);
            if (entry2 == null) {
                this.resourceEntries.put(name, entry);
            } else {
                entry = entry2;
            }
        }
        return entry;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + name + ")");
        }
        Vector<URL> result = new Vector<URL>();
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        int i2 = 0;
        while (i2 < repositoriesLength) {
            try {
                String fullPath = String.valueOf(this.repositories[i2]) + name;
                this.resources.lookup(fullPath);
                try {
                    result.addElement(new File(this.files[i2], name).toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (NamingException namingException) {}
            ++i2;
        }
        i2 = 0;
        while (i2 < jarFilesLength) {
            JarEntry jarEntry = this.jarFiles[i2].getJarEntry(name);
            if (jarEntry != null) {
                try {
                    String jarFakeUrl = this.jarRealFiles[i2].toURL().toString();
                    jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                    result.addElement(new URL(jarFakeUrl));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i2;
        }
        Enumeration<URL> otherResourcePaths = super.findResources(name);
        while (otherResourcePaths.hasMoreElements()) {
            result.addElement(otherResourcePaths.nextElement());
        }
        return result.elements();
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = (PermissionCollection)this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            Iterator perms = ((AbstractList)this.permissionList).iterator();
            while (perms.hasNext()) {
                Permission p2 = (Permission)perms.next();
                pc.add(p2);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    public URL getResource(String name) {
        ClassLoader loader;
        if (this.debug >= 2) {
            this.log("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException iOException) {}
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public URL[] getURLs() {
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int length = filesLength + jarFilesLength + external.length;
        try {
            URL[] urls = new URL[length];
            int i2 = 0;
            while (i2 < length) {
                urls[i2] = i2 < filesLength ? this.files[i2].toURL() : (i2 < filesLength + jarFilesLength ? this.jarRealFiles[i2 - filesLength].toURL() : external[i2 - filesLength - jarFilesLength]);
                ++i2;
            }
            return urls;
        }
        catch (MalformedURLException malformedURLException) {
            return new URL[0];
        }
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = String.valueOf(name) + "/";
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i2;
        if (this.debug >= 2) {
            this.log("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            this.log("Lifecycle error : CL stopped");
            throw new ClassNotFoundException(name);
        }
        clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.startsWith("java.")) {
            ClassLoader loader = this.system;
            clazz = loader.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i2));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                System.out.println(error);
                se.printStackTrace();
                this.log(error);
                throw new ClassNotFoundException(error);
            }
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    private void log(String message) {
        System.out.println("WebappClassLoader: " + message);
    }

    private void log(String message, Throwable throwable) {
        System.out.println("WebappClassLoader: " + message);
        throwable.printStackTrace(System.out);
    }

    public boolean modified() {
        block16: {
            int length2;
            int length;
            if (this.debug >= 2) {
                this.log("modified()");
            }
            if ((length = this.paths.length) > (length2 = this.lastModifiedDates.length)) {
                length = length2;
            }
            int i2 = 0;
            while (i2 < length) {
                try {
                    long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i2])).getLastModified();
                    if (lastModified != this.lastModifiedDates[i2]) {
                        this.log("  Resource '" + this.paths[i2] + "' was modified; Date is now: " + new Date(lastModified) + " Was: " + new Date(this.lastModifiedDates[i2]));
                        return true;
                    }
                }
                catch (NamingException namingException) {
                    this.log("    Resource '" + this.paths[i2] + "' is missing");
                    return true;
                }
                ++i2;
            }
            length = this.jarNames.length;
            if (this.getJarPath() == null) break block16;
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> namingEnumeration = this.resources.listBindings(this.getJarPath());
                int i3 = 0;
                while (namingEnumeration.hasMoreElements() && i3 < length) {
                    ncPair = (NameClassPair)namingEnumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar")) continue;
                    if (!name.equals(this.jarNames[i3])) {
                        this.log("    Additional JARs have been added : '" + name + "'");
                        return true;
                    }
                    ++i3;
                }
                if (namingEnumeration.hasMoreElements()) {
                    while (namingEnumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)namingEnumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar")) continue;
                        this.log("    Additional JARs have been added");
                        return true;
                    }
                } else if (i3 < this.jarNames.length) {
                    this.log("    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException namingException) {
                if (this.debug > 2) {
                    this.log("    Failed tracking modifications of '" + this.getJarPath() + "'");
                }
            }
            catch (ClassCastException e10) {
                this.log("    Failed tracking modifications of '" + this.getJarPath() + "' : " + e10.getMessage());
            }
        }
        return false;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {}
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setPermissions(String path) {
        if (this.securityManager != null) {
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                this.permissionList.add(new JndiPermission(String.valueOf(path) + "*"));
            } else {
                this.permissionList.add(new FilePermission(String.valueOf(path) + "-", "read"));
            }
        }
    }

    public void setPermissions(URL url) {
        this.setPermissions(url.toString());
    }

    public void start() throws LifecycleException {
        this.started = true;
    }

    public void stop() throws LifecycleException {
        this.started = false;
        int length = this.jarFiles.length;
        int i2 = 0;
        while (i2 < length) {
            try {
                this.jarFiles[i2].close();
                this.jarFiles[i2] = null;
            }
            catch (IOException iOException) {}
            ++i2;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.repositories = new String[0];
        this.files = new File[0];
        this.jarFiles = new JarFile[0];
        this.jarRealFiles = new File[0];
        this.jarPath = null;
        this.jarNames = new String[0];
        this.lastModifiedDates = new long[0];
        this.paths = new String[0];
        this.required.clear();
        this.permissionList.clear();
        this.loaderPC.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebappClassLoader\r\n");
        sb.append("  available:\r\n");
        Iterator available = ((AbstractList)this.available).iterator();
        while (available.hasNext()) {
            sb.append("    ");
            sb.append(available.next().toString());
            sb.append("\r\n");
        }
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        int i2 = 0;
        while (i2 < this.repositories.length) {
            sb.append("    ");
            sb.append(this.repositories[i2]);
            sb.append("\r\n");
            ++i2;
        }
        sb.append("  required:\r\n");
        Iterator required = ((AbstractList)this.required).iterator();
        while (required.hasNext()) {
            sb.append("    ");
            sb.append(required.next().toString());
            sb.append("\r\n");
        }
        if (this.getParent() != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.getParent().toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("java.")) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return true;
        }
        packageName = name.substring(0, pos);
        if (packageName.equals("javax.servlet")) {
            return false;
        }
        if (packageName.equals("javax.servlet.http")) {
            return false;
        }
        if (packageName.equals("javax.servlet.jsp")) {
            return false;
        }
        return !packageName.equals("javax.servlet.jsp.tagext");
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction {
        private String name;
        private String path;

        PrivilegedFindResource(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public Object run() {
            return WebappClassLoader.this.findResourceInternal(this.name, this.path);
        }
    }

    protected static class ResourceEntry {
        long lastModified;
        byte[] binaryContent;
        Class loadedClass;
        URL source;
        Manifest manifest = null;
        Certificate[] certificates = null;

        protected ResourceEntry() {
        }
    }
}

