/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CGIServlet
extends HttpServlet {
    private ServletContext context = null;
    private int debug = 0;
    private int iClientInputTimeout = 100;
    private String cgiPathPrefix = null;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            if (req.getAttribute("org.apache.catalina.INVOKED") != null) {
                throw new UnavailableException("Cannot invoke CGIServlet through the invoker");
            }
            CGIEnvironment cgiEnv = new CGIEnvironment(req, this.getServletContext());
            if (cgiEnv.isValid()) {
                CGIRunner cgi = new CGIRunner(cgiEnv.getCommand(), cgiEnv.getEnvironment(), cgiEnv.getWorkingDirectory(), cgiEnv.getParameters());
                if ("POST".equals(req.getMethod())) {
                    cgi.setInput(req.getInputStream());
                }
                cgi.setResponse(res);
                cgi.run();
            }
            if (req.getParameter("X_TOMCAT_CGI_DEBUG") == null && cgiEnv.isValid()) break block7;
            try {
                ServletOutputStream out = res.getOutputStream();
                out.println("<HTML><HEAD><TITLE>$Name: J2EE_131_04 $</TITLE></HEAD>");
                out.println("<BODY>$Header: /home/cvspublic/jakarta-tomcat-4.0/catalina/src/share/org/apache/catalina/servlets/CGIServlet.java,v 1.6 2001/08/20 02:42:11 amyroh Exp $<p>");
                if (cgiEnv.isValid()) {
                    out.println(cgiEnv.toString());
                } else {
                    res.setStatus(404);
                    out.println("<H3>");
                    out.println("CGI script not found or not specified.");
                    out.println("</H3>");
                    out.println("<H4>");
                    out.println("Check the <b>HttpServletRequest ");
                    out.println("<a href=\"#pathInfo\">pathInfo</a></b> ");
                    out.println("property to see if it is what you meant ");
                    out.println("it to be.  You must specify an existant ");
                    out.println("and executable file as part of the ");
                    out.println("path-info.");
                    out.println("</H4>");
                    out.println("<H4>");
                    out.println("For a good discussion of how CGI scripts ");
                    out.println("work and what their environment variables ");
                    out.println("mean, please visit the <a ");
                    out.println("href=\"http://cgi-spec.golux.com\">CGI ");
                    out.println("Specification page</a>.");
                    out.println("</H4>");
                }
                this.printServletEnvironment(out, req, res);
                out.println("</BODY></HTML>");
            }
            catch (IOException iOException) {}
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String servletName = this.getServletConfig().getServletName();
        if (servletName == null) {
            servletName = "";
        }
        if (servletName.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException("Cannot invoke CGIServlet through the invoker");
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
            this.cgiPathPrefix = this.getServletConfig().getInitParameter("cgiPathPrefix");
            value = this.getServletConfig().getInitParameter("iClientInputTimeout");
            this.iClientInputTimeout = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        this.log("init: loglevel set to " + this.debug);
        this.context = config.getServletContext();
    }

    public static void main(String[] args) {
        System.out.println("$Header: /home/cvspublic/jakarta-tomcat-4.0/catalina/src/share/org/apache/catalina/servlets/CGIServlet.java,v 1.6 2001/08/20 02:42:11 amyroh Exp $");
    }

    protected void printServletEnvironment(ServletOutputStream out, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String value;
        String param;
        String attr;
        out.println("<h1>ServletRequest Properties</h1>");
        out.println("<ul>");
        Enumeration attrs = req.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr2 = (String)attrs.nextElement();
            out.println("<li><b>attribute</b> " + attr2 + " = " + req.getAttribute(attr2));
        }
        out.println("<li><b>characterEncoding</b> = " + req.getCharacterEncoding());
        out.println("<li><b>contentLength</b> = " + req.getContentLength());
        out.println("<li><b>contentType</b> = " + req.getContentType());
        Enumeration locales = req.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            out.println("<li><b>locale</b> = " + locale);
        }
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String param2 = (String)params.nextElement();
            String[] values = req.getParameterValues(param2);
            int i2 = 0;
            while (i2 < values.length) {
                out.println("<li><b>parameter</b> " + param2 + " = " + values[i2]);
                ++i2;
            }
        }
        out.println("<li><b>protocol</b> = " + req.getProtocol());
        out.println("<li><b>remoteAddr</b> = " + req.getRemoteAddr());
        out.println("<li><b>remoteHost</b> = " + req.getRemoteHost());
        out.println("<li><b>scheme</b> = " + req.getScheme());
        out.println("<li><b>secure</b> = " + req.isSecure());
        out.println("<li><b>serverName</b> = " + req.getServerName());
        out.println("<li><b>serverPort</b> = " + req.getServerPort());
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>HttpServletRequest Properties</h1>");
        out.println("<ul>");
        out.println("<li><b>authType</b> = " + req.getAuthType());
        out.println("<li><b>contextPath</b> = " + req.getContextPath());
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i3 = 0;
            while (i3 < cookies.length) {
                out.println("<li><b>cookie</b> " + cookies[i3].getName() + " = " + cookies[i3].getValue());
                ++i3;
            }
        }
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            out.println("<li><b>header</b> " + header + " = " + req.getHeader(header));
        }
        out.println("<li><b>method</b> = " + req.getMethod());
        out.println("<li><a name=\"pathInfo\"><b>pathInfo</b></a> = " + req.getPathInfo());
        out.println("<li><b>pathTranslated</b> = " + req.getPathTranslated());
        out.println("<li><b>queryString</b> = " + req.getQueryString());
        out.println("<li><b>remoteUser</b> = " + req.getRemoteUser());
        out.println("<li><b>requestedSessionId</b> = " + req.getRequestedSessionId());
        out.println("<li><b>requestedSessionIdFromCookie</b> = " + req.isRequestedSessionIdFromCookie());
        out.println("<li><b>requestedSessionIdFromURL</b> = " + req.isRequestedSessionIdFromURL());
        out.println("<li><b>requestedSessionIdValid</b> = " + req.isRequestedSessionIdValid());
        out.println("<li><b>requestURI</b> = " + req.getRequestURI());
        out.println("<li><b>servletPath</b> = " + req.getServletPath());
        out.println("<li><b>userPrincipal</b> = " + req.getUserPrincipal());
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>ServletRequest Attributes</h1>");
        out.println("<ul>");
        attrs = req.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr3 = (String)attrs.nextElement();
            out.println("<li><b>" + attr3 + "</b> = " + req.getAttribute(attr3));
        }
        out.println("</ul>");
        out.println("<hr>");
        HttpSession session = req.getSession(false);
        if (session != null) {
            out.println("<h1>HttpSession Properties</h1>");
            out.println("<ul>");
            out.println("<li><b>id</b> = " + session.getId());
            out.println("<li><b>creationTime</b> = " + new Date(session.getCreationTime()));
            out.println("<li><b>lastAccessedTime</b> = " + new Date(session.getLastAccessedTime()));
            out.println("<li><b>maxInactiveInterval</b> = " + session.getMaxInactiveInterval());
            out.println("</ul>");
            out.println("<hr>");
            out.println("<h1>HttpSession Attributes</h1>");
            out.println("<ul>");
            attrs = session.getAttributeNames();
            while (attrs.hasMoreElements()) {
                attr = (String)attrs.nextElement();
                out.println("<li><b>" + attr + "</b> = " + session.getAttribute(attr));
            }
            out.println("</ul>");
            out.println("<hr>");
        }
        out.println("<h1>ServletConfig Properties</h1>");
        out.println("<ul>");
        out.println("<li><b>servletName</b> = " + this.getServletConfig().getServletName());
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>ServletConfig Initialization Parameters</h1>");
        out.println("<ul>");
        params = this.getServletConfig().getInitParameterNames();
        while (params.hasMoreElements()) {
            param = (String)params.nextElement();
            value = this.getServletConfig().getInitParameter(param);
            out.println("<li><b>" + param + "</b> = " + value);
        }
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>ServletContext Properties</h1>");
        out.println("<ul>");
        out.println("<li><b>majorVersion</b> = " + this.getServletContext().getMajorVersion());
        out.println("<li><b>minorVersion</b> = " + this.getServletContext().getMinorVersion());
        out.println("<li><b>realPath('/')</b> = " + this.getServletContext().getRealPath("/"));
        out.println("<li><b>serverInfo</b> = " + this.getServletContext().getServerInfo());
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>ServletContext Initialization Parameters</h1>");
        out.println("<ul>");
        params = this.getServletContext().getInitParameterNames();
        while (params.hasMoreElements()) {
            param = (String)params.nextElement();
            value = this.getServletContext().getInitParameter(param);
            out.println("<li><b>" + param + "</b> = " + value);
        }
        out.println("</ul>");
        out.println("<hr>");
        out.println("<h1>ServletContext Attributes</h1>");
        out.println("<ul>");
        attrs = this.getServletContext().getAttributeNames();
        while (attrs.hasMoreElements()) {
            attr = (String)attrs.nextElement();
            out.println("<li><b>" + attr + "</b> = " + this.getServletContext().getAttribute(attr));
        }
        out.println("</ul>");
        out.println("<hr>");
    }

    protected class CGIEnvironment {
        private ServletContext context = null;
        private String contextPath = null;
        private String servletPath = null;
        private String pathInfo = null;
        private String webAppRootDir = null;
        private Hashtable env = null;
        private String command = null;
        private File workingDirectory = null;
        private Hashtable queryParameters = null;
        private boolean valid = false;

        protected CGIEnvironment(HttpServletRequest req, ServletContext context) {
            this.setupFromContext(context);
            this.setupFromRequest(req);
            this.queryParameters = new Hashtable();
            Enumeration paramNames = req.getParameterNames();
            while (paramNames != null && paramNames.hasMoreElements()) {
                String param = paramNames.nextElement().toString();
                if (param == null) continue;
                this.queryParameters.put(param, URLEncoder.encode(req.getParameter(param)));
            }
            this.valid = this.setCGIEnvironment(req);
            if (this.valid) {
                this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
            }
        }

        protected String blanksToString(String couldBeBlank, String subForBlanks) {
            return "".equals(couldBeBlank) || couldBeBlank == null ? subForBlanks : couldBeBlank;
        }

        protected String[] findCGI(String pathInfo, String webAppRootDir, String contextPath, String servletPath, String cgiPathPrefix) {
            String path = null;
            String name = null;
            String scriptname = null;
            String cginame = null;
            if (webAppRootDir != null && webAppRootDir.lastIndexOf(File.separator) == webAppRootDir.length() - 1) {
                webAppRootDir = webAppRootDir.substring(0, webAppRootDir.length() - 1);
            }
            if (cgiPathPrefix != null) {
                webAppRootDir = String.valueOf(webAppRootDir) + File.separator + cgiPathPrefix;
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: path=" + pathInfo + ", " + webAppRootDir);
            }
            File currentLocation = new File(webAppRootDir);
            StringTokenizer dirWalker = new StringTokenizer(pathInfo, File.separator);
            if (CGIServlet.this.debug >= 3) {
                CGIServlet.this.log("findCGI: currentLoc=" + currentLocation);
            }
            while (!currentLocation.isFile() && dirWalker.hasMoreElements()) {
                if (CGIServlet.this.debug >= 3) {
                    CGIServlet.this.log("findCGI: currentLoc=" + currentLocation);
                }
                currentLocation = new File(currentLocation, (String)dirWalker.nextElement());
            }
            if (!currentLocation.isFile()) {
                return new String[]{null, null, null, null};
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: FOUND cgi at " + currentLocation);
            }
            path = currentLocation.getAbsolutePath();
            name = currentLocation.getName();
            cginame = String.valueOf(currentLocation.getParent().substring(webAppRootDir.length())) + File.separator + name;
            scriptname = ".".equals(contextPath) ? String.valueOf(servletPath) + cginame : String.valueOf(contextPath) + servletPath + cginame;
            if (CGIServlet.this.debug >= 1) {
                CGIServlet.this.log("findCGI calc: name=" + name + ", path=" + path + ", scriptname=" + scriptname + ", cginame=" + cginame);
            }
            return new String[]{path, scriptname, cginame, name};
        }

        protected String getCommand() {
            return this.command;
        }

        protected Hashtable getEnvironment() {
            return this.env;
        }

        protected Hashtable getParameters() {
            return this.queryParameters;
        }

        protected File getWorkingDirectory() {
            return this.workingDirectory;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected String nullsToBlanks(String s2) {
            return this.nullsToString(s2, "");
        }

        protected String nullsToString(String couldBeNull, String subForNulls) {
            return couldBeNull == null ? subForNulls : couldBeNull;
        }

        protected boolean setCGIEnvironment(HttpServletRequest req) {
            Hashtable<String, String> envp = new Hashtable<String, String>();
            String sPathInfoOrig = null;
            String sPathTranslatedOrig = null;
            String sPathInfoCGI = null;
            String sPathTranslatedCGI = null;
            String sCGIFullPath = null;
            String sCGIScriptName = null;
            String sCGIFullName = null;
            String sCGIName = null;
            sPathInfoOrig = this.pathInfo;
            sPathInfoOrig = sPathInfoOrig == null ? "" : sPathInfoOrig;
            sPathTranslatedOrig = req.getPathTranslated();
            sPathTranslatedOrig = sPathTranslatedOrig == null ? "" : sPathTranslatedOrig;
            String[] sCGINames = this.findCGI(sPathInfoOrig, this.webAppRootDir, this.contextPath, this.servletPath, CGIServlet.this.cgiPathPrefix);
            sCGIFullPath = sCGINames[0];
            sCGIScriptName = sCGINames[1];
            sCGIFullName = sCGINames[2];
            sCGIName = sCGINames[3];
            if (sCGIFullPath == null || sCGIScriptName == null || sCGIFullName == null || sCGIName == null) {
                return false;
            }
            envp.put("SERVER_SOFTWARE", "TOMCAT");
            envp.put("SERVER_NAME", this.nullsToBlanks(req.getServerName()));
            envp.put("GATEWAY_INTERFACE", "CGI/1.1");
            envp.put("SERVER_PROTOCOL", this.nullsToBlanks(req.getProtocol()));
            int port = req.getServerPort();
            Integer iPort = port == 0 ? new Integer(-1) : new Integer(port);
            envp.put("SERVER_PORT", iPort.toString());
            envp.put("REQUEST_METHOD", this.nullsToBlanks(req.getMethod()));
            sPathInfoCGI = this.pathInfo == null || this.pathInfo.substring(sCGIFullName.length()).length() <= 0 ? "" : this.pathInfo.substring(sCGIFullName.length());
            envp.put("PATH_INFO", sPathInfoCGI);
            sPathTranslatedCGI = sPathInfoCGI != null && !"".equals(sPathInfoCGI) ? this.context.getRealPath(sPathInfoCGI) : null;
            if (sPathTranslatedCGI != null && !"".equals(sPathTranslatedCGI)) {
                envp.put("PATH_TRANSLATED", this.nullsToBlanks(sPathTranslatedCGI));
            }
            envp.put("SCRIPT_NAME", this.nullsToBlanks(sCGIScriptName));
            envp.put("QUERY_STRING", this.nullsToBlanks(req.getQueryString()));
            envp.put("REMOTE_HOST", this.nullsToBlanks(req.getRemoteHost()));
            envp.put("REMOTE_ADDR", this.nullsToBlanks(req.getRemoteAddr()));
            envp.put("AUTH_TYPE", this.nullsToBlanks(req.getAuthType()));
            envp.put("REMOTE_USER", this.nullsToBlanks(req.getRemoteUser()));
            envp.put("REMOTE_IDENT", "");
            envp.put("CONTENT_TYPE", this.nullsToBlanks(req.getContentType()));
            int contentLength = req.getContentLength();
            String sContentLength = contentLength <= 0 ? "" : new Integer(contentLength).toString();
            envp.put("CONTENT_LENGTH", sContentLength);
            Enumeration headers = req.getHeaderNames();
            String header = null;
            while (headers.hasMoreElements()) {
                header = null;
                header = ((String)headers.nextElement()).toUpperCase();
                if ("AUTHORIZATION".equalsIgnoreCase(header) || "PROXY_AUTHORIZATION".equalsIgnoreCase(header)) continue;
                if ("HOST".equalsIgnoreCase(header)) {
                    String host = req.getHeader(header);
                    int idx = host.indexOf(":");
                    if (idx < 0) {
                        idx = host.length();
                    }
                    envp.put("HTTP_" + header.replace('-', '_'), host.substring(0, idx));
                    continue;
                }
                envp.put("HTTP_" + header.replace('-', '_'), req.getHeader(header));
            }
            this.command = sCGIFullPath;
            envp.put("X_TOMCAT_SCRIPT_PATH", this.command);
            this.env = envp;
            return true;
        }

        protected void setupFromContext(ServletContext context) {
            this.context = context;
            this.webAppRootDir = context.getRealPath("/");
        }

        protected void setupFromRequest(HttpServletRequest req) {
            this.contextPath = req.getContextPath();
            this.pathInfo = req.getPathInfo();
            this.servletPath = req.getServletPath();
        }

        public String toString() {
            String s2;
            StringBuffer sb = new StringBuffer();
            sb.append("<TABLE border=2>");
            sb.append("<tr><th colspan=2 bgcolor=grey>");
            sb.append("CGIEnvironment Info</th></tr>");
            sb.append("<tr><td>Debug Level</td><td>");
            sb.append(CGIServlet.this.debug);
            sb.append("</td></tr>");
            sb.append("<tr><td>Validity:</td><td>");
            sb.append(this.isValid());
            sb.append("</td></tr>");
            if (this.isValid()) {
                Enumeration envk = this.env.keys();
                while (envk.hasMoreElements()) {
                    s2 = (String)envk.nextElement();
                    sb.append("<tr><td>");
                    sb.append(s2);
                    sb.append("</td><td>");
                    sb.append(this.blanksToString((String)this.env.get(s2), "[will be set to blank]"));
                    sb.append("</td></tr>");
                }
            }
            sb.append("<tr><td colspan=2><HR></td></tr>");
            sb.append("<tr><td>Derived Command</td><td>");
            sb.append(this.nullsToBlanks(this.command));
            sb.append("</td></tr>");
            sb.append("<tr><td>Working Directory</td><td>");
            if (this.workingDirectory != null) {
                sb.append(this.workingDirectory.toString());
            }
            sb.append("</td></tr>");
            sb.append("<tr><td colspan=2>Query Params</td></tr>");
            Enumeration paramk = this.queryParameters.keys();
            while (paramk.hasMoreElements()) {
                s2 = paramk.nextElement().toString();
                sb.append("<tr><td>");
                sb.append(s2);
                sb.append("</td><td>");
                sb.append(this.queryParameters.get(s2).toString());
                sb.append("</td></tr>");
            }
            sb.append("</TABLE><p>end.");
            return sb.toString();
        }
    }

    protected class CGIRunner {
        private String command = null;
        private Hashtable env = null;
        private File wd = null;
        private Hashtable params = null;
        private InputStream stdin = null;
        private HttpServletResponse response = null;
        private boolean readyToRun = false;

        protected CGIRunner(String command, Hashtable env, File wd, Hashtable params) {
            this.command = command;
            this.env = env;
            this.wd = wd;
            this.params = params;
            this.updateReadyStatus();
        }

        protected String getPostInput(Hashtable params) {
            String lineSeparator = System.getProperty("line.separator");
            Enumeration paramNames = params.keys();
            StringBuffer postInput = new StringBuffer("");
            StringBuffer qs = new StringBuffer("");
            if (paramNames != null && paramNames.hasMoreElements()) {
                while (paramNames.hasMoreElements()) {
                    String k2 = (String)paramNames.nextElement();
                    String v2 = params.get(k2).toString();
                    if (k2.indexOf("=") >= 0 || v2.indexOf("=") >= 0) continue;
                    postInput.append(k2);
                    qs.append(k2);
                    postInput.append("=");
                    qs.append("=");
                    postInput.append(v2);
                    qs.append(v2);
                    postInput.append(lineSeparator);
                    qs.append("&");
                }
            }
            qs.append(lineSeparator);
            return qs.append((Object)postInput).toString();
        }

        protected String[] hashToStringArray(Hashtable h2) throws NullPointerException {
            Vector<String> v2 = new Vector<String>();
            Enumeration e10 = h2.keys();
            while (e10.hasMoreElements()) {
                String k2 = e10.nextElement().toString();
                v2.add(String.valueOf(k2) + "=" + h2.get(k2));
            }
            Object[] strArr = new String[v2.size()];
            v2.copyInto(strArr);
            return strArr;
        }

        protected boolean isReady() {
            return this.readyToRun;
        }

        protected void run() throws IOException {
            if (!this.isReady()) {
                throw new IOException(String.valueOf(this.getClass().getName()) + ": not ready to run.");
            }
            if (CGIServlet.this.debug >= 1) {
                CGIServlet.this.log("runCGI(envp=[" + this.env + "], command=" + this.command + ")");
            }
            if (this.command.indexOf(String.valueOf(File.separator) + "." + File.separator) >= 0 || this.command.indexOf(String.valueOf(File.separator) + "..") >= 0 || this.command.indexOf(".." + File.separator) >= 0) {
                throw new IOException(String.valueOf(this.getClass().getName()) + "Illegal Character in CGI command " + "path ('.' or '..') detected.  Not " + "running CGI [" + this.command + "].");
            }
            Runtime rt = null;
            BufferedReader commandsStdOut = null;
            BufferedReader commandsStdErr = null;
            BufferedOutputStream commandsStdIn = null;
            Process proc = null;
            byte[] bBuf = new byte[1024];
            char[] cBuf = new char[1024];
            int bufRead = -1;
            Enumeration paramNames = this.params.keys();
            StringBuffer cmdAndArgs = new StringBuffer(this.command);
            if (paramNames != null && paramNames.hasMoreElements()) {
                cmdAndArgs.append(" ");
                while (paramNames.hasMoreElements()) {
                    String k2 = (String)paramNames.nextElement();
                    String v2 = this.params.get(k2).toString();
                    if (k2.indexOf("=") >= 0 || v2.indexOf("=") >= 0) continue;
                    cmdAndArgs.append(k2);
                    cmdAndArgs.append("=");
                    v2 = URLEncoder.encode(v2);
                    cmdAndArgs.append(v2);
                    cmdAndArgs.append(" ");
                }
            }
            StringBuffer perlCommand = new StringBuffer("perl ");
            if (this.command.endsWith(".pl") || this.command.endsWith(".cgi")) {
                perlCommand.append(cmdAndArgs.toString());
                cmdAndArgs = perlCommand;
            }
            rt = Runtime.getRuntime();
            proc = rt.exec(cmdAndArgs.toString(), this.hashToStringArray(this.env), this.wd);
            String sContentLength = (String)this.env.get("CONTENT_LENGTH");
            if (!"".equals(sContentLength)) {
                commandsStdIn = new BufferedOutputStream(proc.getOutputStream());
                byte[] content = new byte[Integer.parseInt(sContentLength)];
                this.stdin.read(content);
                commandsStdIn.write(content);
                commandsStdIn.flush();
                commandsStdIn.close();
            }
            boolean isRunning = true;
            commandsStdOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            commandsStdErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedWriter servletContainerStdout = null;
            try {
                if (this.response.getOutputStream() != null) {
                    servletContainerStdout = new BufferedWriter(new OutputStreamWriter(this.response.getOutputStream()));
                }
            }
            catch (IOException iOException) {}
            while (isRunning) {
                try {
                    cBuf = new char[1024];
                    while ((bufRead = commandsStdErr.read(cBuf)) != -1) {
                        if (servletContainerStdout == null) continue;
                        servletContainerStdout.write(cBuf, 0, bufRead);
                    }
                    String line = null;
                    while ((line = commandsStdOut.readLine()) != null && !"".equals(line)) {
                        if (CGIServlet.this.debug >= 2) {
                            CGIServlet.this.log("runCGI: addHeader(\"" + line + "\")");
                        }
                        if (line.startsWith("HTTP")) continue;
                        this.response.addHeader(line.substring(0, line.indexOf(":")).trim(), line.substring(line.indexOf(":") + 1).trim());
                    }
                    cBuf = new char[1024];
                    while ((bufRead = commandsStdOut.read(cBuf)) != -1) {
                        if (servletContainerStdout == null) continue;
                        if (CGIServlet.this.debug >= 4) {
                            CGIServlet.this.log("runCGI: write(\"" + cBuf + "\")");
                        }
                        servletContainerStdout.write(cBuf, 0, bufRead);
                    }
                    if (servletContainerStdout != null) {
                        servletContainerStdout.flush();
                    }
                    proc.exitValue();
                    isRunning = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void setInput(InputStream stdin) {
            this.stdin = stdin;
            this.updateReadyStatus();
        }

        protected void setResponse(HttpServletResponse response) {
            this.response = response;
            this.updateReadyStatus();
        }

        protected void updateReadyStatus() {
            this.readyToRun = this.command != null && this.env != null && this.wd != null && this.params != null && this.response != null;
        }
    }
}

