/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class SnoopAllServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String value;
        String param;
        String attr;
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<head>");
        writer.println("<title>SnoopAllServlet Output</title>");
        writer.println("</head>");
        writer.println("<body bgcolor=\"white\">");
        writer.println("<h1>ServletRequest Properties</h1>");
        writer.println("<ul>");
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr2 = (String)attrs.nextElement();
            writer.println("<li><b>attribute</b> " + attr2 + " = " + request.getAttribute(attr2));
        }
        writer.println("<li><b>characterEncoding</b> = " + request.getCharacterEncoding());
        writer.println("<li><b>contentLength</b> = " + request.getContentLength());
        writer.println("<li><b>contentType</b> = " + request.getContentType());
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            writer.println("<li><b>locale</b> = " + locale);
        }
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param2 = (String)params.nextElement();
            String[] values = request.getParameterValues(param2);
            int i2 = 0;
            while (i2 < values.length) {
                writer.println("<li><b>parameter</b> " + param2 + " = " + values[i2]);
                ++i2;
            }
        }
        writer.println("<li><b>protocol</b> = " + request.getProtocol());
        writer.println("<li><b>remoteAddr</b> = " + request.getRemoteAddr());
        writer.println("<li><b>remoteHost</b> = " + request.getRemoteHost());
        writer.println("<li><b>scheme</b> = " + request.getScheme());
        writer.println("<li><b>secure</b> = " + request.isSecure());
        writer.println("<li><b>serverName</b> = " + request.getServerName());
        writer.println("<li><b>serverPort</b> = " + request.getServerPort());
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>HttpServletRequest Properties</h1>");
        writer.println("<ul>");
        writer.println("<li><b>authType</b> = " + request.getAuthType());
        writer.println("<li><b>contextPath</b> = " + request.getContextPath());
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        int i3 = 0;
        while (i3 < cookies.length) {
            writer.println("<li><b>cookie</b> " + cookies[i3].getName() + " = " + cookies[i3].getValue());
            ++i3;
        }
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            writer.println("<li><b>header</b> " + header + " = " + request.getHeader(header));
        }
        writer.println("<li><b>method</b> = " + request.getMethod());
        writer.println("<li><b>pathInfo</b> = " + request.getPathInfo());
        writer.println("<li><b>pathTranslated</b> = " + request.getPathTranslated());
        writer.println("<li><b>queryString</b> = " + request.getQueryString());
        writer.println("<li><b>remoteUser</b> = " + request.getRemoteUser());
        writer.println("<li><b>requestedSessionId</b> = " + request.getRequestedSessionId());
        writer.println("<li><b>requestedSessionIdFromCookie</b> = " + request.isRequestedSessionIdFromCookie());
        writer.println("<li><b>requestedSessionIdFromURL</b> = " + request.isRequestedSessionIdFromURL());
        writer.println("<li><b>requestedSessionIdValid</b> = " + request.isRequestedSessionIdValid());
        writer.println("<li><b>requestURI</b> = " + request.getRequestURI());
        writer.println("<li><b>servletPath</b> = " + request.getServletPath());
        writer.println("<li><b>userPrincipal</b> = " + request.getUserPrincipal());
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>ServletRequest Attributes</h1>");
        writer.println("<ul>");
        attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr3 = (String)attrs.nextElement();
            writer.println("<li><b>" + attr3 + "</b> = " + request.getAttribute(attr3));
        }
        writer.println("</ul>");
        writer.println("<hr>");
        HttpSession session = request.getSession(false);
        if (session != null) {
            writer.println("<h1>HttpSession Properties</h1>");
            writer.println("<ul>");
            writer.println("<li><b>id</b> = " + session.getId());
            writer.println("<li><b>creationTime</b> = " + new Timestamp(session.getCreationTime()));
            writer.println("<li><b>lastAccessedTime</b> = " + new Timestamp(session.getLastAccessedTime()));
            writer.println("<li><b>maxInactiveInterval</b> = " + session.getMaxInactiveInterval());
            writer.println("</ul>");
            writer.println("<hr>");
            writer.println("<h1>HttpSession Attributes</h1>");
            writer.println("<ul>");
            attrs = session.getAttributeNames();
            while (attrs.hasMoreElements()) {
                attr = (String)attrs.nextElement();
                writer.println("<li><b>" + attr + "</b> = " + session.getAttribute(attr));
            }
            writer.println("</ul>");
            writer.println("<hr>");
        }
        writer.println("<h1>ServletConfig Properties</h1>");
        writer.println("<ul>");
        writer.println("<li><b>servletName</b> = " + this.getServletConfig().getServletName());
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>ServletConfig Initialization Parameters</h1>");
        writer.println("<ul>");
        params = this.getServletConfig().getInitParameterNames();
        while (params.hasMoreElements()) {
            param = (String)params.nextElement();
            value = this.getServletConfig().getInitParameter(param);
            writer.println("<li><b>" + param + "</b> = " + value);
        }
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>ServletContext Properties</h1>");
        writer.println("<ul>");
        writer.println("<li><b>majorVersion</b> = " + this.getServletContext().getMajorVersion());
        writer.println("<li><b>minorVersion</b> = " + this.getServletContext().getMinorVersion());
        writer.println("<li><b>realPath('/')</b> = " + this.getServletContext().getRealPath("/"));
        writer.println("<li><b>serverInfo</b> = " + this.getServletContext().getServerInfo());
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>ServletContext Initialization Parameters</h1>");
        writer.println("<ul>");
        params = this.getServletContext().getInitParameterNames();
        while (params.hasMoreElements()) {
            param = (String)params.nextElement();
            value = this.getServletContext().getInitParameter(param);
            writer.println("<li><b>" + param + "</b> = " + value);
        }
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("<h1>ServletContext Attributes</h1>");
        writer.println("<ul>");
        attrs = this.getServletContext().getAttributeNames();
        while (attrs.hasMoreElements()) {
            attr = (String)attrs.nextElement();
            writer.println("<li><b>" + attr + "</b> = " + this.getServletContext().getAttribute(attr));
        }
        writer.println("</ul>");
        writer.println("<hr>");
        writer.println("</body>");
        writer.println("</html>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

