/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.ssi.ServletOutputStreamWrapper;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiMediator;

public final class SsiInvokerServlet
extends HttpServlet {
    private int debug = 0;
    private boolean buffered = false;
    private Long expires = null;
    private boolean ignoreUnsupportedDirective = false;
    private boolean isVirtualWebappRelative = false;
    private static SsiMediator ssiMediator = null;
    private static final byte[] bStart = new byte[]{60, 33, 45, 45, 35};
    private static final byte[] bEnd = new byte[]{45, 45, 62};

    private boolean byteCmp(byte[] buf, int bIdx, byte[] pattern) {
        int i2 = 0;
        while (i2 < pattern.length) {
            if (buf[bIdx + i2] != pattern[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doGet()");
        }
        this.requestHandler(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doPut()");
        }
        this.requestHandler(req, res);
    }

    private String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return this.normalize(result);
    }

    public void init() throws ServletException {
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("isVirtualWebappRelative");
            this.isVirtualWebappRelative = Integer.parseInt(value) > 0;
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("ignoreUnsupportedDirective");
            this.ignoreUnsupportedDirective = Integer.parseInt(value) > 0;
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("expires");
            this.expires = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.expires = null;
            this.log("Invalid format for expires initParam; expected integer (seconds)");
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("buffered");
            this.buffered = Integer.parseInt(value) > 0;
        }
        catch (Throwable throwable) {}
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    private boolean isSpace(char c10) {
        return c10 == ' ' || c10 == '\n' || c10 == '\t' || c10 == '\r';
    }

    private String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized == null) {
            return null;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private String parseCmd(StringBuffer cmd) throws IndexOutOfBoundsException {
        String modString = cmd.toString().trim().toLowerCase();
        return modString.substring(0, modString.indexOf(32));
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseParam(StringBuffer cmd, int start) {
        bIdx = start;
        i = 0;
        quotes = false;
        inside = false;
        retBuf = new StringBuffer();
        while (bIdx < cmd.length()) {
            block4: {
                if (inside) ** GOTO lbl17
                while (bIdx < cmd.length() && cmd.charAt(bIdx) != '\"') {
                    ++bIdx;
                }
                if (bIdx >= cmd.length()) break;
                inside ^= true;
                break block4;
lbl-1000:
                // 1 sources

                {
                    retBuf.append(cmd.charAt(bIdx));
                    ++bIdx;
lbl17:
                    // 2 sources

                    ** while (bIdx < cmd.length() && cmd.charAt((int)bIdx) != '\"')
                }
lbl18:
                // 1 sources

                retBuf.append('\"');
                inside ^= true;
            }
            ++bIdx;
        }
        str = new StringTokenizer(retBuf.toString(), "\"");
        retString = new String[str.countTokens()];
        while (str.hasMoreTokens()) {
            retString[i++] = str.nextToken();
        }
        return retString;
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseParamType(StringBuffer cmd, int start) {
        bIdx = start;
        i = 0;
        quotes = 0;
        inside = false;
        retBuf = new StringBuffer();
        while (bIdx < cmd.length()) {
            if (inside) ** GOTO lbl17
            while (bIdx < cmd.length() && this.isSpace(cmd.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= cmd.length()) break;
            inside ^= true;
            continue;
lbl-1000:
            // 1 sources

            {
                retBuf.append(cmd.charAt(bIdx));
                ++bIdx;
lbl17:
                // 2 sources

                ** while (bIdx < cmd.length() && cmd.charAt((int)bIdx) != '=')
            }
lbl18:
            // 1 sources

            retBuf.append('\"');
            inside ^= true;
            quotes = 0;
            while (bIdx < cmd.length() && quotes != 2) {
                if (cmd.charAt(bIdx) == '\"') {
                    ++quotes;
                }
                ++bIdx;
            }
        }
        str = new StringTokenizer(retBuf.toString(), "\"");
        retString = new String[str.countTokens()];
        while (str.hasMoreTokens()) {
            retString[i++] = str.nextToken().trim();
        }
        return retString;
    }

    private void requestHandler(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        String path = this.getRelativePath(req);
        URL resource = servletContext.getResource(path);
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.requestHandler()\nServing " + (this.buffered ? "buffered " : "unbuffered ") + "resource '" + path + "'");
        }
        if (path == null || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            res.sendError(404, path);
            return;
        }
        if (resource == null) {
            res.sendError(404, path);
            return;
        }
        res.setContentType("text/html;charset=UTF-8");
        if (this.expires != null) {
            res.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
        }
        ServletOutputStream out = null;
        URLConnection resourceInfo = resource.openConnection();
        InputStream resourceInputStream = resourceInfo.getInputStream();
        BufferedInputStream in = new BufferedInputStream(resourceInputStream, 4096);
        ByteArrayOutputStream soonOut = new ByteArrayOutputStream(resourceInfo.getContentLength());
        StringBuffer command = new StringBuffer();
        byte[] buf = new byte[4096];
        int len = 0;
        int bIdx = 0;
        boolean inside = false;
        SsiCommand ssiCommand = null;
        out = this.buffered ? new ServletOutputStreamWrapper() : res.getOutputStream();
        if (ssiMediator == null) {
            ssiMediator = new SsiMediator(req, res, out, servletContext, this.debug, path, this.isVirtualWebappRelative);
        } else {
            ssiMediator.flush(req, res, out, servletContext, path, this.isVirtualWebappRelative);
        }
        while ((len = ((InputStream)in).read(buf)) != -1) {
            soonOut.write(buf, 0, len);
        }
        soonOut.close();
        byte[] unparsed = soonOut.toByteArray();
        soonOut = null;
        buf = null;
        while (bIdx < unparsed.length) {
            if (!inside) {
                if (unparsed[bIdx] == bStart[0] && this.byteCmp(unparsed, bIdx, bStart)) {
                    inside = true;
                    bIdx += bStart.length;
                    command.delete(0, command.length());
                    continue;
                }
                out.write(unparsed[bIdx]);
                ++bIdx;
                continue;
            }
            if (unparsed[bIdx] == bEnd[0] && this.byteCmp(unparsed, bIdx, bEnd)) {
                String strCmd;
                inside = false;
                bIdx += bEnd.length;
                try {
                    strCmd = this.parseCmd(command);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    out.write(ssiMediator.getError());
                    continue;
                }
                strCmd = this.parseCmd(command);
                String[] strParamType = this.parseParamType(command, strCmd.length());
                String[] strParam = this.parseParam(command, strCmd.length());
                if (this.debug > 0) {
                    this.log("Serving SSI resource: " + strCmd);
                }
                if ((ssiCommand = ssiMediator.getCommand(strCmd)) != null && strParamType.length == strParam.length && strParamType.length > 0) {
                    if (ssiCommand.isPrintable()) {
                        out.write(ssiCommand.getStream(strParamType, strParam).getBytes());
                        continue;
                    }
                    ssiCommand.process(strParamType, strParam);
                    continue;
                }
                if (this.ignoreUnsupportedDirective && ssiCommand == null) continue;
                out.write(ssiMediator.getError());
                continue;
            }
            command.append((char)unparsed[bIdx]);
            ++bIdx;
        }
        if (this.buffered) {
            ((ServletOutputStreamWrapper)out).writeTo(res.getOutputStream());
        }
        out = null;
    }
}

