/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CatalinaManagerMBean;

public final class CatalinaManager
extends NotificationBroadcasterSupport
implements CatalinaManagerMBean,
MBeanRegistration {
    private int state = 0;
    private long sequenceNumber = 0L;

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }

    public String getName() {
        return "Catalina servlet container";
    }

    public String getPath() {
        return System.getProperty("catalina.home");
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return CatalinaManagerMBean.states[this.state];
    }

    public void postDeregister() {
        this.destroy();
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(":service=Catalina");
    }

    public void setPath(String path) {
        System.setProperty("catalina.home", path);
    }

    public void start() throws Exception {
        AttributeChangeNotification notification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Catalina servlet container", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(notification);
        try {
            String[] args = new String[]{"start"};
            Bootstrap.main(args);
        }
        catch (Throwable throwable) {
            this.state = 0;
            notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(notification);
        }
        this.state = 3;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(notification);
    }

    public void stop() {
        AttributeChangeNotification notification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Catalina servlet container", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(notification);
        try {
            String[] args = new String[]{"stop"};
            Bootstrap.main(args);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        this.state = 0;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(notification);
    }
}

