/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.xml.XmlMapper;

public class CatalinaService
extends Catalina {
    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (isConfig) {
                this.configFile = args[i2];
                isConfig = false;
            } else if (args[i2].equals("-config")) {
                isConfig = true;
            } else if (args[i2].equals("-debug")) {
                this.debug = true;
            } else if (args[i2].equals("-nonaming")) {
                this.useNaming = false;
            } else {
                if (args[i2].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (args[i2].equals("start")) {
                    this.starting = true;
                    this.stopping = false;
                } else if (args[i2].equals("stop")) {
                    this.starting = false;
                    this.stopping = true;
                } else {
                    this.usage();
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.load();
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    public void load() {
        block9: {
            XmlMapper mapper = this.createStartMapper();
            File file = this.configFile();
            try {
                mapper.readXml(file, (Object)this);
            }
            catch (InvocationTargetException e10) {
                System.out.println("Catalina.start: InvocationTargetException");
                e10.getTargetException().printStackTrace(System.out);
            }
            catch (Exception e11) {
                System.out.println("Catalina.start: " + e11);
                e11.printStackTrace(System.out);
                System.exit(1);
            }
            if (!this.useNaming) {
                System.setProperty("catalina.useNaming", "false");
            } else {
                System.setProperty("catalina.useNaming", "true");
                String value = "org.apache.naming";
                String oldValue = System.getProperty("java.naming.factory.url.pkgs");
                if (oldValue != null) {
                    value = String.valueOf(value) + ":" + oldValue;
                }
                System.setProperty("java.naming.factory.url.pkgs", value);
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
            if (System.getSecurityManager() != null) {
                String access = Security.getProperty("package.access");
                access = access != null && access.length() > 0 ? String.valueOf(access) + "," : "sun.,";
                Security.setProperty("package.access", String.valueOf(access) + "org.apache.catalina.,org.apache.jasper.");
                String definition = Security.getProperty("package.definition");
                definition = definition != null && definition.length() > 0 ? String.valueOf(definition) + "," : "sun.,";
                Security.setProperty("package.definition", String.valueOf(definition) + "java.,org.apache.catalina.,org.apache.jasper.");
            }
            if (!(this.server instanceof Lifecycle)) break block9;
            try {
                this.server.initialize();
            }
            catch (LifecycleException e12) {
                System.out.println("Catalina.start: " + e12);
                e12.printStackTrace(System.out);
                if (e12.getThrowable() == null) break block9;
                System.out.println("----- Root Cause -----");
                e12.getThrowable().printStackTrace(System.out);
            }
        }
    }

    public void start() {
        block2: {
            if (!(this.server instanceof Lifecycle)) break block2;
            try {
                ((Lifecycle)((Object)this.server)).start();
            }
            catch (LifecycleException e10) {
                System.out.println("Catalina.start: " + e10);
                e10.printStackTrace(System.out);
                if (e10.getThrowable() == null) break block2;
                System.out.println("----- Root Cause -----");
                e10.getThrowable().printStackTrace(System.out);
            }
        }
    }

    public void stop() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException e10) {
                    System.out.println("Catalina.stop: " + e10);
                    e10.printStackTrace(System.out);
                    if (e10.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    e10.getThrowable().printStackTrace(System.out);
                }
            }
        }
        System.out.println("Stop server complete");
    }
}

