/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.loader.StandardClassLoader;

public final class ClassLoaderFactory {
    private static int debug = 0;
    private static String[] triggers = new String[]{"com.sun.jndi.ldap.LdapCtxFactory", "com.sun.net.ssl.internal.ssl.Provider", "javax.naming.Context", "javax.net.SocketFactory", "javax.security.cert.X509Certificate", "javax.sql.DataSource", "org.apache.catalina.startup.Bootstrap"};

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        int i2;
        if (debug >= 1) {
            ClassLoaderFactory.log("Creating new class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (unpacked != null) {
            i2 = 0;
            while (i2 < unpacked.length) {
                File file = unpacked[i2];
                if (file.isDirectory() && file.exists() && file.canRead()) {
                    if (!ClassLoaderFactory.validateDirectory(file)) {
                        if (debug >= 1) {
                            ClassLoaderFactory.log("  Skipping directory " + file.getAbsolutePath());
                        }
                    } else {
                        if (debug >= 1) {
                            ClassLoaderFactory.log("  Including directory " + file.getAbsolutePath());
                        }
                        URL url = new URL("file", null, String.valueOf(file.getCanonicalPath()) + File.separator);
                        list.add(url.toString());
                    }
                }
                ++i2;
            }
        }
        if (packed != null) {
            i2 = 0;
            while (i2 < packed.length) {
                File directory = packed[i2];
                if (directory.isDirectory() && directory.exists() && directory.canRead()) {
                    String[] filenames = directory.list();
                    int j2 = 0;
                    while (j2 < filenames.length) {
                        String filename = filenames[j2].toLowerCase();
                        if (filename.endsWith(".jar")) {
                            File file = new File(directory, filenames[j2]);
                            if (!ClassLoaderFactory.validateJarFile(file)) {
                                if (debug >= 1) {
                                    ClassLoaderFactory.log("  Skipping jar file " + file.getAbsolutePath());
                                }
                            } else {
                                if (debug >= 1) {
                                    ClassLoaderFactory.log("  Including jar file " + file.getAbsolutePath());
                                }
                                URL url = new URL("file", null, file.getCanonicalPath());
                                list.add(url.toString());
                            }
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    public static int getDebug() {
        return debug;
    }

    public static String[] getTriggers() {
        return triggers;
    }

    private static void log(String message) {
        System.out.print("ClassLoaderFactory:  ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        ClassLoaderFactory.log(message);
        exception.printStackTrace(System.out);
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static void setTriggers(String[] newTriggers) {
        triggers = newTriggers;
    }

    public static boolean validateDirectory(File directory) throws IOException {
        if (triggers == null) {
            return true;
        }
        int i2 = 0;
        while (i2 < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i2]);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz != null) {
                File file = new File(directory, String.valueOf(triggers[i2].replace('.', File.separatorChar)) + ".class");
                if (debug >= 2) {
                    ClassLoaderFactory.log(" Checking for " + file.getAbsolutePath());
                }
                if (file.exists() && file.canRead()) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        int i2 = 0;
        while (i2 < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i2]);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz != null) {
                JarEntry jarEntry;
                String name = String.valueOf(triggers[i2].replace('.', '/')) + ".class";
                if (debug >= 2) {
                    ClassLoaderFactory.log(" Checking for " + name);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) != null) {
                    jarFile.close();
                    return false;
                }
            }
            ++i2;
        }
        jarFile.close();
        return true;
    }
}

