/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.net.URLEncoder;
import java.text.FieldPosition;
import java.util.Date;
import javax.servlet.http.Cookie;
import org.apache.catalina.util.DateTool;

public class CookieTools {
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeaderName(Cookie cookie) {
        int version = cookie.getVersion();
        if (version == 1) {
            return "Set-Cookie2";
        }
        return "Set-Cookie";
    }

    public static String getCookieHeaderValue(Cookie cookie) {
        StringBuffer buf = new StringBuffer();
        CookieTools.getCookieHeaderValue(cookie, buf);
        return buf.toString();
    }

    public static void getCookieHeaderValue(Cookie cookie, StringBuffer buf) {
        String value;
        int version = cookie.getVersion();
        String name = cookie.getName();
        if (name == null) {
            name = "";
        }
        if ((value = cookie.getValue()) == null) {
            value = "";
        }
        buf.append(URLEncoder.encode(name));
        buf.append("=");
        CookieTools.maybeQuote(version, buf, URLEncoder.encode(value));
        if (version == 1) {
            buf.append(";Version=1");
            if (cookie.getComment() != null) {
                buf.append(";Comment=");
                CookieTools.maybeQuote(version, buf, URLEncoder.encode(cookie.getComment()));
            }
        }
        if (cookie.getDomain() != null) {
            buf.append(";Domain=");
            CookieTools.maybeQuote(version, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                buf.append(";Expires=");
                if (cookie.getMaxAge() == 0) {
                    DateTool.oldCookieFormat.format(new Date(10000L), buf, new FieldPosition(0));
                } else {
                    DateTool.oldCookieFormat.format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append(";Max-Age=");
                buf.append(cookie.getMaxAge());
            }
        } else if (version == 1) {
            buf.append(";Discard");
        }
        if (cookie.getPath() != null) {
            buf.append(";Path=");
            CookieTools.maybeQuote(version, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append(";Secure");
        }
    }

    private static boolean isToken(String value) {
        int len = value.length();
        int i2 = 0;
        while (i2 < len) {
            char c10 = value.charAt(i2);
            if (c10 < ' ' || c10 >= '\u007f' || tspecials.indexOf(c10) != -1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    static void maybeQuote(int version, StringBuffer buf, String value) {
        if (version == 0 || CookieTools.isToken(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }
}

