/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.ssi;

import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.DateTool;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiConfig;
import org.apache.catalina.util.ssi.SsiEcho;
import org.apache.catalina.util.ssi.SsiExec;
import org.apache.catalina.util.ssi.SsiFlastmod;
import org.apache.catalina.util.ssi.SsiFsize;
import org.apache.catalina.util.ssi.SsiInclude;

public class SsiMediator {
    protected static Hashtable serverVariables = new Hashtable(17);
    protected static Hashtable ssiCommands = null;
    protected static HttpServletRequest req = null;
    protected static HttpServletResponse res = null;
    protected static OutputStream out = null;
    protected static ServletContext servletContext = null;
    protected static ServletContext origServletContext = null;
    protected static String contextPath = null;
    protected static String relpath = "/";
    protected static String path = new String();
    protected static int debug = 0;
    protected static boolean isVirtualWebappRelative = false;

    static {
        ssiCommands = new Hashtable(6);
        ssiCommands.put("config", new SsiConfig());
        ssiCommands.put("include", new SsiInclude());
        ssiCommands.put("echo", new SsiEcho());
        ssiCommands.put("fsize", new SsiFsize());
        ssiCommands.put("flastmod", new SsiFlastmod());
        ssiCommands.put("exec", new SsiExec());
    }

    public SsiMediator() {
    }

    public SsiMediator(HttpServletRequest req, HttpServletResponse res, OutputStream out, ServletContext servletContext, int debug, String path, boolean isVirtualWebappRelative) {
        SsiMediator.debug = debug;
        this.flush(req, res, out, servletContext, path, isVirtualWebappRelative);
    }

    public void flush(HttpServletRequest req, HttpServletResponse res, OutputStream out, ServletContext servletContext, String path, boolean isVirtualWebappRelative) {
        SsiMediator.req = req;
        SsiMediator.res = res;
        SsiMediator.out = out;
        SsiMediator.servletContext = servletContext;
        origServletContext = servletContext;
        contextPath = req.getContextPath();
        SsiMediator.path = path;
        relpath = path.substring(0, path.lastIndexOf(47) + 1);
        SsiMediator.isVirtualWebappRelative = isVirtualWebappRelative;
        int c10 = 0;
        serverVariables.put("AUTH_TYPE", this.nullToString(req.getAuthType()));
        c10 = req.getContentLength();
        serverVariables.put("CONTENT_LENGTH", this.nullToString(c10 <= 0 ? null : new Integer(c10).toString()));
        serverVariables.put("CONTENT_TYPE", this.nullToString(req.getContentType()));
        serverVariables.put("GATEWAY_INTERFACE", "CGI/1.1");
        serverVariables.put("PATH_INFO", this.nullToString(req.getPathInfo()));
        serverVariables.put("PATH_TRANSLATED ", this.nullToString(req.getPathTranslated()));
        serverVariables.put("QUERY_STRING", this.nullToString(req.getQueryString()));
        serverVariables.put("REMOTE_ADDR", this.nullToString(req.getRemoteAddr()));
        serverVariables.put("REMOTE_HOST", this.nullToString(req.getRemoteHost()));
        serverVariables.put("REMOTE_IDENT", "");
        serverVariables.put("REMOTE_USER", this.nullToString(req.getRemoteUser()));
        serverVariables.put("REQUEST_METHOD", this.nullToString(req.getMethod()));
        serverVariables.put("SCRIPT_NAME", this.nullToString(req.getServletPath()));
        serverVariables.put("SERVER_NAME", this.nullToString(req.getServerName()));
        serverVariables.put("SERVER_PORT", new Integer(req.getServerPort()).toString());
        serverVariables.put("SERVER_PROTOCOL", this.nullToString(req.getProtocol()));
        serverVariables.put("SERVER_SOFTWARE", this.nullToString(servletContext.getServerInfo()));
        serverVariables.put("DOCUMENT_NAME", this.nullToString(path.substring(path.lastIndexOf(47) + 1, path.length())));
        serverVariables.put("DOCUMENT_URI", this.nullToString(path));
        serverVariables.put("QUERY_STRING_UNESCAPED", this.nullToString(""));
        this.flushDate();
        ((SsiConfig)ssiCommands.get("config")).flush();
    }

    protected void flushDate() {
        serverVariables.put("DATE_LOCAL", this.timefmt(new Date()));
        serverVariables.put("DATE_GMT", this.timefmt(this.getGMTDate()));
        serverVariables.put("LAST_MODIFIED", ((SsiFlastmod)ssiCommands.get("flastmod")).getDate(path));
    }

    protected String getCGIPath(String path) {
        String cgibinStr = "/cgi-bin/";
        if (path == null) {
            return null;
        }
        if (!path.startsWith(cgibinStr)) {
            return null;
        }
        path = "http://localhost:8080" + contextPath + path;
        return path;
    }

    public final SsiCommand getCommand(String cmd) {
        return (SsiCommand)ssiCommands.get(cmd);
    }

    protected String getCommandPath(String path) {
        String commandShellStr = "/bin/sh";
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        path = String.valueOf(commandShellStr) + path;
        return path;
    }

    public byte[] getError() {
        return ((SsiConfig)ssiCommands.get("config")).getError();
    }

    protected String getFilePath(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        servletContext = origServletContext;
        if (normalized == null) {
            return null;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        if (normalized.startsWith("/") || normalized.indexOf("../") >= 0) {
            return null;
        }
        return relpath.concat(normalized);
    }

    private String getGMTDate() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(DateTool.GMT_ZONE);
        return dateFormat.format(date);
    }

    protected String getServerVariable(String serverVar) {
        this.flushDate();
        if (serverVariables.get(serverVar) == null) {
            return new String(this.getError());
        }
        return (String)serverVariables.get(serverVar);
    }

    protected String getVirtualPath(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized == null) {
            return null;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = relpath.concat(normalized);
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        if (!isVirtualWebappRelative) {
            String context;
            ServletContext sc;
            if (!path.startsWith("/") || path.startsWith("./")) {
                servletContext = origServletContext;
            } else if (path.indexOf(47, 1) == -1) {
                servletContext = servletContext.getContext("/");
            } else if (!contextPath.equals("") && normalized != null && normalized.startsWith(contextPath)) {
                servletContext = servletContext.getContext(contextPath);
                normalized = normalized.substring(contextPath.length());
            } else if (normalized != null && (sc = servletContext.getContext(context = normalized.substring(0, path.indexOf(47, 1)))) != null) {
                servletContext = sc;
                normalized = normalized.substring(context.length());
            }
        }
        return normalized;
    }

    private String nullToString(String s2) {
        return s2 == null ? "" : s2;
    }

    protected String timefmt(String date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(date);
        }
        catch (ParseException parseException) {
            return new String(this.getError());
        }
        return this.timefmt(parsedDate);
    }

    protected String timefmt(Date date) {
        String pattern = ((SsiConfig)ssiCommands.get("config")).getTimefmt();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, DateTool.LOCALE_US);
        return dateFormat.format(date);
    }
}

