/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.util.Stack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.XmlAction;
import org.xml.sax.AttributeList;

class ObjectCreate
extends XmlAction {
    String className;
    String attrib;

    public ObjectCreate(String classN) {
        this.className = classN;
    }

    public ObjectCreate(String classN, String attrib) {
        this.className = classN;
        this.attrib = attrib;
    }

    public void cleanup(SaxContext ctx) {
        Stack st = ctx.getObjectStack();
        String tag = ctx.getTag(ctx.getTagCount() - 1);
        Object o2 = st.pop();
        if (ctx.getDebug() > 0) {
            ctx.log("pop " + tag + " " + o2.getClass().getName() + ": " + o2);
        }
    }

    public void start(SaxContext ctx) throws Exception {
        AttributeList attributes;
        Stack st = ctx.getObjectStack();
        int top = ctx.getTagCount() - 1;
        String tag = ctx.getTag(top);
        String classN = this.className;
        if (this.attrib != null && (attributes = ctx.getAttributeList(top)).getValue(this.attrib) != null) {
            classN = attributes.getValue(this.attrib);
        }
        Class<?> c10 = Class.forName(classN);
        Object o2 = c10.newInstance();
        st.push(o2);
        if (ctx.getDebug() > 0) {
            ctx.log("new " + this.attrib + " " + classN + " " + tag + " " + o2);
        }
    }
}

