/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class ErrorDispatcherValve
extends ValveBase {
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.valves.ErrorDispatcherValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + errorPage);
        }
        if (!(request instanceof HttpRequest)) {
            if (this.debug >= 1) {
                this.log(" Not processing an HTTP request --> default handling");
            }
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        if (!(response instanceof HttpResponse)) {
            if (this.debug >= 1) {
                this.log("Not processing an HTTP response --> default handling");
            }
            return false;
        }
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        try {
            hres.reset();
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            rd.forward(hreq, hres);
            response.setSuspended(false);
            return true;
        }
        catch (Throwable t2) {
            this.log("Exception Processing " + errorPage, t2);
            return false;
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!"java.lang.Object".equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        response.setSuspended(false);
        ServletRequest sreq = request.getRequest();
        Throwable t2 = (Throwable)sreq.getAttribute("javax.servlet.error.exception");
        if (t2 != null) {
            this.throwable(request, response, t2);
        } else {
            this.status(request, response);
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void status(Request request, Response response) {
        block9: {
            Context context;
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse hresponse = (HttpResponse)response;
            if (!(response.getResponse() instanceof HttpServletResponse)) {
                return;
            }
            int statusCode = hresponse.getStatus();
            String message = RequestUtil.filter(hresponse.getMessage());
            if (message == null) {
                message = "";
            }
            if ((context = request.getContext()) == null) {
                return;
            }
            ErrorPage errorPage = context.findErrorPage(statusCode);
            if (errorPage == null) break block9;
            response.setAppCommitted(false);
            ServletRequest sreq = request.getRequest();
            ServletResponse sresp = response.getResponse();
            sreq.setAttribute("javax.servlet.error.status_code", new Integer(statusCode));
            sreq.setAttribute("javax.servlet.error.message", message);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                sreq.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            if (sreq instanceof HttpServletRequest) {
                sreq.setAttribute("javax.servlet.error.request_uri", ((HttpServletRequest)sreq).getRequestURI());
            }
            if (this.custom(request, response, errorPage)) {
                try {
                    sresp.flushBuffer();
                }
                catch (IOException e10) {
                    this.log("Exception Processing " + errorPage, e10);
                }
            }
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        block9: {
            Context context = request.getContext();
            if (context == null) {
                return;
            }
            Throwable realError = throwable;
            ErrorPage errorPage = ErrorDispatcherValve.findErrorPage(context, realError);
            if (errorPage == null && realError instanceof ServletException) {
                if ((realError = ((ServletException)realError).getRootCause()) != null) {
                    errorPage = ErrorDispatcherValve.findErrorPage(context, realError);
                } else {
                    realError = throwable;
                }
            }
            if (errorPage == null) break block9;
            response.setAppCommitted(false);
            ServletRequest sreq = request.getRequest();
            ServletResponse sresp = response.getResponse();
            sreq.setAttribute("javax.servlet.error.status_code", new Integer(500));
            sreq.setAttribute("javax.servlet.error.message", throwable.getMessage());
            sreq.setAttribute("javax.servlet.error.exception", throwable);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                sreq.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            if (sreq instanceof HttpServletRequest) {
                sreq.setAttribute("javax.servlet.error.request_uri", ((HttpServletRequest)sreq).getRequestURI());
            }
            sreq.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            if (this.custom(request, response, errorPage)) {
                try {
                    sresp.flushBuffer();
                }
                catch (IOException e10) {
                    this.log("Exception Processing " + errorPage, e10);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ErrorDispatcherValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }
}

