/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class RequestDumperValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        int i2;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        HttpServletRequest hreq = (HttpServletRequest)hrequest.getRequest();
        HttpServletResponse hres = (HttpServletResponse)hresponse.getResponse();
        this.log("REQUEST URI       =" + hreq.getRequestURI());
        this.log("          authType=" + hreq.getAuthType());
        this.log(" characterEncoding=" + hreq.getCharacterEncoding());
        this.log("     contentLength=" + hreq.getContentLength());
        this.log("       contentType=" + hreq.getContentType());
        this.log("       contextPath=" + hreq.getContextPath());
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            int i3 = 0;
            while (i3 < cookies.length) {
                this.log("            cookie=" + cookies[i3].getName() + "=" + cookies[i3].getValue());
                ++i3;
            }
        }
        Enumeration hnames = hreq.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            Enumeration hvalues = hreq.getHeaders(hname);
            while (hvalues.hasMoreElements()) {
                String hvalue = (String)hvalues.nextElement();
                this.log("            header=" + hname + "=" + hvalue);
            }
        }
        this.log("            locale=" + hreq.getLocale());
        this.log("            method=" + hreq.getMethod());
        Enumeration pnames = hreq.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            String[] pvalues = hreq.getParameterValues(pname);
            StringBuffer result = new StringBuffer(pname);
            result.append('=');
            i2 = 0;
            while (i2 < pvalues.length) {
                if (i2 > 0) {
                    result.append(", ");
                }
                result.append(pvalues[i2]);
                ++i2;
            }
            this.log("         parameter=" + result.toString());
        }
        this.log("          pathInfo=" + hreq.getPathInfo());
        this.log("          protocol=" + hreq.getProtocol());
        this.log("       queryString=" + hreq.getQueryString());
        this.log("        remoteAddr=" + hreq.getRemoteAddr());
        this.log("        remoteHost=" + hreq.getRemoteHost());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("requestedSessionId=" + hreq.getRequestedSessionId());
        this.log("            scheme=" + hreq.getScheme());
        this.log("        serverName=" + hreq.getServerName());
        this.log("        serverPort=" + hreq.getServerPort());
        this.log("       servletPath=" + hreq.getServletPath());
        this.log("          isSecure=" + hreq.isSecure());
        this.log("---------------------------------------------------------------");
        context.invokeNext(request, response);
        this.log("---------------------------------------------------------------");
        this.log("          authType=" + hreq.getAuthType());
        this.log("     contentLength=" + hresponse.getContentLength());
        this.log("       contentType=" + hresponse.getContentType());
        Cookie[] rcookies = hresponse.getCookies();
        int i4 = 0;
        while (i4 < rcookies.length) {
            this.log("            cookie=" + rcookies[i4].getName() + "=" + rcookies[i4].getValue() + "; domain=" + rcookies[i4].getDomain() + "; path=" + rcookies[i4].getPath());
            ++i4;
        }
        String[] rhnames = hresponse.getHeaderNames();
        i2 = 0;
        while (i2 < rhnames.length) {
            String[] rhvalues = hresponse.getHeaderValues(rhnames[i2]);
            int j2 = 0;
            while (j2 < rhvalues.length) {
                this.log("            header=" + rhnames[i2] + "=" + rhvalues[j2]);
                ++j2;
            }
            ++i2;
        }
        this.log("           message=" + hresponse.getMessage());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("            status=" + hresponse.getStatus());
        this.log("===============================================================");
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestDumperValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }
}

