/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.apache.crimson.tree.DOMImplementationImpl;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.apache.crimson.tree.XmlDocumentBuilderNS;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private DocumentBuilderFactory dbf;
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private XMLReader xmlReader = null;
    private XmlDocumentBuilder builder = null;
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        this.dbf = dbf;
        this.namespaceAware = dbf.isNamespaceAware();
        this.xmlReader = new XMLReaderImpl();
        try {
            this.validating = dbf.isValidating();
            String validation = "http://xml.org/sax/features/validation";
            this.xmlReader.setFeature(validation, this.validating);
            if (this.validating) {
                this.setErrorHandler(new DefaultValidationErrorHandler());
            }
            String nsPrefixes = "http://xml.org/sax/features/namespace-prefixes";
            this.xmlReader.setFeature(nsPrefixes, true);
            String namespaces = "http://xml.org/sax/features/namespaces";
            this.xmlReader.setFeature(namespaces, this.namespaceAware);
            this.builder = this.namespaceAware ? new XmlDocumentBuilderNS() : new XmlDocumentBuilder();
            this.xmlReader.setContentHandler(this.builder);
            String lexHandler = "http://xml.org/sax/properties/lexical-handler";
            this.xmlReader.setProperty(lexHandler, this.builder);
            String declHandler = "http://xml.org/sax/properties/declaration-handler";
            this.xmlReader.setProperty(declHandler, this.builder);
            this.xmlReader.setDTDHandler(this.builder);
        }
        catch (SAXException e10) {
            throw new ParserConfigurationException(e10.getMessage());
        }
        this.builder.setIgnoreWhitespace(dbf.isIgnoringElementContentWhitespace());
        this.builder.setExpandEntityReferences(dbf.isExpandEntityReferences());
        this.builder.setIgnoreComments(dbf.isIgnoringComments());
        this.builder.setPutCDATAIntoText(dbf.isCoalescing());
    }

    public Document newDocument() {
        return new XmlDocument();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.xmlReader.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.xmlReader.setErrorHandler(this.eh);
        }
        this.xmlReader.parse(is);
        return this.builder.getDocument();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setEntityResolver(EntityResolver er2) {
        this.er = er2;
    }

    public void setErrorHandler(ErrorHandler eh2) {
        this.eh = eh2 == null ? new DefaultHandler() : eh2;
    }
}

