/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.EndOfInputException;

class ContentModelState {
    private ContentModel model;
    private boolean sawOne;
    private ContentModelState next;

    ContentModelState(ContentModel model) {
        this(model, null);
    }

    private ContentModelState(Object content, ContentModelState next) {
        this.model = (ContentModel)content;
        this.next = next;
        this.sawOne = false;
    }

    boolean terminate() {
        switch (this.model.type) {
            case '+': {
                if (!this.sawOne && !this.model.empty()) {
                    return false;
                }
            }
            case '*': 
            case '?': {
                return this.next == null || this.next.terminate();
            }
            case '|': {
                return this.model.empty() && (this.next == null || this.next.terminate());
            }
            case ',': {
                ContentModel m2 = this.model;
                while (m2 != null && m2.empty()) {
                    m2 = m2.next;
                }
                if (m2 != null) {
                    return false;
                }
                return this.next == null || this.next.terminate();
            }
            case '\u0000': {
                return false;
            }
        }
        throw new InternalError();
    }

    ContentModelState advance(String token) throws EndOfInputException {
        switch (this.model.type) {
            case '*': 
            case '+': {
                if (this.model.first(token)) {
                    this.sawOne = true;
                    if (this.model.content instanceof String) {
                        return this;
                    }
                    return new ContentModelState(this.model.content, this).advance(token);
                }
                if (this.model.type != '*' && !this.sawOne || this.next == null) break;
                return this.next.advance(token);
            }
            case '?': {
                if (this.model.first(token)) {
                    if (this.model.content instanceof String) {
                        return this.next;
                    }
                    return new ContentModelState(this.model.content, this.next).advance(token);
                }
                if (this.next == null) break;
                return this.next.advance(token);
            }
            case '|': {
                ContentModel m2 = this.model;
                while (m2 != null) {
                    if (m2.content instanceof String) {
                        if (token == m2.content) {
                            return this.next;
                        }
                    } else if (((ContentModel)m2.content).first(token)) {
                        return new ContentModelState(m2.content, this.next).advance(token);
                    }
                    m2 = m2.next;
                }
                if (!this.model.empty() || this.next == null) break;
                return this.next.advance(token);
            }
            case ',': {
                if (this.model.first(token)) {
                    ContentModelState nextState;
                    if (this.model.type == '\u0000') {
                        return this.next;
                    }
                    if (this.model.next == null) {
                        nextState = new ContentModelState(this.model.content, this.next);
                    } else {
                        nextState = new ContentModelState(this.model.content, this);
                        this.model = this.model.next;
                    }
                    return nextState.advance(token);
                }
                if (!this.model.empty() || this.next == null) break;
                return this.next.advance(token);
            }
            case '\u0000': {
                if (this.model.content != token) break;
                return this.next;
            }
        }
        throw new EndOfInputException();
    }
}

