/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.XmlReader;
import org.apache.crimson.util.XmlChars;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class InputEntity
implements Locator {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private boolean maybeInCRLF = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private ErrorHandler errHandler;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 8193;
    private static final char[] newline = new char[]{'\n'};

    public static InputEntity getInputEntity(ErrorHandler h2, Locale l2) {
        InputEntity retval = new InputEntity();
        retval.errHandler = h2;
        retval.locale = l2;
        return retval;
    }

    private InputEntity() {
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    public String getName() {
        return this.name;
    }

    private static String convertToFileURL(String filename) {
        String path = new File(filename).getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return "file:" + path;
    }

    public void init(InputSource in, String name, InputEntity stack, boolean isPE) throws IOException, SAXException {
        this.input = in;
        this.isPE = isPE;
        this.reader = in.getCharacterStream();
        if (this.reader == null) {
            InputStream bytes = in.getByteStream();
            if (bytes == null) {
                URL url;
                String systemId = in.getSystemId();
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException e10) {
                    String urlString = InputEntity.convertToFileURL(systemId);
                    in.setSystemId(urlString);
                    url = new URL(urlString);
                }
                this.reader = XmlReader.createReader(url.openStream());
            } else {
                this.reader = in.getEncoding() != null ? XmlReader.createReader(in.getByteStream(), in.getEncoding()) : XmlReader.createReader(in.getByteStream());
            }
        }
        this.next = stack;
        this.buf = new char[8193];
        this.name = name;
        this.checkRecursion(stack);
    }

    public void init(char[] b10, String name, InputEntity stack, boolean isPE) throws SAXException {
        this.next = stack;
        this.buf = b10;
        this.finish = b10.length;
        this.name = name;
        this.isPE = isPE;
        this.checkRecursion(stack);
    }

    private void checkRecursion(InputEntity stack) throws SAXException {
        if (stack == null) {
            return;
        }
        stack = stack.next;
        while (stack != null) {
            if (stack.name != null && stack.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            stack = stack.next;
        }
    }

    public InputEntity pop() throws IOException {
        this.close();
        return this.next;
    }

    public boolean isEOF() throws IOException, SAXException {
        if (this.start >= this.finish) {
            this.fillbuf();
            return this.start >= this.finish;
        }
        return false;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public char getNameChar() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c10;
            if (XmlChars.isNameChar(c10 = this.buf[this.start++])) {
                return c10;
            }
            --this.start;
        }
        return '\u0000';
    }

    public char getc() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c10 = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c10 >= '\udc00' && c10 <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c10;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c10)});
            }
            if (c10 >= ' ' && c10 <= '\ud7ff' || c10 == '\t' || c10 >= '\ue000' && c10 <= '\ufffd') {
                return c10;
            }
            if (c10 == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c10 = this.getc();
                if (c10 != '\n') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c10 == '\n' || c10 == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c10;
            }
            if (c10 >= '\ud800' && c10 < '\udc00') {
                this.returnedFirstHalf = true;
                return c10;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c10)});
        }
        throw new EndOfInputException();
    }

    public boolean peekc(char c10) throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c10) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n' || this.buf[this.start] == '\r') {
            if (!this.isInternal()) {
                --this.lineNumber;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean maybeWhitespace() throws IOException, SAXException {
        boolean isSpace = false;
        boolean sawCR = false;
        while (true) {
            char c10;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return isSpace;
            }
            if ((c10 = this.buf[this.start++]) != ' ' && c10 != '\t' && c10 != '\n' && c10 != '\r') break;
            isSpace = true;
            if (c10 != '\n' && c10 != '\r' || this.isInternal()) continue;
            if (c10 != '\n' || !sawCR) {
                ++this.lineNumber;
                sawCR = false;
            }
            if (c10 != '\r') continue;
            sawCR = true;
        }
        --this.start;
        return isSpace;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent(ContentHandler contentHandler, ElementValidator validator) throws IOException, SAXException {
        int last;
        int first = last = this.start;
        boolean sawContent = false;
        while (true) {
            block21: {
                char c10;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (last < this.finish) break block22;
                                    if (last > first) {
                                        validator.text();
                                        contentHandler.characters(this.buf, first, last - first);
                                        sawContent = true;
                                        this.start = last;
                                    }
                                    if (this.isEOF()) {
                                        return sawContent;
                                    }
                                    first = this.start;
                                    last = first - 1;
                                    break block21;
                                }
                                c10 = this.buf[last];
                                if (c10 > ']' && c10 <= '\ud7ff' || c10 < '&' && c10 >= ' ' || c10 > '<' && c10 < ']' || c10 > '&' && c10 < '<' || c10 == '\t' || c10 >= '\ue000' && c10 <= '\ufffd') break block21;
                                if (c10 == '<' || c10 == '&') break;
                                if (c10 != '\n') break block23;
                                if (!this.isInternal()) {
                                    ++this.lineNumber;
                                }
                                break block21;
                            }
                            if (c10 != '\r') break block24;
                            if (!this.isInternal()) {
                                contentHandler.characters(this.buf, first, last - first);
                                contentHandler.characters(newline, 0, 1);
                                sawContent = true;
                                ++this.lineNumber;
                                if (this.finish > last + 1 && this.buf[last + 1] == '\n') {
                                    ++last;
                                }
                                first = this.start = last + 1;
                            }
                            break block21;
                        }
                        if (c10 != ']') break block25;
                        switch (this.finish - last) {
                            case 2: {
                                if (this.buf[last + 1] != ']') break;
                            }
                            case 1: {
                                if (this.reader != null) {
                                    if (this.isClosed) break;
                                    if (last == first) {
                                        throw new InternalError("fillbuf");
                                    }
                                    if (--last > first) {
                                        validator.text();
                                        contentHandler.characters(this.buf, first, last - first);
                                        sawContent = true;
                                        this.start = last;
                                    }
                                    this.fillbuf();
                                    first = last = this.start;
                                    break;
                                }
                                break block21;
                            }
                            default: {
                                if (this.buf[last + 1] == ']' && this.buf[last + 2] == '>') {
                                    this.fatal("P-072", null);
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    if (c10 < '\ud800' || c10 > '\udfff') break block26;
                    if (last + 1 >= this.finish) {
                        if (last > first) {
                            validator.text();
                            contentHandler.characters(this.buf, first, last - first);
                            sawContent = true;
                            this.start = last + 1;
                        }
                        if (this.isEOF()) {
                            this.fatal("P-081", new Object[]{Integer.toHexString(c10)});
                        }
                        last = first = this.start;
                        break block21;
                    } else if (this.checkSurrogatePair(last)) {
                        ++last;
                        break block21;
                    } else {
                        --last;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c10)});
            }
            ++last;
        }
        if (last == first) {
            return sawContent;
        }
        validator.text();
        contentHandler.characters(this.buf, first, last - first);
        this.start = last;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unparsedContent(ContentHandler contentHandler, ElementValidator validator, boolean ignorableWhitespace, String whitespaceInvalidMessage) throws IOException, SAXException {
        while (true) {
            boolean done = false;
            boolean white = ignorableWhitespace;
            int last = this.start;
            while (last < this.finish) {
                block24: {
                    char c10 = this.buf[last];
                    if (!XmlChars.isChar(c10)) {
                        white = false;
                        if (c10 >= '\ud800' && c10 <= '\udfff') {
                            if (this.checkSurrogatePair(last)) {
                                ++last;
                                break block24;
                            } else {
                                --last;
                                break;
                            }
                        }
                        this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[last])});
                    }
                    if (c10 == '\n') {
                        if (!this.isInternal()) {
                            ++this.lineNumber;
                        }
                    } else if (c10 == '\r') {
                        if (!this.isInternal()) {
                            if (white) {
                                if (whitespaceInvalidMessage != null) {
                                    this.errHandler.error(new SAXParseException(Parser2.messages.getMessage(this.locale, whitespaceInvalidMessage), this));
                                }
                                contentHandler.ignorableWhitespace(this.buf, this.start, last - this.start);
                                contentHandler.ignorableWhitespace(newline, 0, 1);
                            } else {
                                validator.text();
                                contentHandler.characters(this.buf, this.start, last - this.start);
                                contentHandler.characters(newline, 0, 1);
                            }
                            ++this.lineNumber;
                            if (this.finish > last + 1 && this.buf[last + 1] == '\n') {
                                ++last;
                            }
                            this.start = last + 1;
                        }
                    } else if (c10 != ']') {
                        if (c10 != ' ' && c10 != '\t') {
                            white = false;
                        }
                    } else {
                        if (last + 2 >= this.finish) break;
                        if (this.buf[last + 1] == ']' && this.buf[last + 2] == '>') {
                            done = true;
                            break;
                        }
                        white = false;
                    }
                }
                ++last;
            }
            if (white) {
                if (whitespaceInvalidMessage != null) {
                    this.errHandler.error(new SAXParseException(Parser2.messages.getMessage(this.locale, whitespaceInvalidMessage), this));
                }
                contentHandler.ignorableWhitespace(this.buf, this.start, last - this.start);
            } else {
                validator.text();
                contentHandler.characters(this.buf, this.start, last - this.start);
            }
            if (done) {
                this.start = last + 3;
                return;
            }
            this.start = last;
            this.fillbuf();
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
    }

    private boolean checkSurrogatePair(int offset) throws SAXException {
        if (offset + 1 >= this.finish) {
            return false;
        }
        char c12 = this.buf[offset++];
        char c22 = this.buf[offset];
        if (c12 >= '\ud800' && c12 < '\udc00' && c22 >= '\udc00' && c22 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c12 & 0xFFFF), Integer.toHexString(c22 & 0xFFFF)});
        return false;
    }

    public boolean ignorableWhitespace(ContentHandler handler) throws IOException, SAXException {
        boolean isSpace = false;
        int first = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                if (isSpace) {
                    handler.ignorableWhitespace(this.buf, first, this.start - first);
                }
                this.fillbuf();
                first = this.start;
            }
            if (this.finish <= this.start) {
                return isSpace;
            }
            char c10 = this.buf[this.start++];
            switch (c10) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    isSpace = true;
                    continue block5;
                }
                case '\r': {
                    isSpace = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    handler.ignorableWhitespace(this.buf, first, this.start - 1 - first);
                    handler.ignorableWhitespace(newline, 0, 1);
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    first = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        if (isSpace) {
            handler.ignorableWhitespace(this.buf, first, this.start - first);
        }
        return isSpace;
    }

    public boolean peek(String next, char[] chars) throws IOException, SAXException {
        int i2;
        int len = chars != null ? chars.length : next.length();
        if (this.finish <= this.start || this.finish - this.start < len) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        if (chars != null) {
            i2 = 0;
            while (i2 < len && this.start + i2 < this.finish) {
                if (this.buf[this.start + i2] != chars[i2]) {
                    return false;
                }
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < len && this.start + i2 < this.finish) {
                if (this.buf[this.start + i2] != next.charAt(i2)) {
                    return false;
                }
                ++i2;
            }
        }
        if (i2 < len) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (len > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(next, chars);
        }
        this.start += len;
        return true;
    }

    boolean isXmlDeclOrTextDeclPrefix() throws IOException, SAXException {
        String match = "<?xml";
        int matchLen = match.length();
        int prefixLen = matchLen + 1;
        if (this.finish <= this.start || this.finish - this.start < prefixLen) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        int i2 = 0;
        while (i2 < matchLen && this.start + i2 < this.finish) {
            if (this.buf[this.start + i2] != match.charAt(i2)) {
                return false;
            }
            ++i2;
        }
        if (i2 < matchLen) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            this.fillbuf();
            return this.isXmlDeclOrTextDeclPrefix();
        }
        return XmlChars.isSpace(this.buf[i2]);
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public String rememberText() {
        String retval;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            retval = this.rememberedText.toString();
        } else {
            retval = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return retval;
    }

    private Locator getLocator() {
        InputEntity current = this;
        while (current != null && current.input == null) {
            current = current.next;
        }
        return current == null ? this : current;
    }

    public String getPublicId() {
        Locator where = this.getLocator();
        if (where == this) {
            return this.input.getPublicId();
        }
        return where.getPublicId();
    }

    public String getSystemId() {
        Locator where = this.getLocator();
        if (where == this) {
            return this.input.getSystemId();
        }
        return where.getSystemId();
    }

    public int getLineNumber() {
        Locator where = this.getLocator();
        if (where == this) {
            return this.lineNumber;
        }
        return where.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    private void fillbuf() throws IOException, SAXException {
        boolean extra;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl2 = extra = this.finish > 0 && this.start > 0;
        if (extra) {
            --this.start;
        }
        int len = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, len);
        this.start = 0;
        this.finish = len;
        try {
            len = this.buf.length - len;
            len = this.reader.read(this.buf, this.finish, len);
        }
        catch (UnsupportedEncodingException e10) {
            this.fatal("P-075", new Object[]{e10.getMessage()});
        }
        catch (CharConversionException e11) {
            this.fatal("P-076", new Object[]{e11.getMessage()});
        }
        if (len >= 0) {
            this.finish += len;
        } else {
            this.close();
        }
        if (extra) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fatal(String messageId, Object[] params) throws SAXException {
        SAXParseException x2 = new SAXParseException(Parser2.messages.getMessage(this.locale, messageId, params), this);
        this.close();
        this.errHandler.fatalError(x2);
        throw x2;
    }
}

