/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeNode
extends NamespacedNode
implements Attr {
    private String value;
    private boolean specified;
    private String defaultValue;
    private Element ownerElement;

    public AttributeNode(String namespaceURI, String qName, String value, boolean specified, String defaultValue) throws DOMException {
        super(namespaceURI, qName);
        this.value = value;
        this.specified = specified;
        this.defaultValue = defaultValue;
    }

    AttributeNode makeClone() {
        AttributeNode retval = new AttributeNode(this.namespaceURI, this.qName, this.value, this.specified, this.defaultValue);
        retval.ownerDocument = this.ownerDocument;
        return retval;
    }

    static void checkArguments(String namespaceURI, String qualifiedName) throws DomEx {
        if (qualifiedName == null) {
            throw new DomEx(14);
        }
        int first = qualifiedName.indexOf(58);
        if (first <= 0) {
            if (!XmlNames.isUnqualifiedName(qualifiedName)) {
                throw new DomEx(5);
            }
            if ("xmlns".equals(qualifiedName) && !"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                throw new DomEx(14);
            }
            return;
        }
        int last = qualifiedName.lastIndexOf(58);
        if (last != first) {
            throw new DomEx(14);
        }
        String prefix = qualifiedName.substring(0, first);
        String localName = qualifiedName.substring(first + 1);
        if (!XmlNames.isUnqualifiedName(prefix) || !XmlNames.isUnqualifiedName(localName)) {
            throw new DomEx(5);
        }
        if (namespaceURI == null || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw new DomEx(14);
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    void setOwnerElement(Element element) {
        if (element != null && this.ownerElement != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{element.getTagName()}));
        }
        this.ownerElement = element;
    }

    public short getNodeType() {
        return 2;
    }

    public String getName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.setNodeValue(value);
    }

    public String getNodeValue() {
        return this.value;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public void setNodeValue(String value) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.value = value;
        this.specified = true;
    }

    void setSpecified(boolean specified) {
        this.specified = specified;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        out.write(this.qName);
        out.write("=\"");
        this.writeChildrenXml(context);
        out.write(34);
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        int i2 = 0;
        while (i2 < this.value.length()) {
            char c10 = this.value.charAt(i2);
            switch (c10) {
                case '<': {
                    out.write("&lt;");
                    break;
                }
                case '>': {
                    out.write("&gt;");
                    break;
                }
                case '&': {
                    out.write("&amp;");
                    break;
                }
                case '\'': {
                    out.write("&apos;");
                    break;
                }
                case '\"': {
                    out.write("&quot;");
                    break;
                }
                default: {
                    out.write(c10);
                    break;
                }
            }
            ++i2;
        }
    }

    public Node cloneNode(boolean deep) {
        AttributeNode attr = this.cloneAttributeNode(deep);
        attr.specified = true;
        return attr;
    }

    /*
     * WARNING - void declaration
     */
    AttributeNode cloneAttributeNode(boolean deep) {
        try {
            void e10;
            AttributeNode attr = this.makeClone();
            if (deep) {
                Node node;
                int i2 = 0;
                while ((node = this.item(i2)) != null) {
                    void var3_5;
                    node = var3_5.cloneNode(true);
                    attr.appendChild(node);
                    ++i2;
                }
            }
            return e10;
        }
        catch (DOMException e10) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new DomEx(3);
    }
}

