/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

final class Doctype
extends NodeBase
implements DocumentType {
    private String name;
    private Nodemap entities;
    private Nodemap notations;
    private String publicId;
    private String systemId;
    private String internalSubset;

    Doctype(String pub, String sys, String subset) {
        this.publicId = pub;
        this.systemId = sys;
        this.internalSubset = subset;
    }

    Doctype(String name, String publicId, String systemId, String internalSubset) {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.entities = new Nodemap();
        this.notations = new Nodemap();
    }

    void setPrintInfo(String pub, String sys, String subset) {
        this.publicId = pub;
        this.systemId = sys;
        this.internalSubset = subset;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        Element root = this.getOwnerDocument().getDocumentElement();
        out.write("<!DOCTYPE ");
        out.write(root == null ? "UNKNOWN-ROOT" : root.getNodeName());
        if (this.systemId != null) {
            if (this.publicId != null) {
                out.write(" PUBLIC '");
                out.write(this.publicId);
                out.write("' '");
            } else {
                out.write(" SYSTEM '");
            }
            out.write(this.systemId);
            out.write("'");
        }
        if (this.internalSubset != null) {
            out.write(XmlDocument.eol);
            out.write("[");
            out.write(this.internalSubset);
            out.write("]");
        }
        out.write(">");
        out.write(XmlDocument.eol);
    }

    public short getNodeType() {
        return 10;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public Node cloneNode(boolean deep) {
        Doctype retval = new Doctype(this.name, this.publicId, this.systemId, this.internalSubset);
        retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        return retval;
    }

    public NamedNodeMap getEntities() {
        return this.entities;
    }

    public NamedNodeMap getNotations() {
        return this.notations;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    protected void setOwnerDocument(XmlDocument doc) {
        super.setOwnerDocument(doc);
        if (this.entities != null) {
            int i2 = 0;
            while (this.entities.item(i2) != null) {
                ((NodeBase)this.entities.item(i2)).setOwnerDocument(doc);
                ++i2;
            }
        }
        if (this.notations != null) {
            int i3 = 0;
            while (this.notations.item(i3) != null) {
                ((NodeBase)this.notations.item(i3)).setOwnerDocument(doc);
                ++i3;
            }
        }
    }

    void addNotation(String name, String pub, String sys) {
        NotationNode node = new NotationNode(name, pub, sys);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.notations.setNamedItem(node);
    }

    void addEntityNode(String name, String pub, String sys, String not) {
        EntityNode node = new EntityNode(name, pub, sys, not);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(node);
    }

    void addEntityNode(String name, String value) {
        if ("lt".equals(name) || "gt".equals(name) || "apos".equals(name) || "quot".equals(name) || "amp".equals(name)) {
            return;
        }
        EntityNode node = new EntityNode(name, value);
        node.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        this.entities.setNamedItem(node);
    }

    void setReadonly() {
        this.entities.readonly = true;
        this.notations.readonly = true;
    }

    static class Nodemap
    implements NamedNodeMap {
        boolean readonly;
        Vector list = new Vector();

        Nodemap() {
        }

        public Node getNamedItem(String name) {
            int length = this.list.size();
            int i2 = 0;
            while (i2 < length) {
                Node value = this.item(i2);
                if (value.getNodeName().equals(name)) {
                    return value;
                }
                ++i2;
            }
            return null;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return null;
        }

        public int getLength() {
            return this.list.size();
        }

        public Node item(int index) {
            if (index < 0 || index >= this.list.size()) {
                return null;
            }
            return (Node)this.list.elementAt(index);
        }

        public Node removeNamedItem(String name) throws DOMException {
            throw new DomEx(7);
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw new DomEx(7);
        }

        public Node setNamedItem(Node item) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(item);
            return null;
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            if (this.readonly) {
                throw new DomEx(7);
            }
            this.list.addElement(arg);
            return null;
        }
    }

    static class EntityNode
    extends NodeBase
    implements Entity {
        private String entityName;
        private String publicId;
        private String systemId;
        private String notation;
        private String value;

        EntityNode(String name, String pub, String sys, String not) {
            this.entityName = name;
            this.publicId = pub;
            this.systemId = sys;
            this.notation = not;
        }

        EntityNode(String name, String value) {
            this.entityName = name;
            this.value = value;
        }

        public String getNodeName() {
            return this.entityName;
        }

        public short getNodeType() {
            return 6;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public String getNotationName() {
            return this.notation;
        }

        public Node cloneNode(boolean ignored) {
            EntityNode retval = new EntityNode(this.entityName, this.publicId, this.systemId, this.notation);
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return retval;
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            Writer out = context.getWriter();
            out.write("<!ENTITY ");
            out.write(this.entityName);
            if (this.value == null) {
                if (this.publicId != null) {
                    out.write(" PUBLIC '");
                    out.write(this.publicId);
                    out.write("' '");
                } else {
                    out.write(" SYSTEM '");
                }
                out.write(this.systemId);
                out.write("'");
                if (this.notation != null) {
                    out.write(" NDATA ");
                    out.write(this.notation);
                }
            } else {
                out.write(" \"");
                int length = this.value.length();
                int i2 = 0;
                while (i2 < length) {
                    char c10 = this.value.charAt(i2);
                    if (c10 == '\"') {
                        out.write("&quot;");
                    } else {
                        out.write(c10);
                    }
                    ++i2;
                }
                out.write(34);
            }
            out.write(">");
        }
    }

    static class NotationNode
    extends NodeBase
    implements Notation {
        private String notation;
        private String publicId;
        private String systemId;

        NotationNode(String name, String pub, String sys) {
            this.notation = name;
            this.publicId = pub;
            this.systemId = sys;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public short getNodeType() {
            return 12;
        }

        public String getNodeName() {
            return this.notation;
        }

        public Node cloneNode(boolean ignored) {
            NotationNode retval = new NotationNode(this.notation, this.publicId, this.systemId);
            retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            return retval;
        }

        public void writeXml(XmlWriteContext context) throws IOException {
            Writer out = context.getWriter();
            out.write("<!NOTATION ");
            out.write(this.notation);
            if (this.publicId != null) {
                out.write(" PUBLIC '");
                out.write(this.publicId);
                if (this.systemId != null) {
                    out.write("' '");
                    out.write(this.systemId);
                }
            } else {
                out.write(" SYSTEM '");
                out.write(this.systemId);
            }
            out.write("'>");
        }
    }
}

