/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode2
extends NamespacedNode
implements ElementEx {
    protected AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    public ElementNode2(String namespaceURI, String qName) throws DomEx {
        super(namespaceURI, qName);
    }

    ElementNode2 makeClone() {
        ElementNode2 retval = new ElementNode2(this.namespaceURI, this.qName);
        if (this.attributes != null) {
            retval.attributes = new AttributeSet(this.attributes, true);
            retval.attributes.setOwnerElement(retval);
        }
        retval.idAttributeName = this.idAttributeName;
        retval.userObject = this.userObject;
        retval.ownerDocument = this.ownerDocument;
        return retval;
    }

    ElementNode2 createCopyForImportNode(boolean deep) {
        ElementNode2 retval = new ElementNode2(this.namespaceURI, this.qName);
        if (this.attributes != null) {
            retval.attributes = new AttributeSet(this.attributes);
            retval.attributes.setOwnerElement(retval);
        }
        retval.userObject = this.userObject;
        if (deep) {
            Node node;
            retval.ownerDocument = this.ownerDocument;
            int i2 = 0;
            while ((node = this.item(i2)) != null) {
                if (node instanceof ElementNode2) {
                    retval.appendChild(((ElementNode2)node).createCopyForImportNode(true));
                } else {
                    retval.appendChild(node.cloneNode(true));
                }
                ++i2;
            }
        }
        return retval;
    }

    static void checkArguments(String namespaceURI, String qualifiedName) throws DomEx {
        if (qualifiedName == null) {
            throw new DomEx(14);
        }
        int first = qualifiedName.indexOf(58);
        if (first <= 0) {
            if (!XmlNames.isUnqualifiedName(qualifiedName)) {
                throw new DomEx(5);
            }
            return;
        }
        int last = qualifiedName.lastIndexOf(58);
        if (last != first) {
            throw new DomEx(14);
        }
        String prefix = qualifiedName.substring(0, first);
        String localName = qualifiedName.substring(first + 1);
        if (!XmlNames.isUnqualifiedName(prefix) || !XmlNames.isUnqualifiedName(localName)) {
            throw new DomEx(5);
        }
        if (namespaceURI == null || prefix.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw new DomEx(14);
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    void setAttributes(AttributeSet a) {
        AttributeSet oldAtts = this.attributes;
        if (oldAtts != null && oldAtts.isReadonly()) {
            throw new DomEx(7);
        }
        if (a != null) {
            a.setOwnerElement(this);
        }
        this.attributes = a;
        if (oldAtts != null) {
            oldAtts.setOwnerElement(null);
        }
    }

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void setReadonly(boolean deep) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(deep);
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public String toString() {
        try {
            CharArrayWriter out = new CharArrayWriter();
            XmlWriteContext x2 = new XmlWriteContext(out);
            this.writeXml(x2);
            return out.toString();
        }
        catch (Exception e10) {
            return super.toString();
        }
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        if (this.qName == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        out.write(tagStart, 0, 1);
        out.write(this.qName);
        if (this.attributes != null) {
            this.attributes.writeXml(context);
        }
        if (!this.hasChildNodes()) {
            out.write(tagEnd, 0, 3);
        } else {
            out.write(tagEnd, 2, 1);
            this.writeChildrenXml(context);
            out.write(tagStart, 0, 2);
            out.write(this.qName);
            out.write(tagEnd, 2, 1);
        }
    }

    public void setIdAttributeName(String attName) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = attName;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.qName;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        return this.attributes == null ? "" : this.attributes.getValue(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (localName == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        int i2 = 0;
        AttributeNode attr;
        while ((attr = (AttributeNode)this.attributes.item(i2)) != null) {
            if (localName.equals(attr.getLocalName()) && (attr.getNamespaceURI() == namespaceURI || attr.getNamespaceURI().equals(namespaceURI))) {
                return attr;
            }
            ++i2;
        }
        return null;
    }

    public void setAttribute(String name, String value) throws DOMException {
        NodeBase att;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!XmlNames.isName(name)) {
            throw new DomEx(5);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((att = (NodeBase)this.attributes.getNamedItem(name)) != null) {
            att.setNodeValue(value);
        } else {
            att = new AttributeNode1(name, value, true, null);
            att.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(att);
        }
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttributeNode.checkArguments(namespaceURI, qualifiedName);
        Attr attr = this.getAttributeNodeNS(namespaceURI, XmlNames.getLocalPart(qualifiedName));
        if (attr == null) {
            AttributeNode newAttr = new AttributeNode(namespaceURI, qualifiedName, value, true, null);
            newAttr.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.setAttributeNodeNS(newAttr);
        } else {
            attr.setValue(value);
            attr.setPrefix(XmlNames.getPrefix(qualifiedName));
        }
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (newAttr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItemNS(newAttr);
    }

    public void removeAttribute(String name) throws DOMException {
        block4: {
            if (this.readonly) {
                throw new DomEx(7);
            }
            if (this.attributes == null) {
                return;
            }
            try {
                this.attributes.removeNamedItem(name);
            }
            catch (DOMException x2) {
                if (x2.code == 8) break block4;
                throw x2;
            }
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        block3: {
            if (this.readonly) {
                throw new DomEx(7);
            }
            try {
                this.attributes.removeNamedItemNS(namespaceURI, localName);
            }
            catch (DOMException x2) {
                if (x2.code == 8) break block3;
                throw x2;
            }
        }
    }

    public Attr getAttributeNode(String name) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(name);
        }
        return null;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(newAttr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr = this.getAttributeNode(oldAttr.getNodeName());
        if (attr == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr.getNodeName());
        return attr;
    }

    /*
     * WARNING - void declaration
     */
    public Node cloneNode(boolean deep) {
        try {
            void e10;
            ElementNode2 retval = this.makeClone();
            if (deep) {
                Node node;
                int i2 = 0;
                while ((node = this.item(i2)) != null) {
                    retval.appendChild(node.cloneNode(true));
                    ++i2;
                }
            }
            return e10;
        }
        catch (DOMException e10) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public void write(Writer out) throws IOException {
        this.writeXml(new XmlWriteContext(out));
    }
}

