/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.util.Locale;
import org.apache.crimson.tree.DOMImplementationImpl;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementNode2;
import org.apache.crimson.tree.NodeEx;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class NodeBase
implements Node,
NodeEx,
NodeList,
XmlWritable {
    private ParentNode parent;
    private int parentIndex = -1;
    XmlDocument ownerDocument;
    boolean readonly;

    NodeBase() {
    }

    ParentNode getParentImpl() {
        return this.parent;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    /*
     * WARNING - void declaration
     */
    public void setReadonly(boolean deep) {
        this.readonly = true;
        if (deep) {
            Node next;
            TreeWalker walker = new TreeWalker(this);
            while ((next = walker.getNext()) != null) {
                void var3_3;
                ((NodeBase)var3_3).setReadonly(false);
            }
        }
    }

    public String getLanguage() {
        return this.getInheritedAttribute("xml:lang");
    }

    public String getInheritedAttribute(String name) {
        ElementNode2 e10;
        NodeBase current = this;
        Attr value = null;
        while (!(current instanceof ElementNode2 && (value = (e10 = (ElementNode2)current).getAttributeNode(name)) != null || (current = current.getParentImpl()) == null)) {
        }
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
    }

    public Node getParentNode() {
        return this.parent;
    }

    void setParentNode(ParentNode arg, int index) throws DOMException {
        if (this.parent != null && arg != null) {
            this.parent.removeChild(this);
        }
        this.parent = arg;
        this.parentIndex = index;
    }

    protected void setOwnerDocument(XmlDocument doc) {
        this.ownerDocument = doc;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void setNodeValue(String value) {
        if (this.readonly) {
            throw new DomEx(7);
        }
    }

    public String getNodeValue() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public Node item(int i2) {
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getLastChild() {
        return null;
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new DomEx(3);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DomEx(3);
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        throw new DomEx(3);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DomEx(3);
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex + 1);
    }

    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex - 1);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return DOMImplementationImpl.hasFeature0(feature, version);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
        throw new DomEx(14);
    }

    public String getLocalName() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public int getIndexOf(Node maybeChild) {
        return -1;
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        Locale locale = this instanceof XmlDocument ? ((XmlDocument)this).getLocale() : (this.ownerDocument == null ? Locale.getDefault() : this.ownerDocument.getLocale());
        return XmlDocument.catalog.getMessage(locale, messageId, parameters);
    }

    public abstract Node cloneNode(boolean var1);

    public abstract short getNodeType();

    public abstract String getNodeName();

    public abstract void writeXml(XmlWriteContext var1) throws IOException;
}

