/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.util;

import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class MessageCatalog {
    private String bundleName;
    private Hashtable cache = new Hashtable(5);

    protected MessageCatalog(Class packageMember) {
        this(packageMember, "Messages");
    }

    private MessageCatalog(Class packageMember, String bundle) {
        this.bundleName = packageMember.getName();
        int index = this.bundleName.lastIndexOf(46);
        this.bundleName = index == -1 ? "" : this.bundleName.substring(0, index) + ".";
        this.bundleName = this.bundleName + "resources." + bundle;
    }

    public String getMessage(Locale locale, String messageId) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, locale);
            return bundle.getString(messageId);
        }
        catch (MissingResourceException e10) {
            return this.packagePrefix(messageId);
        }
    }

    private String packagePrefix(String messageId) {
        String temp = this.getClass().getName();
        int index = temp.lastIndexOf(46);
        temp = index == -1 ? "" : temp.substring(0, index);
        return temp + '/' + messageId;
    }

    /*
     * Unable to fully structure code
     */
    public String getMessage(Locale locale, String messageId, Object[] parameters) {
        block7: {
            if (parameters == null) {
                return this.getMessage(locale, messageId);
            }
            i = 0;
            while (i < parameters.length) {
                if (!(parameters[i] instanceof String || parameters[i] instanceof Number || parameters[i] instanceof Date)) {
                    parameters[i] = parameters[i] == null ? "(null)" : parameters[i].toString();
                }
                ++i;
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                bundle = ResourceBundle.getBundle(this.bundleName, locale);
                format = new MessageFormat(bundle.getString(messageId));
                break block7;
            }
            catch (MissingResourceException e) {
                retval = this.packagePrefix(messageId);
                i = 0;
                ** while (i < parameters.length)
            }
lbl-1000:
            // 1 sources

            {
                retval = retval + ' ';
                retval = retval + parameters[i];
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            return retval;
        }
        format.setLocale(locale);
        result = new StringBuffer();
        result = format.format(parameters, result, new FieldPosition(0));
        return result.toString();
    }

    public Locale chooseLocale(String[] languages) {
        if ((languages = this.canonicalize(languages)) != null) {
            int i2 = 0;
            while (i2 < languages.length) {
                if (this.isLocaleSupported(languages[i2])) {
                    return this.getLocale(languages[i2]);
                }
                ++i2;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String[] canonicalize(String[] languages) {
        block12: {
            didClone = false;
            trimCount = 0;
            if (languages == null) {
                return languages;
            }
            i = 0;
            while (i < languages.length) {
                lang = languages[i];
                len = lang.length();
                if (len != 2 && len != 5) {
                    if (!didClone) {
                        languages = (String[])languages.clone();
                        didClone = true;
                    }
                    languages[i] = null;
                    ++trimCount;
                } else if (len == 2) {
                    if ((lang = lang.toLowerCase()) != languages[i]) {
                        if (!didClone) {
                            languages = (String[])languages.clone();
                            didClone = true;
                        }
                        languages[i] = lang;
                    }
                } else {
                    buf = new char[]{Character.toLowerCase(lang.charAt(0)), Character.toLowerCase(lang.charAt(1)), '_', Character.toUpperCase(lang.charAt(3)), Character.toUpperCase(lang.charAt(4))};
                    if (!didClone) {
                        languages = (String[])languages.clone();
                        didClone = true;
                    }
                    languages[i] = new String(buf);
                }
                ++i;
            }
            if (trimCount == 0) break block12;
            temp = new String[languages.length - trimCount];
            i = 0;
            trimCount = 0;
            ** GOTO lbl40
            {
                ++trimCount;
                do {
                    if (languages[i + trimCount] == null) continue block1;
                    temp[i] = languages[i + trimCount];
                    ++i;
lbl40:
                    // 2 sources

                } while (i < temp.length);
            }
            languages = temp;
        }
        return languages;
    }

    private Locale getLocale(String localeName) {
        String country;
        String language;
        int index = localeName.indexOf(95);
        if (index == -1) {
            if (localeName.equals("de")) {
                return Locale.GERMAN;
            }
            if (localeName.equals("en")) {
                return Locale.ENGLISH;
            }
            if (localeName.equals("fr")) {
                return Locale.FRENCH;
            }
            if (localeName.equals("it")) {
                return Locale.ITALIAN;
            }
            if (localeName.equals("ja")) {
                return Locale.JAPANESE;
            }
            if (localeName.equals("ko")) {
                return Locale.KOREAN;
            }
            if (localeName.equals("zh")) {
                return Locale.CHINESE;
            }
            language = localeName;
            country = "";
        } else {
            if (localeName.equals("zh_CN")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (localeName.equals("zh_TW")) {
                return Locale.TRADITIONAL_CHINESE;
            }
            language = localeName.substring(0, index);
            country = localeName.substring(index + 1);
        }
        return new Locale(language, country);
    }

    public boolean isLocaleSupported(String localeName) {
        Boolean value = (Boolean)this.cache.get(localeName);
        if (value != null) {
            return value;
        }
        ClassLoader loader = null;
        while (true) {
            String name = this.bundleName + "_" + localeName;
            try {
                Class.forName(name);
                this.cache.put(localeName, Boolean.TRUE);
                return true;
            }
            catch (Exception e10) {
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                name = name.replace('.', '/');
                name = name + ".properties";
                InputStream in = loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
                if (in != null) {
                    this.cache.put(localeName, Boolean.TRUE);
                    return true;
                }
                int index = localeName.indexOf(95);
                if (index > 0) {
                    localeName = localeName.substring(0, index);
                    continue;
                }
                this.cache.put(localeName, Boolean.FALSE);
                return false;
            }
            break;
        }
    }
}

