/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommandLineCompiler;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.logging.JasperLogger;
import org.apache.jasper.servlet.JspCServletContext;

public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public static final String SWITCH_VERBOSE = "-v";
    public static final String SWITCH_QUIET = "-q";
    public static final String SWITCH_OUTPUT_DIR = "-d";
    public static final String SWITCH_OUTPUT_SIMPLE_DIR = "-dd";
    public static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    public static final String SWITCH_PACKAGE_NAME = "-p";
    public static final String SWITCH_CLASS_NAME = "-c";
    public static final String SWITCH_FULL_STOP = "--";
    public static final String SWITCH_URI_BASE = "-uribase";
    public static final String SWITCH_URI_ROOT = "-uriroot";
    public static final String SWITCH_FILE_WEBAPP = "-webapp";
    public static final String SWITCH_WEBAPP_INC = "-webinc";
    public static final String SWITCH_WEBAPP_XML = "-webxml";
    public static final String SWITCH_MAPPED = "-mapped";
    public static final String SWITCH_DIE = "-die";
    public static final int NO_WEBXML = 0;
    public static final int INC_WEBXML = 10;
    public static final int ALL_WEBXML = 20;
    public static final int DEFAULT_DIE_LEVEL = 1;
    public static final int NO_DIE_LEVEL = 0;
    boolean largeFile = false;
    boolean mappedFile = false;
    int jspVerbosityLevel = 3;
    File scratchDir;
    String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    String targetPackage;
    String targetClassName;
    String uriBase;
    String uriRoot;
    String webxmlFile;
    int webxmlLevel;
    int dieLevel;
    boolean dieOnExit = false;
    static int die;
    boolean dirset;
    Vector extensions;
    private TldLocationsCache tldLocationsCache = null;
    int argPos;
    boolean fullstop = false;
    String[] args;

    public JspC(String[] arg, PrintStream log) {
        String tok;
        this.args = arg;
        int verbosityLevel = 2;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_QUIET)) {
                verbosityLevel = 2;
                continue;
            }
            if (tok.equals(SWITCH_VERBOSE)) {
                verbosityLevel = 3;
                continue;
            }
            if (tok.startsWith(SWITCH_VERBOSE)) {
                try {
                    verbosityLevel = Integer.parseInt(tok.substring(SWITCH_VERBOSE.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.println("Verbosity level " + tok.substring(SWITCH_VERBOSE.length()) + " is not valid.  Option ignored.");
                }
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                if (tok != null) {
                    this.scratchDir = new File(new File(tok).getAbsolutePath());
                    this.dirset = true;
                    continue;
                }
                this.scratchDir = null;
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_SIMPLE_DIR)) {
                tok = this.nextArg();
                if (tok != null) {
                    this.scratchDir = new File(new File(tok).getAbsolutePath());
                    this.dirset = false;
                    continue;
                }
                this.scratchDir = null;
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.uriRoot = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            this.pushBackArg();
            break;
        }
        Constants.jasperLog = new JasperLogger();
        Constants.jasperLog.setVerbosityLevel(verbosityLevel);
    }

    public boolean getClassDebugInfo() {
        return false;
    }

    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    public String getJspCompilerPath() {
        return null;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public int getJspVerbosityLevel() {
        return this.jspVerbosityLevel;
    }

    public boolean getKeepGenerated() {
        return true;
    }

    public boolean getLargeFile() {
        return this.largeFile;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public static void main(String[] arg) {
        block4: {
            if (arg.length == 0) {
                System.out.println(Constants.getString("jspc.usage"));
            } else {
                try {
                    JspC jspc = new JspC(arg, System.out);
                    jspc.parseFiles(System.out);
                }
                catch (JasperException je) {
                    System.err.print("error:");
                    System.err.println(je.getMessage());
                    if (die == 0) break block4;
                    System.exit(die);
                }
            }
        }
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    public boolean parseFile(PrintStream log, String file, Writer servletout, Writer mappingout) {
        block21: {
            try {
                CommandLineContext clctxt = new CommandLineContext(this.getClassPath(), file, this.uriBase, this.uriRoot, false, this);
                if (this.targetClassName != null && this.targetClassName.length() > 0) {
                    clctxt.setServletClassName(this.targetClassName);
                }
                if (this.targetPackage != null) {
                    clctxt.setServletPackageName(this.targetPackage);
                }
                if (this.dirset) {
                    clctxt.setOutputInDirs(true);
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                if (new File(clctxt.getRealPath("/")).exists()) {
                    File classes = new File(clctxt.getRealPath("/WEB-INF/classes"));
                    try {
                        if (classes.exists()) {
                            urls.add(classes.getCanonicalFile().toURL());
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.toString());
                    }
                    File lib = new File(clctxt.getRealPath("/WEB-INF/lib"));
                    if (lib.exists() && lib.isDirectory()) {
                        String[] libs = lib.list();
                        int i2 = 0;
                        while (i2 < libs.length) {
                            try {
                                File libFile = new File(String.valueOf(lib.toString()) + File.separator + libs[i2]);
                                urls.add(libFile.getCanonicalFile().toURL());
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe.toString());
                            }
                            ++i2;
                        }
                    }
                }
                StringTokenizer tokenizer = new StringTokenizer(clctxt.getClassPath(), File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    try {
                        File libFile = new File(path);
                        urls.add(libFile.toURL());
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.toString());
                    }
                }
                urls.add(new File(clctxt.getRealPath("/")).getCanonicalFile().toURL());
                URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
                clctxt.setClassLoader(loader);
                CommandLineCompiler clc = new CommandLineCompiler(clctxt);
                clc.compile();
                this.targetClassName = null;
                String thisServletName = clc.getPackageName() == null ? clc.getClassName() : String.valueOf(clc.getPackageName()) + '.' + clc.getClassName();
                if (servletout != null) {
                    servletout.write("\n\t<servlet>\n\t\t<servlet-name>");
                    servletout.write(thisServletName);
                    servletout.write("</servlet-name>\n\t\t<servlet-class>");
                    servletout.write(thisServletName);
                    servletout.write("</servlet-class>\n\t</servlet>\n");
                }
                if (mappingout != null) {
                    mappingout.write("\n\t<servlet-mapping>\n\t\t<servlet-name>");
                    mappingout.write(thisServletName);
                    mappingout.write("</servlet-name>\n\t\t<url-pattern>");
                    mappingout.write(file.replace('\\', '/'));
                    mappingout.write("</url-pattern>\n\t</servlet-mapping>\n");
                }
                return true;
            }
            catch (JasperException je) {
                Constants.message("jspc.error.jasperException", new Object[]{file, je}, 1);
                if (this.dieLevel != 0) {
                    this.dieOnExit = true;
                }
            }
            catch (FileNotFoundException fne) {
                Constants.message("jspc.error.fileDoesNotExist", new Object[]{fne.getMessage()}, 2);
            }
            catch (Exception e10) {
                Constants.message("jspc.error.generalException", new Object[]{file, e10}, 1);
                e10.printStackTrace();
                if (this.dieLevel == 0) break block21;
                this.dieOnExit = true;
            }
        }
        return false;
    }

    public void parseFiles(PrintStream log) throws JasperException {
        File f2;
        boolean urirootSet;
        block61: {
            boolean scratchDirSet = this.scratchDir != null;
            boolean bl2 = urirootSet = this.uriRoot != null;
            if (this.scratchDir == null) {
                String temp = System.getProperty("java.io.tempdir");
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(new File(temp).getAbsolutePath());
            }
            f2 = new File(this.args[this.argPos]);
            while (!f2.exists()) {
                boolean webApp = false;
                if (SWITCH_FILE_WEBAPP.equals(this.args[this.argPos])) {
                    webApp = true;
                    if (this.args.length > this.argPos + 1) {
                        f2 = new File(this.args[this.argPos + 1]);
                    } else {
                        Constants.message("jspc.error.emptyWebApp", 1);
                        return;
                    }
                }
                if (f2.exists()) continue;
                Constants.message("jspc.error.fileDoesNotExist", new Object[]{f2}, 2);
                ++this.argPos;
                if (webApp) {
                    ++this.argPos;
                }
                if (this.argPos >= this.args.length) {
                    return;
                }
                f2 = new File(this.args[this.argPos]);
            }
            if (this.uriRoot == null) {
                String tUriBase;
                if (SWITCH_FILE_WEBAPP.equals(this.args[this.argPos])) {
                    if (this.args.length > this.argPos + 1) {
                        f2 = new File(this.args[this.argPos + 1]);
                    } else {
                        return;
                    }
                }
                if ((tUriBase = this.uriBase) == null) {
                    tUriBase = "/";
                }
                try {
                    if (!f2.exists()) break block61;
                    f2 = new File(f2.getCanonicalPath());
                    while (f2 != null) {
                        String fParent;
                        File g2 = new File(f2, "WEB-INF");
                        if (g2.exists() && g2.isDirectory()) {
                            this.uriRoot = f2.getCanonicalPath();
                            this.uriBase = tUriBase;
                            Constants.message("jspc.implicit.uriRoot", new Object[]{this.uriRoot}, 3);
                            break;
                        }
                        if (f2.exists() && f2.isDirectory()) {
                            tUriBase = "/" + f2.getName() + "/" + tUriBase;
                        }
                        if ((fParent = f2.getParent()) == null) {
                            f2 = new File(this.args[this.argPos]);
                            fParent = f2.getParent();
                            if (fParent == null) {
                                fParent = File.separator;
                            }
                            this.uriRoot = new File(fParent).getCanonicalPath();
                            this.uriBase = "/";
                            break;
                        }
                        f2 = new File(fParent);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        String file = this.nextFile();
        File froot = new File(this.uriRoot);
        String ubase = null;
        try {
            ubase = froot.getCanonicalPath();
        }
        catch (IOException iOException) {}
        while (file != null) {
            if (SWITCH_FILE_WEBAPP.equals(file)) {
                CharArrayWriter mappingout;
                CharArrayWriter servletout;
                FileWriter mapout;
                String base = this.nextFile();
                if (base == null) {
                    Constants.message("jspc.error.emptyWebApp", 1);
                    return;
                }
                String oldRoot = this.uriRoot;
                if (!urirootSet) {
                    this.uriRoot = base;
                }
                Vector<String> pages = new Vector<String>();
                Stack<String> dirs = new Stack<String>();
                dirs.push(base);
                if (this.extensions == null) {
                    this.extensions = new Vector();
                    this.extensions.addElement("jsp");
                }
                while (!dirs.isEmpty()) {
                    String s2 = dirs.pop().toString();
                    f2 = new File(s2);
                    if (!f2.exists() || !f2.isDirectory()) continue;
                    String[] files = f2.list();
                    int i2 = 0;
                    while (i2 < files.length) {
                        File f22 = new File(s2, files[i2]);
                        if (f22.isDirectory()) {
                            dirs.push(f22.getPath());
                        } else {
                            String ext = files[i2].substring(files[i2].lastIndexOf(46) + 1);
                            if (this.extensions.contains(ext)) {
                                pages.addElement(String.valueOf(s2) + File.separatorChar + files[i2]);
                            }
                        }
                        ++i2;
                    }
                }
                String ubaseOld = ubase;
                File frootOld = froot;
                froot = new File(this.uriRoot);
                try {
                    ubase = froot.getCanonicalPath();
                }
                catch (IOException iOException) {}
                try {
                    if (this.webxmlLevel >= 10) {
                        File fmapings = new File(this.webxmlFile);
                        mapout = new FileWriter(fmapings);
                        servletout = new CharArrayWriter();
                        mappingout = new CharArrayWriter();
                    } else {
                        mapout = null;
                        servletout = null;
                        mappingout = null;
                    }
                    if (this.webxmlLevel >= 20) {
                        mapout.write(Constants.getString("jspc.webxml.header"));
                    } else if (this.webxmlLevel >= 10) {
                        mapout.write(Constants.getString("jspc.webinc.header"));
                    }
                }
                catch (IOException iOException) {
                    mapout = null;
                    servletout = null;
                    mappingout = null;
                }
                try {
                    JspCServletContext context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + ubase.replace('\\', '/') + "/"));
                    this.tldLocationsCache = new TldLocationsCache(context);
                }
                catch (MalformedURLException me) {
                    System.out.println("**" + me);
                }
                Enumeration e10 = pages.elements();
                while (e10.hasMoreElements()) {
                    String nextjsp = e10.nextElement().toString();
                    try {
                        File fjsp;
                        String s3;
                        if (ubase != null && (s3 = (fjsp = new File(nextjsp)).getCanonicalPath()).startsWith(ubase)) {
                            nextjsp = s3.substring(ubase.length());
                        }
                    }
                    catch (IOException iOException) {}
                    if (nextjsp.startsWith("." + File.separatorChar)) {
                        nextjsp = nextjsp.substring(2);
                    }
                    this.parseFile(log, nextjsp, servletout, mappingout);
                }
                this.uriRoot = oldRoot;
                ubase = ubaseOld;
                froot = frootOld;
                if (mapout != null) {
                    try {
                        servletout.writeTo(mapout);
                        mappingout.writeTo(mapout);
                        if (this.webxmlLevel >= 20) {
                            mapout.write(Constants.getString("jspc.webxml.footer"));
                        } else if (this.webxmlLevel >= 10) {
                            mapout.write(Constants.getString("jspc.webinc.footer"));
                        }
                        ((Writer)mapout).close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                block62: {
                    try {
                        if (ubase == null) break block62;
                        try {
                            JspCServletContext context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + ubase.replace('\\', '/') + '/'));
                            this.tldLocationsCache = new TldLocationsCache(context);
                        }
                        catch (MalformedURLException me) {
                            System.out.println("**" + me);
                        }
                        File fjsp = new File(file);
                        String s4 = fjsp.getCanonicalPath();
                        if (s4.startsWith(ubase)) {
                            file = s4.substring(ubase.length());
                        }
                    }
                    catch (IOException iOException) {}
                }
                this.parseFile(log, file, null, null);
            }
            file = this.nextFile();
        }
        if (this.dieOnExit) {
            System.exit(die);
        }
    }

    private void pushBackArg() {
        if (!this.fullstop) {
            --this.argPos;
        }
    }
}

