/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspLineMap;
import org.apache.jasper.compiler.JspLineMapItem;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;

    public Compiler(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public String changeEncodingIfNecessary(JspReader tmpReader) throws ParseException {
        while (tmpReader.skipUntil("<%@") != null) {
            tmpReader.skipSpaces();
            if (!tmpReader.matches("page")) continue;
            tmpReader.advance(4);
            tmpReader.skipSpaces();
            try {
                int loc;
                Attributes attrs = tmpReader.parseTagAttributes();
                String ct2 = attrs.getValue("contentType");
                if (ct2 == null || (loc = ct2.indexOf("charset=")) <= 0) continue;
                String encoding = ct2.substring(loc + 8);
                return encoding;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        OutputStreamWriter osw;
        String classFileName = this.mangler.getClassFileName();
        String className = this.mangler.getClassName();
        this.ctxt.setServletClassName(className);
        Constants.message("jsp.message.class_name_is", new Object[]{className}, 4);
        if (!this.isOutDated()) {
            return false;
        }
        String javaFileName = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(javaFileName);
        Constants.message("jsp.message.java_file_name_is", new Object[]{javaFileName}, 4);
        String javaEncoding = "UTF8";
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            if (javaEncoding != null) {
                try {
                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    throw new JasperException(Constants.getString("jsp.error.invalid.javaEncoding", new Object[]{"UTF8", javaEncoding}));
                }
            }
            throw new JasperException(Constants.getString("jsp.error.needAlternateJavaEncoding", new Object[]{"UTF8"}));
        }
        ServletWriter writer = new ServletWriter(new PrintWriter(osw));
        this.ctxt.setWriter(writer);
        ParserController parserCtl = new ParserController(this.ctxt);
        parserCtl.parse(this.ctxt.getJspFile());
        ParseEventListener listener = parserCtl.getParseEventListener();
        listener.beginPageProcessing();
        listener.endPageProcessing();
        writer.close();
        ((JspParseEventListener)listener).validate();
        String classpath = this.ctxt.getClassPath();
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-encoding", javaEncoding, "-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath, "-d", this.ctxt.getOutputDir(), javaFileName};
        StringBuffer b10 = new StringBuffer();
        int i2 = 0;
        while (i2 < argv.length) {
            b10.append(argv[i2]);
            b10.append(" ");
            ++i2;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{b10.toString()}, 4);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(javaEncoding);
        this.javac.setClasspath(String.valueOf(System.getProperty("java.class.path")) + sep + classpath);
        this.javac.setOutputDir(this.ctxt.getJavacOutputDir());
        this.javac.setMsgOutput(out);
        this.javac.setClassDebugInfo(this.ctxt.getOptions().getClassDebugInfo());
        boolean status = this.javac.compile(javaFileName);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            msg = this.getJspLineErrors(msg, writer.getLineMap());
            throw new JasperException(String.valueOf(Constants.getString("jsp.error.unable.compile")) + msg);
        }
        return true;
    }

    private String createErrorMsg(JspLineMap map, JspLineMapItem mapping) {
        StringBuffer msg = new StringBuffer();
        if (mapping.getBeginJspLnr() == mapping.getEndJspLnr()) {
            msg.append(Constants.getString("jsp.error.single.line.number", new Object[]{new Integer(mapping.getBeginJspLnr()), map.getFileName(mapping.getStartJspFileNr())}));
        } else {
            msg.append(Constants.getString("jsp.error.multiple.line.number", new Object[]{new Integer(mapping.getBeginJspLnr()), new Integer(mapping.getEndJspLnr()), map.getFileName(mapping.getStartJspFileNr())}));
        }
        msg.append(Constants.getString("jsp.error.corresponding.servlet"));
        return msg.toString();
    }

    private String findMapping(JspLineMap map, int lineNr) {
        int i2 = map.size() - 1;
        while (i2 >= 0) {
            JspLineMapItem mapItem = map.get(i2);
            if (mapItem != null && mapItem.getBeginServletLnr() <= lineNr && mapItem.getEndServletLnr() >= lineNr) {
                return this.createErrorMsg(map, mapItem);
            }
            --i2;
        }
        return null;
    }

    private String getJspLineErrors(String msg, JspLineMap map) throws IOException {
        String line;
        if (map == null) {
            return msg;
        }
        StringBuffer errorMsg = new StringBuffer();
        BufferedReader br2 = new BufferedReader(new StringReader(msg));
        while ((line = br2.readLine()) != null) {
            int beginColon = line.indexOf(58, 2);
            int endColon = line.indexOf(58, beginColon + 1);
            if (beginColon >= 0 && endColon >= 0 && !line.startsWith("Note: ")) {
                try {
                    String nr = line.substring(beginColon + 1, endColon);
                    int lineNr = Integer.parseInt(nr);
                    String mapping = this.findMapping(map, lineNr);
                    if (mapping == null) {
                        errorMsg.append('\n');
                    } else {
                        errorMsg.append(mapping);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int i2 = 0;
            while (i2 < line.length()) {
                char c10 = line.charAt(i2);
                if (c10 == '<') {
                    errorMsg.append("&lt;");
                } else if (c10 == '>') {
                    errorMsg.append("&gt;");
                } else {
                    errorMsg.append(c10);
                }
                ++i2;
            }
            errorMsg.append('\n');
        }
        br2.close();
        map.clear();
        return errorMsg.toString();
    }

    public boolean isOutDated() {
        return true;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.mangler.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

