/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class IncludeGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    boolean flush;
    Hashtable params;
    boolean isXml;

    public IncludeGenerator(Mark start, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        if (attrs.getLength() > 2) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        this.page = attrs.getValue("page");
        if (this.page == null) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        String flushString = attrs.getValue("flush");
        if (flushString == null && attrs.getLength() != 1) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        if (flushString == null || flushString.equalsIgnoreCase("false")) {
            this.flush = false;
        } else if (flushString.equalsIgnoreCase("true")) {
            this.flush = true;
        } else {
            throw new CompileException(start, Constants.getString("jsp.error.include.flush.invalid.value", new Object[]{flushString}));
        }
        this.params = param;
        this.isXml = isXml;
        this.isExpression = JspUtil.isExpression(this.page, isXml);
    }

    public void generate(ServletWriter writer, Class phase) {
        boolean initial = true;
        String sep = "?";
        writer.println("{");
        writer.pushIndent();
        writer.println("String _jspx_qStr = \"\";");
        if (this.params != null && this.params.size() > 0) {
            Enumeration en2 = this.params.keys();
            while (en2.hasMoreElements()) {
                String key = (String)en2.nextElement();
                String[] value = (String[])this.params.get(key);
                if (initial) {
                    sep = "?";
                    initial = false;
                } else {
                    sep = "&";
                }
                if (value.length == 1 && JspUtil.isExpression(value[0], this.isXml)) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + " + JspUtil.getExpr(value[0], this.isXml) + ";");
                    continue;
                }
                if (value.length == 1) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[0] + "\";");
                    continue;
                }
                int i2 = 0;
                while (i2 < value.length) {
                    if (!JspUtil.isExpression(value[i2], this.isXml)) {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[i2] + "\";");
                    } else {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" +" + JspUtil.getExpr(value[i2], this.isXml) + ";");
                    }
                    if (sep.equals("?")) {
                        sep = "&";
                    }
                    ++i2;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("JspRuntimeLibrary.include(request, response, " + writer.quoteString(this.page) + " + _jspx_qStr, " + "out, " + this.flush + ");");
        } else {
            writer.println("JspRuntimeLibrary.include(request, response, " + JspUtil.getExpr(this.page, this.isXml) + " + _jspx_qStr, " + "out, " + this.flush + ");");
        }
        writer.println("if (\"true\".equals(request.getAttribute(\"javax.servlet.forward.seen\")))");
        writer.pushIndent();
        writer.println("return;");
        writer.popIndent();
        writer.popIndent();
        writer.println("}");
    }
}

