/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Stack;
import org.apache.jasper.compiler.JspReader;

public final class Mark {
    int cursor;
    int line;
    int col;
    int fileid;
    String fileName;
    String baseDir;
    char[] stream = null;
    Stack includeStack = null;
    String encoding = null;
    private JspReader reader;

    Mark(String filename, int line, int col) {
        this.reader = null;
        this.stream = null;
        this.cursor = 0;
        this.line = line;
        this.col = col;
        this.fileid = -1;
        this.fileName = filename;
        this.baseDir = "le-basedir";
        this.encoding = "le-endocing";
        this.includeStack = null;
    }

    Mark(JspReader reader, char[] inStream, int fileid, String name, String inBaseDir, String inEncoding) {
        this.reader = reader;
        this.stream = inStream;
        this.col = 0;
        this.line = 0;
        this.cursor = 0;
        this.fileid = fileid;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.includeStack = new Stack();
    }

    Mark(Mark other) {
        this.reader = other.reader;
        this.stream = other.stream;
        this.fileid = other.fileid;
        this.fileName = other.fileName;
        this.cursor = other.cursor;
        this.line = other.line;
        this.col = other.col;
        this.baseDir = other.baseDir;
        this.encoding = other.encoding;
        this.includeStack = new Stack();
        int i2 = 0;
        while (i2 < other.includeStack.size()) {
            this.includeStack.addElement(other.includeStack.elementAt(i2));
            ++i2;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Mark) {
            Mark m2 = (Mark)other;
            return this.reader == m2.reader && this.fileid == m2.fileid && this.cursor == m2.cursor && this.line == m2.line && this.col == m2.col;
        }
        return false;
    }

    public int getColumnNumber() {
        return this.col;
    }

    public String getFile() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.getFile();
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState state = (IncludeState)this.includeStack.pop();
        this.cursor = state.cursor;
        this.line = state.line;
        this.col = state.col;
        this.fileid = state.fileid;
        this.fileName = state.fileName;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return true;
    }

    public void pushStream(char[] inStream, int inFileid, String name, String inBaseDir, String inEncoding) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileid, this.fileName, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.line = 0;
        this.col = 0;
        this.fileid = inFileid;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.stream = inStream;
    }

    public String toShortString() {
        return "(" + this.line + "," + this.col + ")";
    }

    public String toString() {
        return String.valueOf(this.getFile()) + "(" + this.line + "," + this.col + ")";
    }

    class IncludeState {
        int cursor;
        int line;
        int col;
        int fileid;
        String fileName;
        String baseDir;
        String encoding;
        char[] stream = null;

        IncludeState(int inCursor, int inLine, int inCol, int inFileid, String name, String inBaseDir, String inEncoding, char[] inStream) {
            this.cursor = inCursor;
            this.line = inLine;
            this.col = inCol;
            this.fileid = inFileid;
            this.fileName = name;
            this.baseDir = inBaseDir;
            this.encoding = inEncoding;
            this.stream = inStream;
        }
    }
}

