/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class ParserXJspSaxHandler
extends DefaultHandler
implements LexicalHandler {
    private ParseEventListener jspHandler;
    private boolean inDtd;
    private boolean inCdata;
    private boolean inEntity;
    private Stack stack;
    private Locator locator;
    private String filePath;
    static final String JSP_PUBLIC_ID1 = "-//Sun Microsystems Inc.//DTD JavaServer Pages Version 1.1//EN";
    static final String JSP_PUBLIC_ID2 = "-//Sun Microsystems Inc.//DTD JavaServer Pages Version 1.2//EN";
    static final String JSP_SYSTEM_ID = "http://java.sun.com/products/jsp/dtd/jspcore_1_2.dtd";
    static final String JSP_SYSTEM_ID_INTERNAL = "/org/apache/jasper/resources/jsp12.dtd";

    public ParserXJspSaxHandler(String filePath, ParseEventListener jspHandler) throws JasperException {
        this.filePath = filePath;
        this.jspHandler = jspHandler;
        this.stack = new Stack();
        this.inEntity = false;
        this.inDtd = false;
        this.inCdata = false;
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        Node node = (Node)this.stack.peek();
        node.addText(ch2, start, length);
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.inCdata = false;
    }

    public void endDTD() throws SAXException {
        this.inDtd = false;
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        Mark stop = new Mark(this.filePath, this.locator.getLineNumber(), this.locator.getColumnNumber());
        String name = rawName;
        Node node = (Node)this.stack.pop();
        try {
            if (name.equals("jsp:root")) {
                node.validate(true, false);
                this.jspHandler.handleRootEnd();
            } else if (name.equals("jsp:text")) {
                node.validate(false, true);
                this.jspHandler.handleJspCdata(node.start, stop, node.getText());
            } else if (name.equals("jsp:directive.include")) {
                node.validate(true, false);
                this.jspHandler.handleDirective("include", node.start, stop, node.attrs);
            } else if (name.equals("jsp:directive.page")) {
                node.validate(true, false);
                this.jspHandler.handleDirective("page", node.start, stop, node.attrs);
            } else if (name.equals("jsp:declaration")) {
                node.validate(false, true);
                this.jspHandler.handleDeclaration(node.start, stop, null, node.getText());
            } else if (name.equals("jsp:expression")) {
                node.validate(false, true);
                this.jspHandler.handleExpression(node.start, stop, null, node.getText());
            } else if (name.equals("jsp:scriptlet")) {
                node.validate(false, true);
                this.jspHandler.handleScriptlet(node.start, stop, null, node.getText());
            } else if (name.equals("jsp:param")) {
                node.validate(true, false);
                this.stack.push(node);
            } else {
                if (name.equals("jsp:params")) {
                    return;
                }
                if (name.equals("jsp:fallback")) {
                    node.validate(false, true);
                    this.stack.push(node);
                } else if (name.equals("jsp:include")) {
                    Hashtable params = null;
                    if (!node.rawName.equals("jsp:include")) {
                        this.stack.push(node);
                        params = this.popParams();
                        node = (Node)this.stack.pop();
                    }
                    node.validate(true, false);
                    this.jspHandler.handleInclude(node.start, stop, node.attrs, params, true);
                } else if (name.equals("jsp:forward")) {
                    Hashtable params = null;
                    if (!node.rawName.equals("jsp:forward")) {
                        this.stack.push(node);
                        params = this.popParams();
                        node = (Node)this.stack.pop();
                    }
                    node.validate(true, false);
                    this.jspHandler.handleForward(node.start, stop, node.attrs, params, true);
                } else if (name.equals("jsp:useBean")) {
                    node.validate(true, false);
                    this.jspHandler.handleBeanEnd(node.start, stop, node.attrs);
                } else if (name.equals("jsp:getProperty")) {
                    node.validate(true, false);
                    this.jspHandler.handleGetProperty(node.start, stop, node.attrs);
                } else if (name.equals("jsp:setProperty")) {
                    node.validate(true, false);
                    this.jspHandler.handleSetProperty(node.start, stop, node.attrs, true);
                } else if (name.equals("jsp:plugin")) {
                    Hashtable params = null;
                    String fallback = null;
                    if (node.rawName.equals("jsp:fallback")) {
                        fallback = String.valueOf(node.getText());
                        node = (Node)this.stack.pop();
                    }
                    if (!node.rawName.equals("jsp:plugin")) {
                        this.stack.push(node);
                        params = this.popParams();
                        node = (Node)this.stack.pop();
                    }
                    node.validate(true, false);
                    this.jspHandler.handlePlugin(node.start, stop, node.attrs, params, fallback, true);
                } else if (node.isUninterpretedTag()) {
                    this.jspHandler.handleUninterpretedTagEnd(stop, stop, rawName, node.getText());
                } else {
                    node.validate(true, false);
                    this.processCustomTagEnd((NodeTag)node, stop);
                }
            }
        }
        catch (Exception ex2) {
            if (ex2 instanceof SAXException) {
                throw (SAXException)ex2;
            }
            throw new SAXException(ex2);
        }
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void error(SAXParseException ex2) throws SAXException {
        this.printException("ERROR", ex2);
        throw ex2;
    }

    public void fatalError(SAXParseException ex2) throws SAXException {
        this.printException("FATAL", ex2);
        throw ex2;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
    }

    private String ltrim(String orig) {
        int len = orig.length();
        int st = 0;
        int off = 0;
        char[] val = orig.toCharArray();
        while (st < len && val[off + st] <= ' ') {
            ++st;
        }
        return st > 0 || len < orig.length() ? orig.substring(st, len) : orig;
    }

    private char[] makeCharArray(char[] buf, int offset, int len) {
        char[] ret = new char[len];
        int i2 = 0;
        int j2 = offset;
        while (i2 < len) {
            ret[i2] = buf[j2];
            ++i2;
            ++j2;
        }
        return ret;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    void p(String s2) {
        System.out.println(s2);
    }

    void p(Node node) {
        node.display();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private Hashtable popParams() throws ParseException {
        Hashtable<String, String[]> params;
        block7: {
            Node node;
            block6: {
                params = new Hashtable<String, String[]>();
                if (!true) break block6;
                node = (Node)this.stack.peek();
                if (!node.rawName.equals("jsp:param")) break block7;
            }
            do {
                String[] newval;
                node = (Node)this.stack.pop();
                String name = node.attrs.getValue("name");
                String value = node.attrs.getValue("value");
                if (name == null) {
                    throw new ParseException(node.start, Constants.getString("jsp.error.param.noname"));
                }
                if (value == null) {
                    throw new ParseException(node.start, Constants.getString("jsp.error.param.novalue"));
                }
                String[] oldval = (String[])params.get(name);
                if (oldval == null) {
                    newval = new String[]{value};
                    params.put(name, newval);
                } else {
                    newval = new String[oldval.length + 1];
                    System.arraycopy(oldval, 0, newval, 0, oldval.length);
                    newval[oldval.length] = value;
                    params.put(name, newval);
                }
                node = (Node)this.stack.peek();
            } while (node.rawName.equals("jsp:param"));
        }
        return params;
    }

    private void printException(String level, SAXParseException ex2) {
        this.p("\n*** SAXParseException: " + level);
        this.p("Public ID: " + ex2.getPublicId());
        this.p("System ID: " + ex2.getSystemId());
        this.p("line " + ex2.getLineNumber() + ", col " + ex2.getColumnNumber());
        ex2.printStackTrace(System.out);
    }

    private void printLocation() {
        this.p("--- (" + this.locator.getSystemId() + ", " + this.locator.getPublicId() + ") (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ")");
    }

    private void processCustomTagBegin(String prefix, String shortTagName) throws ParseException, JasperException {
        Node node = (Node)this.stack.pop();
        TagLibraries libraries = this.jspHandler.getTagLibraries();
        if (shortTagName == null) {
            throw new ParseException(node.start, "Nothing after the :");
        }
        TagLibraryInfo tli = libraries.getTagLibInfo(prefix);
        TagInfo ti = tli.getTag(shortTagName);
        if (ti == null) {
            throw new ParseException(node.start, "Unable to locate TagInfo for " + prefix + ":" + shortTagName);
        }
        node = new NodeTag(node, prefix, shortTagName, tli, ti);
        this.stack.push(node);
    }

    private void processCustomTagBeginDoIt(NodeTag node, boolean hasBody) throws JasperException {
        if (!node.isBeginDone()) {
            this.jspHandler.handleTagBegin(node.start, node.start, node.attrs, node.prefix, node.shortTagName, node.tli, node.ti, hasBody, true);
            node.setBeginDone(true);
        }
    }

    private void processCustomTagEnd(NodeTag node, Mark stop) throws ParseException, JasperException {
        String bc2 = node.ti.getBodyContent();
        boolean hasBody = true;
        if (node.getText() != null) {
            String charString = node.getText().toString();
            hasBody = charString.trim().length() > 0;
        }
        this.processCustomTagBeginDoIt(node, hasBody);
        if (node.getText() != null && bc2.equalsIgnoreCase("EMPTY")) {
            throw new ParseException(node.start, "Body is supposed to be empty for " + node.rawName);
        }
        this.jspHandler.handleTagEnd(node.start, stop, node.prefix, node.shortTagName, node.attrs, node.tli, node.ti, hasBody);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId.equals(JSP_PUBLIC_ID1) || publicId.equals(JSP_PUBLIC_ID2)) {
            InputStream is = this.getClass().getResourceAsStream(JSP_SYSTEM_ID_INTERNAL);
            InputSource isrc = new InputSource(is);
            return isrc;
        }
        System.out.println("ERROR: publicID does not match: " + publicId);
        return null;
    }

    private String rtrim(String orig) {
        int len = orig.length();
        int st = 0;
        int off = 0;
        char[] val = orig.toCharArray();
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < orig.length() ? orig.substring(st, len) : orig;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCdata = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        String name = rawName;
        Mark start = new Mark(this.filePath, this.locator.getLineNumber(), this.locator.getColumnNumber());
        Node node = new Node(rawName, new AttributesImpl(attrs), start);
        if (name.equals("jsp:params")) {
            return;
        }
        Node prevNode = null;
        if (!this.stack.empty() && (prevNode = (Node)this.stack.peek()) instanceof NodeTag) {
            try {
                this.processCustomTagBeginDoIt((NodeTag)prevNode, true);
            }
            catch (Exception ex2) {
                throw new SAXException(ex2);
            }
        }
        this.stack.push(node);
        try {
            if (prevNode != null && prevNode.isUninterpretedTag() && prevNode.getText() != null) {
                this.jspHandler.handleCharData(prevNode.start, start, prevNode.getText());
                prevNode.clearText();
            }
            if (name.equals("jsp:root")) {
                this.jspHandler.handleRootBegin(node.attrs);
            } else if (name.equals("jsp:useBean")) {
                this.jspHandler.handleBean(node.start, node.start, node.attrs, true);
            } else if (name.length() < 4 || !name.substring(0, 4).equals("jsp:")) {
                int i2 = name.indexOf(58);
                boolean isCustomTag = false;
                if (i2 != -1) {
                    String prefix = name.substring(0, i2);
                    String shortTagName = name.substring(i2 + 1);
                    TagLibraries libraries = this.jspHandler.getTagLibraries();
                    if (libraries.isUserDefinedTag(prefix, shortTagName)) {
                        isCustomTag = true;
                        this.processCustomTagBegin(prefix, shortTagName);
                    }
                }
                if (!isCustomTag) {
                    node.setUninterpreted(true);
                    this.jspHandler.handleUninterpretedTagBegin(node.start, node.start, node.rawName, node.attrs);
                }
            }
        }
        catch (Exception ex3) {
            throw new SAXException(ex3);
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void warning(SAXParseException ex2) throws SAXException {
        this.printException("WARNING", ex2);
    }

    private class Node {
        String rawName;
        Attributes attrs;
        Mark start;
        boolean isRoot;
        boolean isUninterpretedTag = false;
        StringBuffer text = null;

        Node(String rawName, Attributes attrs, Mark start) {
            this.rawName = rawName;
            this.attrs = attrs;
            this.start = start;
            this.isRoot = rawName.equals("jsp:root");
        }

        Node(Node node) {
            this(node.rawName, node.attrs, node.start);
        }

        void addText(char[] chars, int start, int length) {
            if (this.text == null) {
                this.text = new StringBuffer();
            }
            this.text.append(chars, start, length);
        }

        void clearText() {
            this.text = null;
        }

        public void display() {
            ParserXJspSaxHandler.this.p("NODE: " + this.rawName);
            int i2 = 0;
            while (i2 < this.attrs.getLength()) {
                ParserXJspSaxHandler.this.p("attrs[" + i2 + "] " + this.attrs.getQName(i2) + " = " + this.attrs.getValue(i2));
                ++i2;
            }
        }

        char[] getText() {
            return this.text == null ? null : this.text.toString().toCharArray();
        }

        boolean isRoot() {
            return this.isRoot;
        }

        boolean isUninterpretedTag() {
            return this.isUninterpretedTag;
        }

        void setUninterpreted(boolean isUninterpretedTag) {
            this.isUninterpretedTag = isUninterpretedTag;
        }

        void validate(boolean canHaveAttributes, boolean canHaveText) throws SAXException {
            String data;
            if (!canHaveAttributes && this.attrs.getLength() != 0) {
                throw new SAXException("VALIDATE ERROR: " + this.rawName + " cannot have attributes.");
            }
            if (!canHaveText && this.text != null && (data = this.text.toString().trim()).length() > 0) {
                throw new SAXException(Constants.getString("jspx.error.templateDataNotInJspCdata", new Object[]{this.rawName, JspUtil.escapeXml(data)}));
            }
        }
    }

    private class NodeTag
    extends Node {
        String prefix;
        String shortTagName;
        TagLibraryInfo tli;
        TagInfo ti;
        boolean beginDone;

        NodeTag(Node node, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti) {
            super(node);
            this.prefix = prefix;
            this.shortTagName = shortTagName;
            this.tli = tli;
            this.ti = ti;
            this.beginDone = false;
        }

        boolean isBeginDone() {
            return this.beginDone;
        }

        void setBeginDone(boolean beginDone) {
            this.beginDone = beginDone;
        }
    }
}

