/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.apache.jasper.core.JasperException;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.LogAware;
import org.apache.jasper.util.FastDateFormat;
import org.xml.sax.SAXException;

public abstract class Logger {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected static Writer defaultSink = new OutputStreamWriter(System.err);
    protected static Hashtable loggers = new Hashtable(5);
    protected static Logger defaultLogger = new DefaultLogger();
    protected boolean custom = true;
    protected Writer sink = defaultSink;
    String path;
    protected String name;
    private int level = 2;
    protected boolean timestamp = true;
    protected boolean timestampRaw = false;
    protected String timestampFormat = "yyyy-MM-dd hh:mm:ss";
    protected DateFormat timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
    private static FieldPosition position;

    static {
        defaultLogger.setVerbosityLevel(4);
        position = new FieldPosition(1);
    }

    public static boolean canIgnore(Throwable t2) {
        String msg = t2.getMessage();
        if (t2 instanceof InterruptedIOException) {
            return true;
        }
        return t2 instanceof IOException ? "Broken pipe".equals(msg) : t2 instanceof SocketException;
    }

    public synchronized void close() {
        this.sink = null;
        loggers.remove(this.getName());
    }

    public abstract void flush();

    protected String formatTimestamp(long msec) {
        StringBuffer buf = new StringBuffer();
        this.formatTimestamp(msec, buf);
        return buf.toString();
    }

    protected void formatTimestamp(long msec, StringBuffer buf) {
        if (!this.timestamp) {
            return;
        }
        if (this.timestampRaw) {
            buf.append(Long.toString(msec));
            return;
        }
        Date d10 = new Date(msec);
        this.timestampFormatter.format(d10, buf, position);
    }

    public static Logger getDefaultLogger() {
        return defaultLogger;
    }

    public static Logger getLogger(String name) {
        return (Logger)loggers.get(name);
    }

    public static Enumeration getLoggerNames() {
        return loggers.keys();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getTimestampFormat() {
        if (this.timestampRaw) {
            return "msec";
        }
        return this.timestampFormat;
    }

    public int getVerbosityLevel() {
        return this.level;
    }

    public boolean isOpen() {
        return this.sink != null;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public final void log(String message) {
        this.log(message, 3);
    }

    public final void log(String message, int verbosityLevel) {
        this.log(message, null, verbosityLevel);
    }

    public final void log(String message, Throwable t2) {
        this.log(message, t2, 1);
    }

    public final void log(String message, Throwable t2, int verbosityLevel) {
        if (this.matchVerbosityLevel(verbosityLevel)) {
            if (t2 == null) {
                this.realLog(message);
            } else {
                this.realLog(message, t2);
            }
        }
    }

    public boolean matchVerbosityLevel(int verbosityLevel) {
        return verbosityLevel <= this.getVerbosityLevel();
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new FileWriter(this.path);
        }
        catch (IOException iOException) {
            System.err.print("Unable to open log file: " + this.path + "! ");
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    private static void printThrowable(PrintWriter w2, Throwable t2, String rootcause) {
        if (t2 != null) {
            Exception embedded;
            t2.printStackTrace(w2);
            if (t2 instanceof ServletException) {
                Throwable cause = ((ServletException)t2).getRootCause();
                if (cause != null) {
                    w2.println(rootcause);
                    Logger.printThrowable(w2, cause, rootcause);
                }
            } else if (t2 instanceof JasperException) {
                Throwable cause = ((JasperException)t2).getRootCause();
                if (cause != null) {
                    w2.println(rootcause);
                    Logger.printThrowable(w2, cause, rootcause);
                }
            } else if (t2 instanceof SQLException) {
                SQLException sql = ((SQLException)t2).getNextException();
                if (sql != null) {
                    w2.println("Next SQL Exception:");
                    Logger.printThrowable(w2, sql, rootcause);
                }
            } else if (t2 instanceof SAXException && (embedded = ((SAXException)t2).getException()) != null) {
                w2.println("Embedded SAX Exception:");
                Logger.printThrowable(w2, embedded, rootcause);
            }
        }
    }

    public static void putLogger(Logger logger) {
        loggers.put(logger.getName(), logger);
    }

    protected abstract void realLog(String var1);

    protected abstract void realLog(String var1, Throwable var2);

    public static void removeLogger(Logger logger) {
        loggers.remove(logger.getName());
    }

    public void setCustomOutput(String value) {
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            this.custom = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            this.custom = false;
        }
    }

    public static void setDefaultSink(Writer w2) {
        defaultSink = w2;
    }

    public void setName(String name) {
        this.name = name;
        Logger.putLogger(this);
    }

    public void setPath(String path) {
        if (File.separatorChar == '/') {
            this.path = path.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = path.replace('/', '\\');
        }
    }

    public void setTimestamp(String value) {
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            this.timestamp = true;
        } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            this.timestamp = false;
        }
    }

    public void setTimestampFormat(String value) {
        if (value.equalsIgnoreCase("msec")) {
            this.timestampRaw = true;
        } else {
            this.timestampRaw = false;
            this.timestampFormat = value;
            this.timestampFormatter = new FastDateFormat(new SimpleDateFormat(this.timestampFormat));
        }
    }

    public void setVerbosityLevel(int level) {
        this.level = level;
    }

    public void setVerbosityLevel(String level) {
        if ("warning".equalsIgnoreCase(level)) {
            this.level = 2;
        } else if ("fatal".equalsIgnoreCase(level)) {
            this.level = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(level)) {
            this.level = 1;
        } else if ("information".equalsIgnoreCase(level)) {
            this.level = 3;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.level = 4;
        }
    }

    public static String throwableToString(Throwable t2) {
        return Logger.throwableToString(t2, "Root cause:");
    }

    public static String throwableToString(Throwable t2, String rootcause) {
        if (rootcause == null) {
            rootcause = "Root Cause:";
        }
        StringWriter sw = new StringWriter();
        PrintWriter w2 = new PrintWriter(sw);
        Logger.printThrowable(w2, t2, rootcause);
        w2.flush();
        return sw.toString();
    }

    public String toString() {
        return "Logger(" + this.getName() + ", " + this.getPath() + ")";
    }

    public static class Helper
    implements LogAware {
        private String logname;
        private String prefix;
        private Logger logger;
        private Helper proxy;

        protected Helper(String logname) {
            this.logname = logname;
            String cname = this.getClass().getName();
            this.prefix = cname.substring(cname.lastIndexOf(".") + 1);
        }

        public Helper(String logname, Object owner) {
            this.logname = logname;
            String cname = owner.getClass().getName();
            this.prefix = cname.substring(cname.lastIndexOf(".") + 1);
        }

        public Helper(String logname, String prefix) {
            this.logname = logname;
            this.prefix = prefix;
        }

        public Logger getLogger() {
            if (this.proxy != null) {
                this.logger = this.proxy.getLogger();
            }
            return this.logger;
        }

        public Helper getLoggerHelper() {
            return this;
        }

        public void log(String msg) {
            this.log(msg, null, 3);
        }

        public void log(String msg, int level) {
            this.log(msg, null, level);
        }

        public void log(String msg, Throwable t2) {
            this.log(msg, t2, 1);
        }

        public void log(String msg, Throwable t2, int level) {
            Logger loggerTemp;
            if (this.prefix != null) {
                msg = String.valueOf(this.prefix) + ": " + msg;
            }
            if (this.proxy != null) {
                this.logger = this.proxy.getLogger();
            }
            if (this.logger == null && this.logname != null) {
                this.logger = Logger.getLogger(this.logname);
            }
            if ((loggerTemp = this.logger) == null) {
                loggerTemp = defaultLogger;
            }
            loggerTemp.log(msg, t2, level);
        }

        public void setLogPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setLogger(Logger logger) {
            if (logger != null) {
                this.setLogname(logger.getName());
            }
            this.logger = logger;
        }

        public void setLogname(String logname) {
            this.logger = null;
            this.logname = logname;
        }

        public void setProxy(Helper helper) {
            this.proxy = helper;
        }
    }
}

