/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.jasper.Constants;

public class JspWriterImpl
extends JspWriter {
    protected Writer out;
    protected ServletResponse response;
    protected char[] cb;
    protected int nextChar;
    protected static int defaultCharBufferSize = 8192;
    protected boolean flushed = false;
    protected boolean closed = false;
    static String lineSeparator = System.getProperty("line.separator");

    public JspWriterImpl() {
        super(defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse response) {
        this(response, defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse response, int sz, boolean autoFlush) {
        super(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = response;
        this.cb = sz == 0 ? null : new char[sz];
        this.nextChar = 0;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(Constants.getString("jsp.error.overflow"));
    }

    public final void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            if (this.flushed) {
                throw new IOException(Constants.getString("jsp.error.attempt_to_clear_flushed_buffer"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    public void clearBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                block7: {
                    if (this.response == null) break block7;
                    if (!this.closed) break block8;
                }
                Object var2_2 = null;
                return;
            }
            this.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
            this.closed = true;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.response == null || this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            if (this.out != null) {
                this.out.flush();
                this.response.flushBuffer();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                return;
            }
            this.flushed = true;
            this.ensureOpen();
            if (this.nextChar == 0) return;
            this.initOut();
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
            return;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    void init(ServletResponse response, int sz, boolean autoFlush) {
        this.response = response;
        if (sz > 0 && (this.cb == null || sz > this.cb.length)) {
            this.cb = new char[sz];
        }
        this.nextChar = 0;
        this.autoFlush = autoFlush;
        this.bufferSize = sz;
    }

    protected void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    private int min(int a, int b10) {
        if (a < b10) {
            return a;
        }
        return b10;
    }

    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(lineSeparator);
        }
    }

    public void print(char c10) throws IOException {
        this.write(String.valueOf(c10));
    }

    public void print(double d10) throws IOException {
        this.write(String.valueOf(d10));
    }

    public void print(float f2) throws IOException {
        this.write(String.valueOf(f2));
    }

    public void print(int i2) throws IOException {
        this.write(String.valueOf(i2));
    }

    public void print(long l2) throws IOException {
        this.write(String.valueOf(l2));
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        this.write(s2);
    }

    public void print(boolean b10) throws IOException {
        this.write(b10 ? "true" : "false");
    }

    public void print(char[] s2) throws IOException {
        this.write(s2);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(char x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(double x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(float x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(int x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(long x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(Object x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(String x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(boolean x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    public void println(char[] x2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x2);
            this.println();
        }
    }

    void recycle() {
        this.flushed = false;
        this.nextChar = 0;
    }

    public void write(int c10) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(c10);
            } else {
                if (this.nextChar >= this.bufferSize) {
                    if (this.autoFlush) {
                        this.flushBuffer();
                    } else {
                        this.bufferOverflow();
                    }
                }
                this.cb[this.nextChar++] = (char)c10;
            }
        }
    }

    public void write(String s2) throws IOException {
        this.write(s2, 0, s2.length());
    }

    public void write(String s2, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(s2, off, len);
                Object var5_5 = null;
                return;
            }
            int b10 = off;
            int t2 = off + len;
            while (b10 < t2) {
                int d10 = this.min(this.bufferSize - this.nextChar, t2 - b10);
                s2.getChars(b10, b10 + d10, this.cb, this.nextChar);
                b10 += d10;
                this.nextChar += d10;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(cbuf, off, len);
                return;
            }
            if (off < 0) throw new IndexOutOfBoundsException();
            if (off > cbuf.length) throw new IndexOutOfBoundsException();
            if (len < 0) throw new IndexOutOfBoundsException();
            if (off + len > cbuf.length) throw new IndexOutOfBoundsException();
            if (off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.initOut();
                this.out.write(cbuf, off, len);
                return;
            }
            int b10 = off;
            int t2 = off + len;
            while (true) {
                if (b10 >= t2) {
                    return;
                }
                int d10 = this.min(this.bufferSize - this.nextChar, t2 - b10);
                System.arraycopy(cbuf, b10, this.cb, this.nextChar, d10);
                b10 += d10;
                this.nextChar += d10;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }
}

