/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class FileDirContext
extends BaseDirContext {
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable env) {
        super(env);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        this.rebind(name, obj, attrs);
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        if (!file.mkdir()) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        return (DirContext)this.lookup(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    protected File file(String name) {
        File file;
        if (File.separatorChar == '\\') {
            name = name.replace('/', File.separatorChar);
        }
        if ((file = new File(this.base, name)).exists() && file.canRead()) {
            if (this.caseSensitive && File.separatorChar == '\\') {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = String.valueOf(fileAbsPath) + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                String canPath = null;
                try {
                    canPath = file.getCanonicalPath();
                    if (canPath != null) {
                        canPath = this.normalize(canPath);
                    }
                }
                catch (IOException iOException) {}
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    absPath = absPath.substring(this.absoluteBase.length());
                    if (canPath == null || absPath == null) {
                        return null;
                    }
                    if (absPath.equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length())).equals("")) {
                        canPath = "/";
                    }
                    if (!canPath.equals(absPath)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        return file;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new FileResourceAttributes(file);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected Vector list(File file) {
        Vector<NamingEntry> entries = new Vector<NamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        Arrays.sort(names);
        if (names == null) {
            return entries;
        }
        NamingEntry entry = null;
        int i2 = 0;
        while (i2 < names.length) {
            File currentFile = new File(file, (String)names[i2]);
            Object object = null;
            if (currentFile.isDirectory()) {
                FileDirContext tempContext = new FileDirContext(this.env);
                tempContext.setDocBase(file.getPath());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new NamingEntry((String)names[i2], object, 0);
            entries.addElement(entry);
            ++i2;
        }
        return entries;
    }

    public NamingEnumeration list(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        Vector entries = this.list(file);
        return new NamingContextEnumeration(entries);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        Vector entries = this.list(file);
        return new NamingContextBindingsEnumeration(entries);
    }

    public Object lookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        if (file.isDirectory()) {
            FileDirContext tempContext = new FileDirContext(this.env);
            tempContext.setDocBase(file.getPath());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    protected String normalize(String path) {
        int index;
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        InputStream is = null;
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException iOException) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
            if (!file.mkdir()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
        }
        if (is == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        try {
            block16: {
                FileOutputStream os = null;
                byte[] buffer = new byte[2048];
                int len = -1;
                try {
                    os = new FileOutputStream(file);
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    Object var10_10 = null;
                    if (os == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (os != null) {
                        os.close();
                    }
                    is.close();
                    throw throwable;
                }
                os.close();
            }
            is.close();
        }
        catch (IOException e10) {
            throw new NamingException(this.sm.getString("resources.bindFailed", e10));
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", oldName));
        }
        File newFile = new File(this.base, newName);
        file.renameTo(newFile);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.base = new File(docBase);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {}
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", docBase));
        }
        this.absoluteBase = this.normalize(this.base.getAbsolutePath());
        super.setDocBase(docBase);
    }

    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        if (!file.delete()) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", name));
        }
    }

    protected class FileResource
    extends Resource {
        protected File file;
        protected long length = -1L;

        public FileResource(File file) {
            this.file = file;
        }

        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                this.inputStream = new FileInputStream(this.file);
            }
            return super.streamContent();
        }
    }

    protected class FileResourceAttributes
    extends ResourceAttributes {
        protected File file;
        protected boolean accessed = false;

        public FileResourceAttributes(File file) {
            this.file = file;
        }

        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.file.lastModified();
            return this.creation;
        }

        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.file.lastModified();
            }
            return super.getCreationDate();
        }

        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.file.lastModified();
            }
            return super.getLastModifiedDate();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }
    }
}

