/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.regexp.RECompiler;

public class REDebugCompiler
extends RECompiler {
    static Hashtable hashOpcode = new Hashtable();

    static {
        hashOpcode.put(new Integer(56), "OP_RELUCTANTSTAR");
        hashOpcode.put(new Integer(61), "OP_RELUCTANTPLUS");
        hashOpcode.put(new Integer(47), "OP_RELUCTANTMAYBE");
        hashOpcode.put(new Integer(69), "OP_END");
        hashOpcode.put(new Integer(94), "OP_BOL");
        hashOpcode.put(new Integer(36), "OP_EOL");
        hashOpcode.put(new Integer(46), "OP_ANY");
        hashOpcode.put(new Integer(91), "OP_ANYOF");
        hashOpcode.put(new Integer(124), "OP_BRANCH");
        hashOpcode.put(new Integer(65), "OP_ATOM");
        hashOpcode.put(new Integer(42), "OP_STAR");
        hashOpcode.put(new Integer(43), "OP_PLUS");
        hashOpcode.put(new Integer(63), "OP_MAYBE");
        hashOpcode.put(new Integer(78), "OP_NOTHING");
        hashOpcode.put(new Integer(71), "OP_GOTO");
        hashOpcode.put(new Integer(92), "OP_ESCAPE");
        hashOpcode.put(new Integer(40), "OP_OPEN");
        hashOpcode.put(new Integer(41), "OP_CLOSE");
        hashOpcode.put(new Integer(35), "OP_BACKREF");
        hashOpcode.put(new Integer(80), "OP_POSIXCLASS");
    }

    String charToString(char c10) {
        if (c10 < ' ' || c10 > '\u007f') {
            return "\\" + c10;
        }
        return String.valueOf(c10);
    }

    public void dumpProgram(PrintWriter printWriter) {
        int n2 = 0;
        while (n2 < this.lenInstruction) {
            int n3;
            char c10 = this.instruction[n2];
            int n4 = this.instruction[n2 + 1];
            short s2 = (short)this.instruction[n2 + 2];
            printWriter.print(String.valueOf(n2) + ". " + this.nodeToString(n2) + ", next = ");
            if (s2 == 0) {
                printWriter.print("none");
            } else {
                printWriter.print(n2 + s2);
            }
            n2 += 3;
            if (c10 == '[') {
                printWriter.print(", [");
                n3 = n4;
                int n5 = 0;
                while (n5 < n3) {
                    char c11;
                    char c12;
                    if ((c12 = this.instruction[n2++]) == (c11 = this.instruction[n2++])) {
                        printWriter.print(this.charToString(c12));
                    } else {
                        printWriter.print(String.valueOf(this.charToString(c12)) + "-" + this.charToString(c11));
                    }
                    ++n5;
                }
                printWriter.print("]");
            }
            if (c10 == 'A') {
                printWriter.print(", \"");
                n3 = n4;
                while (n3-- != 0) {
                    printWriter.print(this.charToString(this.instruction[n2++]));
                }
                printWriter.print("\"");
            }
            printWriter.println("");
        }
    }

    String nodeToString(int n2) {
        char c10 = this.instruction[n2];
        char c11 = this.instruction[n2 + 1];
        return String.valueOf(this.opcodeToString(c10)) + ", opdata = " + c11;
    }

    String opcodeToString(char c10) {
        String string = (String)hashOpcode.get(new Integer(c10));
        if (string == null) {
            string = "OP_????";
        }
        return string;
    }
}

