/*
 * Decompiled with CFR 0.152.
 */
package org.apache.service.support;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.service.Service;
import org.apache.service.ServiceController;

public class SimpleService
implements Service,
Runnable {
    private ServerSocket server = null;
    private Thread thread = null;
    private ServiceController controller = null;
    private boolean stopping = false;
    private String directory = null;
    private Vector handlers = null;

    public SimpleService() {
        System.err.println("SimpleService: instance " + this.hashCode() + " created");
        this.handlers = new Vector();
    }

    protected void addHandler(Handler handler) {
        Handler handler2 = handler;
        synchronized (handler2) {
            this.handlers.add(handler);
        }
    }

    protected void finalize() {
        System.err.println("SimpleService: instance " + this.hashCode() + " garbage collected");
    }

    public void load(ServiceController controller, String[] a) throws IOException {
        int port = 1200;
        if (a.length > 0) {
            port = Integer.parseInt(a[0]);
        }
        this.directory = a.length > 1 ? a[1] : "/tmp";
        System.err.println("SimpleService: loading on port " + port);
        this.controller = controller;
        this.server = new ServerSocket(port);
        this.thread = new Thread(this);
    }

    protected void removeHandler(Handler handler) {
        Handler handler2 = handler;
        synchronized (handler2) {
            this.handlers.remove(handler);
        }
    }

    public void run() {
        Handler handler;
        block4: {
            int number = 0;
            System.err.println("SimpleService: started acceptor loop");
            try {
                while (!this.stopping) {
                    Socket socket = this.server.accept();
                    handler = new Handler(socket, this, this.controller);
                    handler.setConnectionNumber(number++);
                    handler.setDirectoryName(this.directory);
                    new Thread(handler).start();
                }
            }
            catch (IOException e10) {
                if (this.stopping) break block4;
                e10.printStackTrace(System.err);
            }
        }
        Enumeration openhandlers = this.handlers.elements();
        while (openhandlers.hasMoreElements()) {
            handler = (Handler)openhandlers.nextElement();
            System.err.println("SimpleService: dropping connection " + handler.getConnectionNumber());
            handler.close();
        }
        System.err.println("SimpleService: exiting acceptor loop");
    }

    public void start() {
        System.err.println("SimpleService: starting");
        this.thread.start();
    }

    public void stop() throws IOException, InterruptedException {
        System.err.println("SimpleService: stopping");
        this.stopping = true;
        this.server.close();
        this.thread.join(5000L);
        System.err.println("SimpleService: stopped");
    }

    public static class Handler
    implements Runnable {
        private ServiceController controller = null;
        private SimpleService parent = null;
        private String directory = null;
        private Socket socket = null;
        private int number = 0;

        public Handler(Socket s2, SimpleService p2, ServiceController c10) {
            this.socket = s2;
            this.parent = p2;
            this.controller = c10;
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException e10) {
                e10.printStackTrace(System.err);
            }
        }

        public int getConnectionNumber() {
            return this.number;
        }

        public String getDirectoryName() {
            return this.directory;
        }

        public void handle(InputStream in, OutputStream os) {
            PrintStream out = new PrintStream(os);
            try {
                block16: while (true) {
                    if (in.available() == 0) {
                        out.println();
                        out.println("Please select one of the following:");
                        out.println("    1) Shutdown");
                        out.println("    2) Reload");
                        out.println("    3) Create a file");
                        out.println("    4) Disconnect");
                        out.print("Your choiche: ");
                    }
                    int x2 = in.read();
                    switch (x2) {
                        case 10: 
                        case 13: {
                            continue block16;
                        }
                        case -1: {
                            return;
                        }
                        case 49: {
                            out.println("Attempting a shutdown...");
                            try {
                                this.controller.shutdown();
                            }
                            catch (IllegalStateException e10) {
                                out.println();
                                out.println("Can't shutdown now");
                                e10.printStackTrace(out);
                            }
                            continue block16;
                        }
                        case 50: {
                            out.println("Attempting a reload...");
                            try {
                                this.controller.reload();
                            }
                            catch (IllegalStateException e11) {
                                out.println();
                                out.println("Can't reload now");
                                e11.printStackTrace(out);
                            }
                            continue block16;
                        }
                        case 51: {
                            String name = String.valueOf(this.getDirectoryName()) + "/SimpleService." + this.getConnectionNumber() + ".tmp";
                            try {
                                this.log(name);
                                out.println("File '" + name + "' created");
                            }
                            catch (IOException e12) {
                                e12.printStackTrace(out);
                            }
                            continue block16;
                        }
                        case 52: {
                            out.println("Disconnecting...");
                            return;
                        }
                    }
                    out.println("Unknown option '" + (char)x2 + "'");
                }
            }
            catch (IOException iOException) {
                System.err.println("SimpleService: IOException in connection " + this.getConnectionNumber());
                return;
            }
        }

        public void log(String name) throws IOException {
            FileOutputStream file = new FileOutputStream(name, true);
            PrintStream out = new PrintStream(file);
            SimpleDateFormat fmt = new SimpleDateFormat();
            out.println(fmt.format(new Date()));
            out.close();
            ((OutputStream)file).close();
        }

        public void run() {
            this.parent.addHandler(this);
            System.err.println("SimpleService: connection " + this.number + " opened from " + this.socket.getInetAddress());
            try {
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                this.handle(in, out);
                this.socket.close();
            }
            catch (IOException e10) {
                e10.printStackTrace(System.err);
            }
            System.err.println("SimpleService: connection " + this.number + " closed");
            this.parent.removeHandler(this);
        }

        public void setConnectionNumber(int number) {
            this.number = number;
        }

        public void setDirectoryName(String directory) {
            this.directory = directory;
        }
    }
}

