/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.StringVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.XPathProcessorException;
import org.apache.xpath.objects.XObject;

public class ExtensionHandlerGeneral
extends ExtensionHandler {
    private String m_scriptSrc;
    private String m_scriptSrcURL;
    private Hashtable m_functions = new Hashtable();
    private Hashtable m_elements = new Hashtable();
    private Object m_mgr;
    private Object m_engine;
    private static final String BSF_MANAGER = "com.ibm.bsf.BSFManager";
    private static Class managerClass;
    private static Method mgrLoadScriptingEngine;
    private static final String BSF_ENGINE = "com.ibm.bsf.BSFEngine";
    private static Method engineExec;
    private static Method engineCall;
    private static final Integer NEG1INT;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        NEG1INT = new Integer(-1);
        try {
            managerClass = ExtensionHandler.getClassForName(BSF_MANAGER);
            mgrLoadScriptingEngine = managerClass.getMethod("loadScriptingEngine", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")));
            Class engineClass = ExtensionHandler.getClassForName(BSF_ENGINE);
            engineExec = engineClass.getMethod("exec", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")), Integer.TYPE, Integer.TYPE, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ExtensionHandlerGeneral.class$("java.lang.Object")));
            engineCall = engineClass.getMethod("call", class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ExtensionHandlerGeneral.class$("java.lang.Object")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExtensionHandlerGeneral.class$("java.lang.String")), Class.forName("[Ljava.lang.Object;"));
        }
        catch (Exception e10) {
            managerClass = null;
            mgrLoadScriptingEngine = null;
            engineExec = null;
            engineCall = null;
            e10.printStackTrace();
        }
    }

    public ExtensionHandlerGeneral(String namespaceUri, StringVector elemNames, StringVector funcNames, String scriptLang, String scriptSrcURL, String scriptSrc, String systemId) throws TransformerException {
        super(namespaceUri, scriptLang);
        String tok;
        int i2;
        int n2;
        Object junk;
        if (elemNames != null) {
            junk = new Object();
            n2 = elemNames.size();
            i2 = 0;
            while (i2 < n2) {
                tok = elemNames.elementAt(i2);
                this.m_elements.put(tok, junk);
                ++i2;
            }
        }
        if (funcNames != null) {
            junk = new Object();
            n2 = funcNames.size();
            i2 = 0;
            while (i2 < n2) {
                tok = funcNames.elementAt(i2);
                this.m_functions.put(tok, junk);
                ++i2;
            }
        }
        this.m_scriptSrcURL = scriptSrcURL;
        this.m_scriptSrc = scriptSrc;
        if (this.m_scriptSrcURL != null) {
            URL url = null;
            try {
                url = new URL(this.m_scriptSrcURL);
            }
            catch (MalformedURLException mue) {
                int indexOfColon = this.m_scriptSrcURL.indexOf(58);
                int indexOfSlash = this.m_scriptSrcURL.indexOf(47);
                if (indexOfColon != -1 && indexOfSlash != -1 && indexOfColon < indexOfSlash) {
                    url = null;
                    throw new TransformerException(XSLMessages.createMessage(195, new Object[]{this.m_scriptSrcURL}), mue);
                }
                try {
                    url = new URL(new URL(SystemIDResolver.getAbsoluteURI(systemId)), this.m_scriptSrcURL);
                }
                catch (MalformedURLException mue2) {
                    throw new TransformerException(XSLMessages.createMessage(195, new Object[]{this.m_scriptSrcURL}), mue2);
                }
            }
            if (url != null) {
                try {
                    URLConnection uc = url.openConnection();
                    InputStream is = uc.getInputStream();
                    byte[] bArray = new byte[uc.getContentLength()];
                    is.read(bArray);
                    this.m_scriptSrc = new String(bArray);
                }
                catch (IOException ioe) {
                    throw new TransformerException(XSLMessages.createMessage(195, new Object[]{this.m_scriptSrcURL}), ioe);
                }
            }
        }
        if (managerClass == null) {
            throw new TransformerException(XSLMessages.createMessage(116, null));
        }
        try {
            this.m_mgr = managerClass.newInstance();
            this.m_engine = mgrLoadScriptingEngine.invoke(this.m_mgr, scriptLang);
            engineExec.invoke(this.m_engine, "XalanScript", NEG1INT, NEG1INT, this.m_scriptSrc);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new TransformerException(XSLMessages.createMessage(117, null), e10);
        }
    }

    public Object callFunction(String funcName, Vector args, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        try {
            Object[] argArray = new Object[args.size()];
            int i2 = 0;
            while (i2 < argArray.length) {
                Object o2 = args.elementAt(i2);
                argArray[i2] = o2 instanceof XObject ? ((XObject)o2).object() : o2;
                o2 = argArray[i2];
                if (o2 != null && o2 instanceof DTMIterator) {
                    argArray[i2] = new DTMNodeList((DTMIterator)o2);
                }
                ++i2;
            }
            return engineCall.invoke(this.m_engine, null, funcName, argArray);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            String msg = e10.getMessage();
            if (msg != null) {
                if (msg.startsWith("Stopping after fatal error:")) {
                    msg = msg.substring("Stopping after fatal error:".length());
                }
                throw new TransformerException(e10);
            }
            throw new TransformerException(XSLMessages.createMessage(118, new Object[]{funcName, e10}));
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public boolean isElementAvailable(String element) {
        return this.m_elements.get(element) != null;
    }

    public boolean isFunctionAvailable(String function) {
        return this.m_functions.get(function) != null;
    }

    public void processElement(String localPart, ElemTemplateElement element, TransformerImpl transformer, Stylesheet stylesheetTree, Object methodKey) throws TransformerException, IOException {
        Object result = null;
        XSLProcessorContext xpc = new XSLProcessorContext(transformer, stylesheetTree);
        try {
            Vector<Object> argv = new Vector<Object>(2);
            argv.addElement(xpc);
            argv.addElement(element);
            result = this.callFunction(localPart, argv, methodKey, transformer.getXPathContext().getExpressionContext());
        }
        catch (XPathProcessorException e10) {
            throw new TransformerException(e10.getMessage(), e10);
        }
        if (result != null) {
            xpc.outputToResultTree(stylesheetTree, result);
        }
    }
}

