/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Redirect {
    protected Hashtable m_formatterListeners = new Hashtable();
    protected Hashtable m_outputStreams = new Hashtable();

    public void close(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object formatterObj = this.m_formatterListeners.get(fileName);
        if (formatterObj != null) {
            ContentHandler fl2 = (ContentHandler)formatterObj;
            try {
                fl2.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            OutputStream ostream = (OutputStream)this.m_outputStreams.get(fileName);
            if (ostream != null) {
                ostream.close();
                this.m_outputStreams.remove(fileName);
            }
            this.m_formatterListeners.remove(fileName);
        }
    }

    private String getFilename(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName;
        String fileNameExpr = elem.getAttribute("select", context.getContextNode(), context.getTransformer());
        if (fileNameExpr != null) {
            XPathContext xctxt = context.getTransformer().getXPathContext();
            XPath myxpath = new XPath(fileNameExpr, elem, xctxt.getNamespaceContext(), 0);
            XObject xobj = myxpath.execute(xctxt, context.getContextNode(), (PrefixResolver)elem);
            fileName = xobj.str();
            if (fileName == null || fileName.length() == 0) {
                fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
            }
        } else {
            fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
        }
        if (fileName == null) {
            context.getTransformer().getMsgMgr().error((SourceLocator)elem, elem, context.getContextNode(), 85);
        }
        return fileName;
    }

    private ContentHandler makeFormatterListener(XSLProcessorContext context, ElemExtensionCall elem, String fileName, boolean shouldPutInTable, boolean mkdirs) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String dirStr;
        Result outputTarget;
        String base;
        File file = new File(fileName);
        TransformerImpl transformer = context.getTransformer();
        if (!file.isAbsolute() && (base = (outputTarget = transformer.getOutputTarget()) != null && (base = outputTarget.getSystemId()) != null ? this.urlToFileName(base) : this.urlToFileName(transformer.getBaseURLOfSource())) != null) {
            File baseFile = new File(base);
            file = new File(baseFile.getParent(), fileName);
        }
        if (mkdirs && (dirStr = file.getParent()) != null && dirStr.length() > 0) {
            File dir = new File(dirStr);
            dir.mkdirs();
        }
        OutputProperties format = transformer.getOutputFormat();
        FileOutputStream ostream = new FileOutputStream(file);
        try {
            ContentHandler flistener = transformer.createResultContentHandler(new StreamResult(ostream), format);
            try {
                flistener.startDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            if (shouldPutInTable) {
                this.m_outputStreams.put(fileName, ostream);
                this.m_formatterListeners.put(fileName, flistener);
            }
            return flistener;
        }
        catch (TransformerException te) {
            throw new TransformerException(te);
        }
    }

    public void open(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object flistener = this.m_formatterListeners.get(fileName);
        if (flistener == null) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            this.makeFormatterListener(context, elem, fileName, true, mkdirs);
        }
    }

    private String urlToFileName(String base) {
        if (base != null) {
            if (base.startsWith("file:////")) {
                base = base.substring(7);
            } else if (base.startsWith("file:///")) {
                base = base.substring(6);
            } else if (base.startsWith("file://")) {
                base = base.substring(5);
            } else if (base.startsWith("file:/")) {
                base = base.substring(5);
            } else if (base.startsWith("file:")) {
                base = base.substring(4);
            }
        }
        return base;
    }

    public void write(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        OutputStream ostream;
        ContentHandler formatter;
        String fileName = this.getFilename(context, elem);
        Object flObject = this.m_formatterListeners.get(fileName);
        boolean inTable = false;
        if (flObject == null) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            formatter = this.makeFormatterListener(context, elem, fileName, true, mkdirs);
        } else {
            inTable = true;
            formatter = (ContentHandler)flObject;
        }
        TransformerImpl transf = context.getTransformer();
        transf.executeChildTemplates(elem, context.getContextNode(), context.getMode(), formatter);
        if (!inTable && (ostream = (OutputStream)this.m_outputStreams.get(fileName)) != null) {
            try {
                formatter.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            ostream.close();
            this.m_outputStreams.remove(fileName);
            this.m_formatterListeners.remove(fileName);
        }
    }
}

