/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.WrappedRuntimeException;

public abstract class SerializerFactory {
    private static Hashtable _formats = new Hashtable();

    public static Serializer getSerializer(Properties format) {
        Serializer ser = null;
        try {
            String method = format.getProperty("method");
            if (method == null) {
                throw new IllegalArgumentException("The output format has a null method name");
            }
            Class<?> cls = null;
            if (cls == null) {
                String className = format.getProperty(OutputProperties.S_KEY_CONTENT_HANDLER);
                if (className == null) {
                    throw new IllegalArgumentException("The output format must have a '" + OutputProperties.S_KEY_CONTENT_HANDLER + "' property!");
                }
                cls = Class.forName(className);
            }
            ser = (Serializer)cls.newInstance();
            ser.setOutputFormat(format);
        }
        catch (Exception e10) {
            throw new WrappedRuntimeException(e10);
        }
        return ser;
    }
}

