/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.WriterToASCI;
import org.apache.xalan.serialize.WriterToUTF8;
import org.apache.xalan.serialize.WriterToUTF8Buffered;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SerializerToXML
implements ContentHandler,
LexicalHandler,
DeclHandler,
Serializer,
DOMSerializer {
    protected Writer m_writer = null;
    boolean m_shouldFlush = true;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    protected BoolStack m_cdataSectionStates = new BoolStack();
    protected Vector m_cdataSectionNames = null;
    protected boolean m_inCData = false;
    protected final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    protected final int m_lineSepLen = this.m_lineSep.length;
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int m_indentAmount = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone = false;
    boolean m_standaloneWasSpecified = false;
    String m_mediatype;
    protected boolean m_inEntityRef = false;
    private boolean m_inDoctype = false;
    protected static CharInfo m_xmlcharInfo = new CharInfo(CharInfo.XML_ENTITIES_RESOURCE);
    protected CharInfo m_charInfo;
    private static Hashtable m_charInfos = null;
    boolean m_isUTF8;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    public boolean m_spaceBeforeClose = false;
    protected Properties m_format;
    private static final boolean DEBUG = false;
    protected int m_pos = 0;
    private String m_elemName = "";

    public SerializerToXML() {
        this.m_charInfo = m_xmlcharInfo;
    }

    public void CopyFrom(SerializerToXML xmlListener) {
        this.m_writer = xmlListener.m_writer;
        this.m_encoding = xmlListener.m_encoding;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_elemStack = xmlListener.m_elemStack;
        this.m_ispreserve = xmlListener.m_ispreserve;
        this.m_preserves = xmlListener.m_preserves;
        this.m_isprevtext = xmlListener.m_isprevtext;
        this.m_doIndent = xmlListener.m_doIndent;
        this.m_currentIndent = xmlListener.m_currentIndent;
        this.m_indentAmount = xmlListener.m_indentAmount;
        this.level = xmlListener.level;
        this.m_startNewLine = xmlListener.m_startNewLine;
        this.m_needToOutputDocTypeDecl = xmlListener.m_needToOutputDocTypeDecl;
        this.m_doctypeSystem = xmlListener.m_doctypeSystem;
        this.m_doctypePublic = xmlListener.m_doctypePublic;
        this.m_standalone = xmlListener.m_standalone;
        this.m_mediatype = xmlListener.m_mediatype;
        this.m_maxCharacter = xmlListener.m_maxCharacter;
        this.m_spaceBeforeClose = xmlListener.m_spaceBeforeClose;
        this.m_inCData = xmlListener.m_inCData;
        this.m_pos = 0;
    }

    protected final void accum(char b10) throws SAXException {
        try {
            this.m_writer.write(b10);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected final void accum(String s2) throws SAXException {
        try {
            this.m_writer.write(s2);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected final void accum(char[] chars, int start, int length) throws SAXException {
        try {
            this.m_writer.write(chars, start, length);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(char ch2, int i2, char[] chars, int len, boolean escLF) throws SAXException {
        try {
            if (!escLF && CharInfo.S_LINEFEED == ch2) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                return i2 + 1;
            } else {
                if (!this.m_charInfo.isSpecial(ch2)) return i2;
                String entityRef = this.m_charInfo.getEntityNameForChar(ch2);
                if (entityRef == null) return i2;
                Writer writer = this.m_writer;
                writer.write(38);
                writer.write(entityRef);
                writer.write(59);
            }
            return i2 + 1;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected int accumDefaultEscape(char ch2, int i2, char[] chars, int len, boolean escLF) throws SAXException {
        int pos = this.accumDefaultEntity(ch2, i2, chars, len, escLF);
        if (i2 == pos) {
            ++pos;
            try {
                if (ch2 >= '\ud800' && ch2 < '\udc00') {
                    int next;
                    if (i2 + 1 >= len) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(ch2)}));
                    }
                    if ((next = chars[++i2]) < 56320 || next >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(ch2)) + " " + Integer.toHexString(next)}));
                    }
                    next = (ch2 - 55296 << 10) + next - 56320 + 65536;
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(next));
                    this.m_writer.write(";");
                } else if (ch2 > this.m_maxCharacter || this.m_charInfo.isSpecial(ch2)) {
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(ch2));
                    this.m_writer.write(";");
                } else {
                    this.m_writer.write(ch2);
                }
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
        return pos;
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            if (!eName.equals(this.m_elemName)) {
                writer.write("<!ATTLIST ");
                writer.write(eName);
                writer.write(" ");
                this.m_elemName = eName;
            } else {
                this.m_pos -= 3;
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            writer.write(aName);
            writer.write(" ");
            writer.write(type);
            writer.write(" ");
            writer.write(valueDefault);
            writer.write(">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void cdata(char[] ch2, int start, int length) throws SAXException {
        try {
            boolean writeCDataBrackets;
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            boolean bl2 = writeCDataBrackets = length >= 1 && ch2[start] <= this.m_maxCharacter;
            if (writeCDataBrackets) {
                this.m_writer.write("<![CDATA[");
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(ch2, start, length);
            } else {
                this.writeNormalizedChars(ch2, start, length, true);
            }
            if (writeCDataBrackets) {
                this.m_writer.write("]]>");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(XSLMessages.createXPATHMessage(66, null), ioe);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.m_inCData || this.m_cdataSectionStates.peekOrFalse()) {
            this.cdata(chars, start, length);
            return;
        }
        try {
            if (this.m_disableOutputEscapingStates.peekOrFalse()) {
                this.charactersRaw(chars, start, length);
                return;
            }
            Writer writer = this.m_writer;
            if (!this.m_elemStack.peekOrTrue()) {
                writer.write(62);
                this.m_isprevtext = false;
                this.m_elemStack.setTop(true);
                this.m_preserves.push(this.m_ispreserve);
            }
            int startClean = start;
            int lengthClean = 0;
            int end = start + length;
            boolean checkWhite = true;
            int maxCharacter = this.m_maxCharacter;
            BitSet specialsMap = this.m_charInfo.m_specialsMap;
            int i2 = start;
            while (i2 < end) {
                char ch2 = chars[i2];
                if (checkWhite && (ch2 > ' ' || ch2 != ' ' && ch2 != '\t' && ch2 != '\r' && ch2 != '\n')) {
                    this.m_ispreserve = true;
                    checkWhite = false;
                }
                if (ch2 < maxCharacter && !specialsMap.get(ch2) || ch2 == '\"') {
                    ++lengthClean;
                } else {
                    if (lengthClean > 0) {
                        writer.write(chars, startClean, lengthClean);
                        lengthClean = 0;
                    }
                    if (CharInfo.S_LINEFEED == ch2) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        startClean = i2 + 1;
                    } else {
                        startClean = this.accumDefaultEscape(ch2, i2, chars, end, false);
                        i2 = startClean - 1;
                    }
                }
                ++i2;
            }
            if (lengthClean > 0) {
                writer.write(chars, startClean, lengthClean);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] ch2, int start, int length) throws SAXException {
        try {
            if (this.m_inEntityRef) {
                return;
            }
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            this.m_writer.write(ch2, start, length);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("<!--");
            writer.write(ch2, start, length);
            writer.write("-->");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.m_startNewLine = true;
    }

    public void elementDecl(String name, String model) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            writer.write("<!ELEMENT ");
            writer.write(name);
            writer.write(32);
            writer.write(model);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
        try {
            if (!this.m_inDoctype) {
                this.m_writer.write("]>");
            } else {
                this.m_writer.write(62);
            }
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flushWriter();
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean hasChildNodes = this.childNodesWereAdded();
        try {
            Writer writer = this.m_writer;
            if (hasChildNodes) {
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(47);
                writer.write(name);
                writer.write(62);
            } else if (this.m_spaceBeforeClose) {
                writer.write(" />");
            } else {
                writer.write("/>");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        if (hasChildNodes) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    public void endEntity(String name) throws SAXException {
        this.m_inEntityRef = false;
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void entityReference(String name) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("&");
            writer.write(name);
            writer.write(";");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public final void flushWriter() throws SAXException {
        if (this.m_writer != null) {
            try {
                if (this.m_writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)this.m_writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)this.m_writer).flushBuffer();
                    }
                }
                if (this.m_writer instanceof WriterToUTF8) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else if (this.m_writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else {
                    this.m_writer.flush();
                }
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToUTF8) {
            return ((WriterToUTF8)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    int getURF16SurrogateValue(char c10, char[] ch2, int i2, int end) throws SAXException {
        int next;
        if (i2 + 1 >= end) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c10)}));
        }
        if ((next = ch2[++i2]) < 56320 || next >= 57344) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{String.valueOf(Integer.toHexString(c10)) + " " + Integer.toHexString(next)}));
        }
        next = (c10 - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        this.characters(ch2, start, length);
    }

    public void indent(int n2) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n2);
        }
    }

    public synchronized void init(OutputStream output, Properties format) throws UnsupportedEncodingException {
        if (format == null) {
            OutputProperties op = new OutputProperties("xml");
            format = op.getProperties();
        }
        this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        if (this.m_encoding.equalsIgnoreCase("UTF-8")) {
            if (output instanceof BufferedOutputStream) {
                this.init(new WriterToUTF8(output), format, true);
            } else if (output instanceof FileOutputStream) {
                this.init(new WriterToUTF8Buffered(output), format, true);
            } else {
                this.init(new WriterToUTF8(output), format, true);
            }
        } else if (this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.init(new WriterToASCI(output), format, true);
        } else {
            Writer osw;
            try {
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: encoding \"" + this.m_encoding + "\" not supported" + ", using " + "UTF-8");
                this.m_encoding = "UTF-8";
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
            this.init(osw, format, true);
        }
    }

    public synchronized void init(Writer writer, Properties format) {
        this.init(writer, format, false);
    }

    private synchronized void init(Writer writer, Properties format, boolean shouldFlush) {
        this.m_shouldFlush = shouldFlush;
        this.m_writer = writer;
        this.m_format = format;
        this.m_cdataSectionNames = OutputProperties.getQNameProperties("cdata-section-elements", format);
        this.m_indentAmount = OutputProperties.getIntProperty(OutputProperties.S_KEY_INDENT_AMOUNT, format);
        this.m_doIndent = OutputProperties.getBooleanProperty("indent", format);
        this.m_shouldNotWriteXMLHeader = OutputProperties.getBooleanProperty("omit-xml-declaration", format);
        this.m_doctypeSystem = format.getProperty("doctype-system");
        this.m_doctypePublic = format.getProperty("doctype-public");
        this.m_standaloneWasSpecified = ((Hashtable)format).get("standalone") != null;
        this.m_standalone = OutputProperties.getBooleanProperty("standalone", format);
        this.m_mediatype = format.getProperty("media-type");
        if (this.m_doctypePublic != null && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (this.m_encoding == null) {
            this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        }
        this.m_isUTF8 = this.m_encoding.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
        String entitiesFileName = (String)((Hashtable)format).get(OutputProperties.S_KEY_ENTITIES);
        if (entitiesFileName != null) {
            try {
                this.m_charInfo = null;
                if (m_charInfos == null) {
                    CharInfo charInfo = m_xmlcharInfo;
                    synchronized (charInfo) {
                        if (m_charInfos == null) {
                            m_charInfos = new Hashtable();
                        }
                    }
                } else {
                    this.m_charInfo = (CharInfo)m_charInfos.get(entitiesFileName);
                }
                if (this.m_charInfo == null) {
                    String absoluteEntitiesFileName = entitiesFileName.indexOf(58) < 0 ? SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName) : SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                    this.m_charInfo = new CharInfo(absoluteEntitiesFileName);
                    m_charInfos.put(entitiesFileName, this.m_charInfo);
                }
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.outputEntityDecl(name, value);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected boolean isCDataSection() {
        return this.m_inCData || this.m_cdataSectionStates.peekOrFalse();
    }

    protected boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    static final boolean isUTF16Surrogate(char c10) {
        return (c10 & 0xFC00) == 55296;
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    void outputDocTypeDecl(String name, boolean closeDecl) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(name);
            if (this.m_doctypePublic != null) {
                writer.write(" PUBLIC \"");
                writer.write(this.m_doctypePublic);
                writer.write(34);
            }
            if (this.m_doctypeSystem != null) {
                if (this.m_doctypePublic == null) {
                    writer.write(" SYSTEM \"");
                } else {
                    writer.write(" \"");
                }
                writer.write(this.m_doctypeSystem);
                if (closeDecl) {
                    writer.write("\">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else {
                    writer.write(34);
                }
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    void outputEntityDecl(String name, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!ENTITY ");
            writer.write(name);
            writer.write(" \"");
            writer.write(value);
            writer.write("\">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected final void outputLineSep() throws SAXException {
        try {
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void printSpace(int n2) throws SAXException {
        try {
            int i2 = 0;
            while (i2 < n2) {
                this.m_writer.write(32);
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected void processAttribute(String name, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(32);
            writer.write(name);
            writer.write("=\"");
            this.writeAttrString(value, this.m_encoding);
            writer.write(34);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int indexOfQLT;
                Writer writer = this.m_writer;
                this.writeParentTagEnd();
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(63);
                writer.write(target);
                if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                    writer.write(32);
                }
                if ((indexOfQLT = data.indexOf("?>")) >= 0) {
                    if (indexOfQLT > 0) {
                        writer.write(data.substring(0, indexOfQLT));
                    }
                    writer.write("? >");
                    if (indexOfQLT + 2 < data.length()) {
                        writer.write(data.substring(indexOfQLT + 2));
                    }
                } else {
                    writer.write(data);
                }
                writer.write(63);
                writer.write(62);
                if (this.m_elemStack.isEmpty()) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    protected void pushState(String namespaceURI, String localName, Vector qnames, BoolStack state) {
        boolean b10;
        if (qnames != null) {
            b10 = false;
            if (namespaceURI != null && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            int nElems = qnames.size();
            int i2 = 0;
            while (i2 < nElems) {
                QName q2 = (QName)qnames.elementAt(i2);
                if (q2.getLocalName().equals(localName) && SerializerToXML.subPartMatch(namespaceURI, q2.getNamespaceURI())) {
                    b10 = true;
                    break;
                }
                ++i2;
            }
        } else {
            b10 = state.peekOrFalse();
        }
        state.push(b10);
    }

    public boolean reset() {
        return false;
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker walker = new TreeWalker(this, new DOM2Helper());
            walker.traverse(node);
        }
        catch (SAXException se) {
            throw new WrappedRuntimeException(se);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setOutputFormat(Properties format) {
        boolean shouldFlush = this.m_shouldFlush;
        this.init(this.m_writer, format, false);
        this.m_shouldFlush = shouldFlush;
    }

    public void setOutputStream(OutputStream output) {
        try {
            this.init(output, this.m_format);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_doctypeSystem = systemId;
        this.m_doctypePublic = publicId;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(name, false);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.m_inDoctype = true;
    }

    public void startDocument() throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String version;
            String encoding = Encodings.getMimeEncoding(this.m_encoding);
            String string = version = this.m_version == null ? "1.0" : this.m_version;
            String standalone = this.m_standaloneWasSpecified ? " standalone=\"" + (this.m_standalone ? "yes" : "no") + "\"" : "";
            try {
                Writer writer = this.m_writer;
                writer.write("<?xml version=\"");
                writer.write(version);
                writer.write("\" encoding=\"");
                writer.write(encoding);
                writer.write(34);
                writer.write(standalone);
                writer.write("?>");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToOutputDocTypeDecl && this.m_doctypeSystem != null) {
            this.outputDocTypeDecl(name, true);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.pushState(namespaceURI, localName, this.m_cdataSectionNames, this.m_cdataSectionStates);
        this.m_ispreserve = false;
        if (this.shouldIndent() && this.m_startNewLine) {
            this.indent(this.m_currentIndent);
        }
        this.m_startNewLine = true;
        try {
            this.m_writer.write(60);
            this.m_writer.write(name);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        int nAttrs = atts.getLength();
        int i2 = 0;
        while (i2 < nAttrs) {
            this.processAttribute(atts.getQName(i2), atts.getValue(i2));
            ++i2;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
    }

    public void startEntity(String name) throws SAXException {
        this.m_inEntityRef = true;
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    protected static final boolean subPartMatch(String p2, String t2) {
        return p2 == t2 || p2 != null && p2.equals(t2);
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        try {
            char[] stringChars = string.toCharArray();
            int len = stringChars.length;
            Writer writer = this.m_writer;
            int i2 = 0;
            while (i2 < len) {
                char ch2 = stringChars[i2];
                if (ch2 < this.m_maxCharacter && !this.m_charInfo.isSpecial(ch2)) {
                    writer.write(ch2);
                } else {
                    if (CharInfo.S_CARRIAGERETURN == ch2 && i2 + 1 < len && CharInfo.S_LINEFEED == stringChars[i2 + 1]) {
                        ++i2;
                        ch2 = CharInfo.S_LINEFEED;
                    }
                    this.accumDefaultEscape(ch2, i2, stringChars, len, true);
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    void writeNormalizedChars(char[] ch2, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i2 = start;
        while (i2 < end) {
            String intStr;
            char c10 = ch2[i2];
            if (CharInfo.S_LINEFEED == c10) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (isCData && c10 > this.m_maxCharacter) {
                if (i2 != 0) {
                    this.m_writer.write("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c10)) {
                    i2 = this.writeUTF16Surrogate(c10, ch2, i2, end);
                } else {
                    this.m_writer.write("&#");
                    intStr = Integer.toString(c10);
                    this.m_writer.write(intStr);
                    this.m_writer.write(59);
                }
                if (i2 != 0 && i2 < end - 1) {
                    this.m_writer.write("<![CDATA[");
                }
            } else if (isCData && i2 < end - 2 && c10 == ']' && ch2[i2 + 1] == ']' && ch2[i2 + 2] == '>') {
                this.m_writer.write("]]]]><![CDATA[>");
                i2 += 2;
            } else if (c10 <= this.m_maxCharacter) {
                this.m_writer.write(c10);
            } else if (SerializerToXML.isUTF16Surrogate(c10)) {
                i2 = this.writeUTF16Surrogate(c10, ch2, i2, end);
            } else {
                this.m_writer.write("&#");
                intStr = Integer.toString(c10);
                this.m_writer.write(intStr);
                this.m_writer.write(59);
            }
            ++i2;
        }
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.peekOrTrue()) {
            try {
                this.m_writer.write(62);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
            this.m_isprevtext = false;
            this.m_elemStack.setTop(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }

    protected int writeUTF16Surrogate(char c10, char[] ch2, int i2, int end) throws IOException, SAXException {
        int surrogateValue = this.getURF16SurrogateValue(c10, ch2, i2, end);
        this.m_writer.write(38);
        this.m_writer.write(35);
        this.m_writer.write(Integer.toString(surrogateValue));
        this.m_writer.write(59);
        return ++i2;
    }
}

