/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xalan.res.XSLMessages;

public final class WriterToUTF8Buffered
extends Writer {
    private OutputStream m_os;
    private byte[] buf;
    private int count;

    public WriterToUTF8Buffered(OutputStream out) throws UnsupportedEncodingException {
        this(out, 8192);
    }

    public WriterToUTF8Buffered(OutputStream out, int size) {
        this.m_os = out;
        if (size <= 0) {
            throw new IllegalArgumentException(XSLMessages.createMessage(136, null));
        }
        this.buf = new byte[size];
        this.count = 0;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void write(int c10) throws IOException {
        if (c10 < 128) {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)c10;
        } else if (c10 < 2048) {
            if (this.count + 1 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(192 + (c10 >> 6));
            this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
        } else {
            if (this.count + 2 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(224 + (c10 >> 12));
            this.buf[this.count++] = (byte)(128 + (c10 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
        }
    }

    public void write(String s2) throws IOException {
        int length = s2.length();
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(s2);
            return;
        }
        if (lengthx3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int i2 = 0;
        while (i2 < length) {
            char c10 = s2.charAt(i2);
            if (c10 < '\u0080') {
                this.buf[this.count++] = (byte)c10;
            } else if (c10 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c10 >> 6));
                this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c10 >> 12));
                this.buf[this.count++] = (byte)(128 + (c10 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
            }
            ++i2;
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(chars, start, length);
            return;
        }
        if (lengthx3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int n2 = length + start;
        int i2 = start;
        while (i2 < n2) {
            char c10 = chars[i2];
            if (c10 < '\u0080') {
                this.buf[this.count++] = (byte)c10;
            } else if (c10 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c10 >> 6));
                this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c10 >> 12));
                this.buf[this.count++] = (byte)(128 + (c10 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c10 & 0x3F));
            }
            ++i2;
        }
    }

    private final void writeDirect(String s2) throws IOException {
        int n2 = s2.length();
        OutputStream os = this.m_os;
        int i2 = 0;
        while (i2 < n2) {
            char c10 = s2.charAt(i2);
            if (c10 < '\u0080') {
                os.write(c10);
            } else if (c10 < '\u0800') {
                os.write(192 + (c10 >> 6));
                os.write(128 + (c10 & 0x3F));
            } else {
                os.write(224 + (c10 >> 12));
                os.write(128 + (c10 >> 6 & 0x3F));
                os.write(128 + (c10 & 0x3F));
            }
            ++i2;
        }
    }

    private final void writeDirect(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n2 = length + start;
        int i2 = start;
        while (i2 < n2) {
            char c10 = chars[i2];
            if (c10 < '\u0080') {
                os.write(c10);
            } else if (c10 < '\u0800') {
                os.write(192 + (c10 >> 6));
                os.write(128 + (c10 & 0x3F));
            } else {
                os.write(224 + (c10 >> 12));
                os.write(128 + (c10 >> 6 & 0x3F));
                os.write(128 + (c10 & 0x3F));
            }
            ++i2;
        }
    }
}

