/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.res.XResourceBundle;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    private XPath m_countMatchPattern = null;
    private XPath m_fromMatchPattern = null;
    private int m_level = 1;
    private XPath m_valueExpr = null;
    private AVT m_format_avt = null;
    private AVT m_lang_avt = null;
    private AVT m_lettervalue_avt = null;
    private AVT m_groupingSeparator_avt = null;
    private AVT m_groupingSize_avt = null;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static char[] m_alphaCountTable = null;

    public ElemTemplateElement appendChild(ElemTemplateElement newChild) {
        this.error(4, new Object[]{newChild.getNodeName(), this.getNodeName()});
        return null;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        Vector vnames = cstate.getVariableNames();
        if (this.m_countMatchPattern != null) {
            this.m_countMatchPattern.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_format_avt != null) {
            this.m_format_avt.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_fromMatchPattern != null) {
            this.m_fromMatchPattern.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_groupingSeparator_avt != null) {
            this.m_groupingSeparator_avt.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_groupingSize_avt != null) {
            this.m_groupingSize_avt.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_lang_avt != null) {
            this.m_lang_avt.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_lettervalue_avt != null) {
            this.m_lettervalue_avt.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (this.m_valueExpr != null) {
            this.m_valueExpr.fixupVariables(vnames, cstate.getGlobalsSize());
        }
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        if (TransformerImpl.S_DEBUG) {
            transformer.getTraceManager().fireTraceEvent(this);
        }
        int sourceNode = transformer.getXPathContext().getCurrentNode();
        String countString = this.getCountString(transformer, sourceNode);
        try {
            transformer.getResultTreeHandler().characters(countString.toCharArray(), 0, countString.length());
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    int findAncestor(XPathContext xctxt, XPath fromMatchPattern, XPath countMatchPattern, int context, ElemNumber namespaceContext) throws TransformerException {
        DTM dtm = xctxt.getDTM(context);
        while (context != -1) {
            if (fromMatchPattern != null && fromMatchPattern.getMatchScore(xctxt, context) != Double.NEGATIVE_INFINITY || countMatchPattern != null && countMatchPattern.getMatchScore(xctxt, context) != Double.NEGATIVE_INFINITY) break;
            context = dtm.getParent(context);
        }
        return context;
    }

    private int findPrecedingOrAncestorOrSelf(XPathContext xctxt, XPath fromMatchPattern, XPath countMatchPattern, int context, ElemNumber namespaceContext) throws TransformerException {
        DTM dtm = xctxt.getDTM(context);
        while (context != -1) {
            if (fromMatchPattern != null && fromMatchPattern.getMatchScore(xctxt, context) != Double.NEGATIVE_INFINITY) {
                context = -1;
                break;
            }
            if (countMatchPattern != null && countMatchPattern.getMatchScore(xctxt, context) != Double.NEGATIVE_INFINITY) break;
            int prevSibling = dtm.getPreviousSibling(context);
            if (prevSibling == -1) {
                context = dtm.getParent(context);
                continue;
            }
            context = dtm.getLastChild(prevSibling);
            if (context != -1) continue;
            context = prevSibling;
        }
        return context;
    }

    String formatNumberList(TransformerImpl transformer, int[] list, int contextNode) throws TransformerException {
        String numStr;
        FastStringBuffer formattedNumber = StringBufferPool.get();
        try {
            String formatToken;
            String formatValue;
            int nNumbers = list.length;
            int numberWidth = 1;
            char numberType = '1';
            String lastSepString = null;
            String formatTokenString = null;
            String lastSep = ".";
            boolean isFirstToken = true;
            String string = formatValue = this.m_format_avt != null ? this.m_format_avt.evaluate(transformer.getXPathContext(), contextNode, this) : null;
            if (formatValue == null) {
                formatValue = "1";
            }
            NumberFormatStringTokenizer formatTokenizer = new NumberFormatStringTokenizer(formatValue);
            int i2 = 0;
            while (i2 < nNumbers) {
                if (formatTokenizer.hasMoreTokens()) {
                    formatToken = formatTokenizer.nextToken();
                    if (Character.isLetterOrDigit(formatToken.charAt(formatToken.length() - 1))) {
                        numberWidth = formatToken.length();
                        numberType = formatToken.charAt(numberWidth - 1);
                    } else if (formatTokenizer.isLetterOrDigitAhead()) {
                        formatTokenString = formatToken;
                        while (formatTokenizer.nextIsSep()) {
                            formatToken = formatTokenizer.nextToken();
                            formatTokenString = String.valueOf(formatTokenString) + formatToken;
                        }
                        if (!isFirstToken) {
                            lastSep = formatTokenString;
                        }
                        formatToken = formatTokenizer.nextToken();
                        numberWidth = formatToken.length();
                        numberType = formatToken.charAt(numberWidth - 1);
                    } else {
                        lastSepString = formatToken;
                        while (formatTokenizer.hasMoreTokens()) {
                            formatToken = formatTokenizer.nextToken();
                            lastSepString = String.valueOf(lastSepString) + formatToken;
                        }
                    }
                }
                if (formatTokenString != null && isFirstToken) {
                    formattedNumber.append(formatTokenString);
                } else if (lastSep != null && !isFirstToken) {
                    formattedNumber.append(lastSep);
                }
                this.getFormattedNumber(transformer, contextNode, numberType, numberWidth, list[i2], formattedNumber);
                isFirstToken = false;
                ++i2;
            }
            while (formatTokenizer.isLetterOrDigitAhead()) {
                formatTokenizer.nextToken();
            }
            if (lastSepString != null) {
                formattedNumber.append(lastSepString);
            }
            while (formatTokenizer.hasMoreTokens()) {
                formatToken = formatTokenizer.nextToken();
                formattedNumber.append(formatToken);
            }
            numStr = formattedNumber.toString();
        }
        finally {
            Object var7_17 = null;
            StringBufferPool.free(formattedNumber);
        }
        return numStr;
    }

    public XPath getCount() {
        return this.m_countMatchPattern;
    }

    XPath getCountMatchPattern(XPathContext support, int contextNode) throws TransformerException {
        XPath countMatchPattern = this.m_countMatchPattern;
        DTM dtm = support.getDTM(contextNode);
        if (countMatchPattern == null) {
            switch (dtm.getNodeType(contextNode)) {
                case 1: {
                    countMatchPattern = new XPath(dtm.getNodeName(contextNode), this, this, 1, support.getErrorListener());
                    break;
                }
                case 2: {
                    countMatchPattern = new XPath("@" + dtm.getNodeName(contextNode), this, this, 1, support.getErrorListener());
                    break;
                }
                case 3: 
                case 4: {
                    countMatchPattern = new XPath("text()", this, this, 1, support.getErrorListener());
                    break;
                }
                case 8: {
                    countMatchPattern = new XPath("comment()", this, this, 1, support.getErrorListener());
                    break;
                }
                case 9: {
                    countMatchPattern = new XPath("/", this, this, 1, support.getErrorListener());
                    break;
                }
                case 7: {
                    countMatchPattern = new XPath("pi(" + dtm.getNodeName(contextNode) + ")", this, this, 1, support.getErrorListener());
                    break;
                }
                default: {
                    countMatchPattern = null;
                }
            }
        }
        return countMatchPattern;
    }

    String getCountString(TransformerImpl transformer, int sourceNode) throws TransformerException {
        int[] list = null;
        XPathContext xctxt = transformer.getXPathContext();
        CountersTable ctable = transformer.getCountersTable();
        if (this.m_valueExpr != null) {
            XObject countObj = this.m_valueExpr.execute(xctxt, sourceNode, (PrefixResolver)this);
            int count = (int)Math.floor(countObj.num() + 0.5);
            list = new int[]{count};
        } else if (this.m_level == 3) {
            list = new int[]{ctable.countNode(xctxt, this, sourceNode)};
        } else {
            NodeVector ancestors = this.getMatchingAncestors(xctxt, sourceNode, this.m_level == 1);
            int lastIndex = ancestors.size() - 1;
            if (lastIndex >= 0) {
                list = new int[lastIndex + 1];
                int i2 = lastIndex;
                while (i2 >= 0) {
                    int target = ancestors.elementAt(i2);
                    list[lastIndex - i2] = ctable.countNode(xctxt, this, target);
                    --i2;
                }
            }
        }
        return list != null ? this.formatNumberList(transformer, list, sourceNode) : "";
    }

    public AVT getFormat() {
        return this.m_format_avt;
    }

    private void getFormattedNumber(TransformerImpl transformer, int contextNode, char numberType, int numberWidth, int listElement, FastStringBuffer formattedNumber) throws TransformerException {
        DecimalFormat formatter = this.getNumberFormatter(transformer, contextNode);
        String padString = formatter.format(0L);
        String letterVal = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(transformer.getXPathContext(), contextNode, this) : null;
        switch (numberType) {
            case 'A': {
                if (m_alphaCountTable == null) {
                    XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformer, contextNode));
                    char[] alphabet = (char[])thisBundle.getObject("alphabet");
                    m_alphaCountTable = alphabet;
                }
                this.int2alphaCount(listElement, m_alphaCountTable, formattedNumber);
                break;
            }
            case 'a': {
                if (m_alphaCountTable == null) {
                    XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformer, contextNode));
                    char[] alphabet = (char[])thisBundle.getObject("alphabet");
                    m_alphaCountTable = alphabet;
                }
                FastStringBuffer stringBuf = StringBufferPool.get();
                try {
                    this.int2alphaCount(listElement, m_alphaCountTable, stringBuf);
                    formattedNumber.append(stringBuf.toString().toLowerCase(this.getLocale(transformer, contextNode)));
                    break;
                }
                finally {
                    Object var12_27 = null;
                    StringBufferPool.free(stringBuf);
                }
            }
            case 'I': {
                formattedNumber.append(this.long2roman(listElement, true));
                break;
            }
            case 'i': {
                formattedNumber.append(this.long2roman(listElement, true).toLowerCase(this.getLocale(transformer, contextNode)));
                break;
            }
            case '\u3042': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HA"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                formattedNumber.append(this.int2singlealphaCount(listElement, (char[])thisBundle.getObject("alphabet")));
                break;
            }
            case '\u3044': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HI"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                formattedNumber.append(this.int2singlealphaCount(listElement, (char[])thisBundle.getObject("alphabet")));
                break;
            }
            case '\u30a2': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "A"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                formattedNumber.append(this.int2singlealphaCount(listElement, (char[])thisBundle.getObject("alphabet")));
                break;
            }
            case '\u30a4': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "I"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                formattedNumber.append(this.int2singlealphaCount(listElement, (char[])thisBundle.getObject("alphabet")));
                break;
            }
            case '\u4e00': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "CN"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u58f9': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "TW"));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u0e51': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("th", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u05d0': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("he", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u10d0': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ka", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u03b1': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("el", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            case '\u0430': {
                XResourceBundle thisBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("cy", ""));
                if (letterVal != null && letterVal.equals("traditional")) {
                    formattedNumber.append(this.tradAlphaCount(listElement, thisBundle));
                    break;
                }
                this.int2alphaCount(listElement, (char[])thisBundle.getObject("alphabet"), formattedNumber);
                break;
            }
            default: {
                String numString = formatter.format(listElement);
                int nPadding = numberWidth - numString.length();
                int k2 = 0;
                while (k2 < nPadding) {
                    formattedNumber.append(padString);
                    ++k2;
                }
                formattedNumber.append(numString);
            }
        }
    }

    public XPath getFrom() {
        return this.m_fromMatchPattern;
    }

    public AVT getGroupingSeparator() {
        return this.m_groupingSeparator_avt;
    }

    public AVT getGroupingSize() {
        return this.m_groupingSize_avt;
    }

    public AVT getLang() {
        return this.m_lang_avt;
    }

    public AVT getLetterValue() {
        return this.m_lettervalue_avt;
    }

    public int getLevel() {
        return this.m_level;
    }

    Locale getLocale(TransformerImpl transformer, int contextNode) throws TransformerException {
        Locale locale = null;
        if (this.m_lang_avt != null) {
            XPathContext xctxt = transformer.getXPathContext();
            String langValue = this.m_lang_avt.evaluate(xctxt, contextNode, this);
            if (langValue != null && (locale = new Locale(langValue.toUpperCase(), "")) == null) {
                transformer.getMsgMgr().warn(this, null, xctxt.getDTM(contextNode).getNode(contextNode), 5, new Object[]{langValue});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    NodeVector getMatchingAncestors(XPathContext xctxt, int node, boolean stopAtFirstFound) throws TransformerException {
        NodeSetDTM ancestors = new NodeSetDTM(xctxt.getDTMManager());
        XPath countMatchPattern = this.getCountMatchPattern(xctxt, node);
        DTM dtm = xctxt.getDTM(node);
        while (node != -1) {
            if (this.m_fromMatchPattern != null && this.m_fromMatchPattern.getMatchScore(xctxt, node) != Double.NEGATIVE_INFINITY && !stopAtFirstFound) break;
            if (countMatchPattern == null) {
                System.out.println("Programmers error! countMatchPattern should never be null!");
            }
            if (countMatchPattern.getMatchScore(xctxt, node) != Double.NEGATIVE_INFINITY) {
                ancestors.addElement(node);
                if (stopAtFirstFound) break;
            }
            node = dtm.getParent(node);
        }
        return ancestors;
    }

    public String getNodeName() {
        return "number";
    }

    private DecimalFormat getNumberFormatter(TransformerImpl transformer, int contextNode) throws TransformerException {
        DecimalFormat formatter;
        block2: {
            String nDigitsPerGroupValue;
            Locale locale = (Locale)this.getLocale(transformer, contextNode).clone();
            formatter = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            String digitGroupSepValue = this.m_groupingSeparator_avt != null ? this.m_groupingSeparator_avt.evaluate(transformer.getXPathContext(), contextNode, this) : null;
            String string = nDigitsPerGroupValue = this.m_groupingSize_avt != null ? this.m_groupingSize_avt.evaluate(transformer.getXPathContext(), contextNode, this) : null;
            if (digitGroupSepValue == null || nDigitsPerGroupValue == null) break block2;
            try {
                formatter.setGroupingSize(Integer.valueOf(nDigitsPerGroupValue));
                formatter.getDecimalFormatSymbols().setGroupingSeparator(digitGroupSepValue.charAt(0));
                ((NumberFormat)formatter).setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                ((NumberFormat)formatter).setGroupingUsed(false);
            }
        }
        return formatter;
    }

    /*
     * Unable to fully structure code
     */
    public int getPreviousNode(XPathContext xctxt, int pos) throws TransformerException {
        block7: {
            countMatchPattern = this.getCountMatchPattern(xctxt, pos);
            dtm = xctxt.getDTM(pos);
            if (this.m_level != 3) ** GOTO lbl-1000
            fromMatchPattern = this.m_fromMatchPattern;
            while (pos != -1) {
                next = dtm.getPreviousSibling(pos);
                if (next == -1) {
                    next = dtm.getParent(pos);
                    if (next != -1 && (fromMatchPattern != null && fromMatchPattern.getMatchScore(xctxt, next) != -Infinity || dtm.getNodeType(next) == 9)) {
                        pos = -1;
                        break block7;
                    }
                } else {
                    child = next;
                    while (child != -1) {
                        child = dtm.getLastChild(next);
                        if (child == -1) continue;
                        next = child;
                    }
                }
                if ((pos = next) == -1 || countMatchPattern != null && countMatchPattern.getMatchScore(xctxt, pos) == -Infinity) {
                    continue;
                }
                break block7;
            }
            break block7;
            while ((pos = dtm.getPreviousSibling(pos)) == -1 || countMatchPattern != null && countMatchPattern.getMatchScore(xctxt, pos) == -Infinity) lbl-1000:
            // 2 sources

            {
                if (pos != -1) continue;
            }
        }
        return pos;
    }

    public int getTargetNode(XPathContext xctxt, int sourceNode) throws TransformerException {
        int target = -1;
        XPath countMatchPattern = this.getCountMatchPattern(xctxt, sourceNode);
        target = this.m_level == 3 ? this.findPrecedingOrAncestorOrSelf(xctxt, this.m_fromMatchPattern, countMatchPattern, sourceNode, this) : this.findAncestor(xctxt, this.m_fromMatchPattern, countMatchPattern, sourceNode, this);
        return target;
    }

    public XPath getValue() {
        return this.m_valueExpr;
    }

    public int getXSLToken() {
        return 35;
    }

    String getZeroString() {
        return "0";
    }

    protected void int2alphaCount(int val, char[] aTable, FastStringBuffer stringBuf) {
        int radix = aTable.length;
        char[] table = new char[aTable.length];
        int i2 = 0;
        while (i2 < aTable.length - 1) {
            table[i2 + 1] = aTable[i2];
            ++i2;
        }
        table[0] = aTable[i2];
        char[] buf = new char[100];
        int charPos = buf.length - 1;
        int lookupIndex = 1;
        int correction = 0;
        while ((lookupIndex = (val + (correction = lookupIndex == 0 || correction != 0 && lookupIndex == radix - 1 ? radix - 1 : 0)) % radix) != 0 || (val /= radix) != 0) {
            buf[charPos--] = table[lookupIndex];
            if (val > 0) continue;
        }
        stringBuf.append(buf, charPos + 1, buf.length - charPos - 1);
    }

    protected String int2singlealphaCount(int val, char[] table) {
        int radix = table.length;
        if (val > radix) {
            return this.getZeroString();
        }
        return new Character(table[val - 1]).toString();
    }

    protected String long2roman(long val, boolean prefixesAreOK) {
        if (val <= 0L) {
            return this.getZeroString();
        }
        String roman = "";
        int place = 0;
        if (val <= 3999L) {
            while (true) {
                if (val >= ElemNumber.m_romanConvertTable[place].m_postValue) {
                    roman = String.valueOf(roman) + ElemNumber.m_romanConvertTable[place].m_postLetter;
                    val -= ElemNumber.m_romanConvertTable[place].m_postValue;
                    continue;
                }
                if (prefixesAreOK && val >= ElemNumber.m_romanConvertTable[place].m_preValue) {
                    roman = String.valueOf(roman) + ElemNumber.m_romanConvertTable[place].m_preLetter;
                    val -= ElemNumber.m_romanConvertTable[place].m_preValue;
                }
                ++place;
                if (val <= 0L) break;
            }
        } else {
            roman = "#error";
        }
        return roman;
    }

    public void setCount(XPath v2) {
        this.m_countMatchPattern = v2;
    }

    public void setFormat(AVT v2) {
        this.m_format_avt = v2;
    }

    public void setFrom(XPath v2) {
        this.m_fromMatchPattern = v2;
    }

    public void setGroupingSeparator(AVT v2) {
        this.m_groupingSeparator_avt = v2;
    }

    public void setGroupingSize(AVT v2) {
        this.m_groupingSize_avt = v2;
    }

    public void setLang(AVT v2) {
        this.m_lang_avt = v2;
    }

    public void setLetterValue(AVT v2) {
        this.m_lettervalue_avt = v2;
    }

    public void setLevel(int v2) {
        this.m_level = v2;
    }

    public void setValue(XPath v2) {
        this.m_valueExpr = v2;
    }

    protected String tradAlphaCount(int val, XResourceBundle thisBundle) {
        char[] table = null;
        int lookupIndex = 1;
        char[] buf = new char[100];
        int charPos = 0;
        int[] groups = (int[])thisBundle.getObject("numberGroups");
        String[] tables = (String[])thisBundle.getObject("tables");
        String numbering = thisBundle.getString("numbering");
        if (numbering.equals("multiplicative-additive")) {
            String mult_order = thisBundle.getString("multiplierOrder");
            int[] multiplier = (int[])thisBundle.getObject("multiplier");
            char[] zeroChar = (char[])thisBundle.getObject("zero");
            int i2 = 0;
            while (i2 < multiplier.length && val < multiplier[i2]) {
                ++i2;
            }
            while (i2 < multiplier.length) {
                if (val < multiplier[i2]) {
                    if (zeroChar.length == 0) {
                        ++i2;
                    } else {
                        if (buf[charPos - 1] != zeroChar[0]) {
                            buf[charPos++] = zeroChar[0];
                        }
                        ++i2;
                    }
                } else if (val >= multiplier[i2]) {
                    int mult = val / multiplier[i2];
                    val %= multiplier[i2];
                    for (int k2 = 0; k2 < groups.length; ++k2) {
                        lookupIndex = 1;
                        if (mult / groups[k2] <= 0) {
                            continue;
                        }
                        char[] THEletters = (char[])thisBundle.getObject(tables[k2]);
                        table = new char[THEletters.length + 1];
                        int j2 = 0;
                        while (j2 < THEletters.length) {
                            table[j2 + 1] = THEletters[j2];
                            ++j2;
                        }
                        table[0] = THEletters[j2 - 1];
                        lookupIndex = mult / groups[k2];
                        if (lookupIndex == 0 && mult == 0) break;
                        char multiplierChar = ((char[])thisBundle.getObject("multiplierChar"))[i2];
                        if (lookupIndex < table.length) {
                            if (mult_order.equals("precedes")) {
                                buf[charPos++] = multiplierChar;
                                buf[charPos++] = table[lookupIndex];
                                break;
                            }
                            if (lookupIndex != 1 || i2 != multiplier.length - 1) {
                                buf[charPos++] = table[lookupIndex];
                            }
                            buf[charPos++] = multiplierChar;
                            break;
                        }
                        return "#error";
                    }
                    ++i2;
                }
                if (i2 < multiplier.length) continue;
            }
        }
        int count = 0;
        while (count < groups.length) {
            if (val / groups[count] <= 0) {
                ++count;
                continue;
            }
            char[] theletters = (char[])thisBundle.getObject(tables[count]);
            table = new char[theletters.length + 1];
            int j3 = 0;
            while (j3 < theletters.length) {
                table[j3 + 1] = theletters[j3];
                ++j3;
            }
            table[0] = theletters[j3 - 1];
            lookupIndex = val / groups[count];
            if (lookupIndex == 0 && (val %= groups[count]) == 0) break;
            if (lookupIndex >= table.length) {
                return "#error";
            }
            buf[charPos++] = table[lookupIndex];
            ++count;
        }
        return new String(buf, 0, charPos);
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String str) {
            this.str = str;
            this.maxPosition = str.length();
        }

        public int countTokens() {
            int count = 0;
            int currpos = this.currentPosition;
            while (currpos < this.maxPosition) {
                int start = currpos;
                while (currpos < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                if (start == currpos && !Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                ++count;
            }
            return count;
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public boolean isLetterOrDigitAhead() {
            int pos = this.currentPosition;
            while (pos < this.maxPosition) {
                if (Character.isLetterOrDigit(this.str.charAt(pos))) {
                    return true;
                }
                ++pos;
            }
            return false;
        }

        public boolean nextIsSep() {
            return !Character.isLetterOrDigit(this.str.charAt(this.currentPosition));
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int start = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (start == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(start, this.currentPosition);
        }

        public void reset() {
            this.currentPosition = 0;
        }
    }
}

