/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xml.dtm.ref.DTMNodeProxy;

public class PrintTraceListener
implements TraceListener {
    PrintWriter m_pw;
    public boolean m_traceTemplates = false;
    public boolean m_traceElements = false;
    public boolean m_traceGeneration = false;
    public boolean m_traceSelection = false;

    public PrintTraceListener(PrintWriter pw) {
        this.m_pw = pw;
    }

    public void generated(GenerateEvent ev2) {
        if (this.m_traceGeneration) {
            switch (ev2.m_eventtype) {
                case 1: {
                    this.m_pw.println("STARTDOCUMENT");
                    break;
                }
                case 2: {
                    this.m_pw.println("ENDDOCUMENT");
                    break;
                }
                case 3: {
                    this.m_pw.println("STARTELEMENT: " + ev2.m_name);
                    break;
                }
                case 4: {
                    this.m_pw.println("ENDELEMENT: " + ev2.m_name);
                    break;
                }
                case 5: {
                    String chars = new String(ev2.m_characters, ev2.m_start, ev2.m_length);
                    this.m_pw.println("CHARACTERS: " + chars);
                    break;
                }
                case 10: {
                    String chars = new String(ev2.m_characters, ev2.m_start, ev2.m_length);
                    this.m_pw.println("CDATA: " + chars);
                    break;
                }
                case 8: {
                    this.m_pw.println("COMMENT: " + ev2.m_data);
                    break;
                }
                case 7: {
                    this.m_pw.println("PI: " + ev2.m_name + ", " + ev2.m_data);
                    break;
                }
                case 9: {
                    this.m_pw.println("ENTITYREF: " + ev2.m_name);
                    break;
                }
                case 6: {
                    this.m_pw.println("IGNORABLEWHITESPACE");
                    break;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void selected(SelectionEvent ev) throws TransformerException {
        block11: {
            block12: {
                if (!this.m_traceSelection) break block11;
                ete = ev.m_styleNode;
                sourceNode = ev.m_sourceNode;
                nodeHandler = ((DTMNodeProxy)sourceNode).getDTMNodeNumber();
                locator = ((DTMNodeProxy)sourceNode).getDTM().getSourceLocatorFor(nodeHandler);
                if (locator != null) {
                    this.m_pw.println("Selected source node '" + sourceNode.getNodeName() + "', at " + locator);
                }
                if (ev.m_styleNode.getLineNumber() == 0) {
                    parent = ete.getParentElem();
                    if (parent == ete.getStylesheetRoot().getDefaultRootRule()) {
                        this.m_pw.print("(default root rule) ");
                    } else if (parent == ete.getStylesheetRoot().getDefaultTextRule()) {
                        this.m_pw.print("(default text rule) ");
                    } else if (parent == ete.getStylesheetRoot().getDefaultRule()) {
                        this.m_pw.print("(default rule) ");
                    }
                    this.m_pw.print(String.valueOf(ete.getNodeName()) + ", " + ev.m_attributeName + "='" + ev.m_xpath.getPatternString() + "': ");
                } else {
                    this.m_pw.print(String.valueOf(ev.m_styleNode.getSystemId()) + " Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + ": " + ete.getNodeName() + ", " + ev.m_attributeName + "='" + ev.m_xpath.getPatternString() + "': ");
                }
                ev.m_selection;
                if (ev.m_selection.getType() != 4) break block12;
                this.m_pw.println();
                nl = ev.m_selection.iter();
                try {
                    nl = nl.cloneWithReset();
                }
                catch (CloneNotSupportedException v0) {
                    this.m_pw.println("     [Can't trace nodelist because it it threw a CloneNotSupportedException]");
                    return;
                }
                pos = nl.nextNode();
                if (pos != -1) ** GOTO lbl42
                this.m_pw.println("     [empty node list]");
                break block11;
lbl-1000:
                // 1 sources

                {
                    dtm = ev.m_processor.getXPathContext().getDTM(pos);
                    this.m_pw.print("     ");
                    this.m_pw.print(Integer.toHexString(pos));
                    this.m_pw.print(": ");
                    this.m_pw.println(dtm.getNodeName(pos));
                    pos = nl.nextNode();
lbl42:
                    // 2 sources

                    ** while (pos != -1)
                }
lbl43:
                // 1 sources

                break block11;
            }
            this.m_pw.println(ev.m_selection.str());
        }
    }

    public void trace(TracerEvent ev2) {
        switch (ev2.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.m_pw.print(String.valueOf(ev2.m_styleNode.getSystemId()) + " Line #" + ev2.m_styleNode.getLineNumber() + ", " + "Column #" + ev2.m_styleNode.getColumnNumber() + " -- " + ev2.m_styleNode.getNodeName() + ": ");
                ElemTextLiteral etl = (ElemTextLiteral)ev2.m_styleNode;
                String chars = new String(etl.getChars(), 0, etl.getChars().length);
                this.m_pw.println("    " + chars.trim());
                break;
            }
            case 19: {
                if (!this.m_traceTemplates && !this.m_traceElements) break;
                ElemTemplate et2 = (ElemTemplate)ev2.m_styleNode;
                this.m_pw.print(String.valueOf(et2.getSystemId()) + " Line #" + et2.getLineNumber() + ", " + "Column #" + et2.getColumnNumber() + ": " + et2.getNodeName() + " ");
                if (et2.getMatch() != null) {
                    this.m_pw.print("match='" + et2.getMatch().getPatternString() + "' ");
                }
                if (et2.getName() != null) {
                    this.m_pw.print("name='" + et2.getName() + "' ");
                }
                this.m_pw.println();
                break;
            }
            default: {
                if (!this.m_traceElements) break;
                this.m_pw.println(String.valueOf(ev2.m_styleNode.getSystemId()) + " Line #" + ev2.m_styleNode.getLineNumber() + ", " + "Column #" + ev2.m_styleNode.getColumnNumber() + ": " + ev2.m_styleNode.getNodeName());
            }
        }
    }
}

