/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.objects.XObject;

public class KeyWalker
extends AxesWalker {
    transient int m_nextAttr;
    transient boolean m_foundAttrs;
    XMLString m_lookupKey;

    public KeyWalker(LocPathIterator locPathIterator) {
        super(locPathIterator, 5);
    }

    public short acceptNode(int testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            XMLString lookupKey = this.m_lookupKey;
            int nDeclarations = keys.size();
            int i2 = 0;
            while (i2 < nDeclarations) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i2);
                if (kd.getName().equals(name)) {
                    foundKey = true;
                    ki.getXPathContext().setNamespaceContext(ki.getPrefixResolver());
                    double score = kd.getMatch().getMatchScore(ki.getXPathContext(), testNode);
                    kd.getMatch();
                    if (score != Double.NEGATIVE_INFINITY) {
                        XObject xuse = kd.getUse().execute(ki.getXPathContext(), testNode, ki.getPrefixResolver());
                        if (xuse.getType() != 4) {
                            XMLString exprResult = xuse.xstr();
                            ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                            if (lookupKey.equals(exprResult)) {
                                return 1;
                            }
                        } else {
                            int useNode;
                            DTMIterator nl = xuse.iter();
                            short result = -1;
                            while ((useNode = nl.nextNode()) != -1) {
                                DTM dtm = this.getDTM(useNode);
                                XMLString exprResult = dtm.getStringValue(useNode);
                                ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                                if (exprResult == null || !lookupKey.equals(exprResult)) continue;
                                result = 1;
                            }
                            if (result != -1) {
                                return result;
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        catch (TransformerException transformerException) {}
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage(58, new Object[]{name.getLocalName()}));
        }
        return 2;
    }

    protected int getNextNode() {
        int next;
        int currentNode = this.getCurrentNode();
        DTM dtm = this.m_lpi.getXPathContext().getDTM(currentNode);
        if (!this.m_foundAttrs) {
            this.m_nextAttr = dtm.getFirstAttribute(currentNode);
            this.m_foundAttrs = true;
            if (this.m_nextAttr != -1) {
                return this.m_nextAttr;
            }
        } else if (this.m_nextAttr != -1) {
            this.m_nextAttr = dtm.getNextAttribute(this.m_nextAttr);
            if (this.m_nextAttr != -1) {
                return this.m_nextAttr;
            }
        }
        if ((next = super.getNextNode()) != -1) {
            this.m_foundAttrs = false;
        }
        return next;
    }

    public int nextNode() {
        int node = super.nextNode();
        if (node == -1) {
            ((KeyIterator)this.m_lpi).setLookForMoreNodes(false);
        }
        return node;
    }

    public void setRoot(int root) {
        this.m_nextAttr = -1;
        this.m_foundAttrs = false;
        super.setRoot(root);
    }
}

