/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "xerces.jar", "testxsl.jar", "crimson.jar", "lotusxsl.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar", "xsltc.jar"};
    protected PrintWriter outWriter = new PrintWriter(System.out, true);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$Attributes;

    public void appendEnvironmentReport(Node container, Document factory, Hashtable h2) {
        if (container == null || factory == null) {
            return;
        }
        try {
            Element envCheckNode = factory.createElement("EnvironmentCheck");
            envCheckNode.setAttribute("version", "$Revision: 1.7 $");
            container.appendChild(envCheckNode);
            if (h2 == null) {
                Element statusNode = factory.createElement("status");
                statusNode.setAttribute("result", "ERROR");
                statusNode.appendChild(factory.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                envCheckNode.appendChild(statusNode);
                return;
            }
            boolean errors = false;
            Element hashNode = factory.createElement("environment");
            envCheckNode.appendChild(hashNode);
            Enumeration enumeration = h2.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                String keyStr = (String)key;
                try {
                    if (keyStr.startsWith(FOUNDCLASSES)) {
                        Vector v2 = (Vector)h2.get(keyStr);
                        errors |= this.appendFoundJars(hashNode, factory, v2, keyStr);
                        continue;
                    }
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    Element node = factory.createElement("item");
                    node.setAttribute("key", keyStr);
                    node.appendChild(factory.createTextNode((String)h2.get(keyStr)));
                    hashNode.appendChild(node);
                }
                catch (Exception e10) {
                    errors = true;
                    Element node = factory.createElement("item");
                    node.setAttribute("key", keyStr);
                    node.appendChild(factory.createTextNode("ERROR. Reading " + key + " threw: " + e10.toString()));
                    hashNode.appendChild(node);
                }
            }
            Element statusNode = factory.createElement("status");
            statusNode.setAttribute("result", errors ? "ERROR" : "OK");
            envCheckNode.appendChild(statusNode);
        }
        catch (Exception e22) {
            System.err.println("appendEnvironmentReport threw: " + e22.toString());
            e22.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node container, Document factory, Vector v2, String desc) {
        if (v2 == null || v2.size() < 1) {
            return false;
        }
        boolean errors = false;
        int i2 = 0;
        while (i2 < v2.size()) {
            Hashtable subhash = (Hashtable)v2.elementAt(i2);
            Enumeration enumeration = subhash.keys();
            while (enumeration.hasMoreElements()) {
                Element node;
                Object key = enumeration.nextElement();
                try {
                    String keyStr = (String)key;
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    node = factory.createElement("foundJar");
                    node.setAttribute("name", keyStr.substring(0, keyStr.indexOf("-")));
                    node.setAttribute("desc", keyStr.substring(keyStr.indexOf("-") + 1));
                    node.appendChild(factory.createTextNode((String)subhash.get(keyStr)));
                    container.appendChild(node);
                }
                catch (Exception e10) {
                    errors = true;
                    node = factory.createElement("foundJar");
                    node.appendChild(factory.createTextNode("ERROR. Reading " + key + " threw: " + e10.toString()));
                    container.appendChild(node);
                }
            }
            ++i2;
        }
        return errors;
    }

    protected void checkDOMVersion(Hashtable h2) {
        if (h2 == null) {
            h2 = new Hashtable<String, String>();
        }
        String DOM_LEVEL2_CLASS = "org.w3c.dom.Document";
        String DOM_LEVEL2_METHOD = "createElementNS";
        String DOM_LEVEL2WD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2WD_METHOD = "supported";
        String DOM_LEVEL2FD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2FD_METHOD = "isSupported";
        Class[] twoStringArgs = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EnvironmentCheck.class$("java.lang.String"))};
        try {
            Class<?> clazz = Class.forName("org.w3c.dom.Document");
            Method method = clazz.getMethod("createElementNS", twoStringArgs);
            h2.put("version.DOM", "2.0");
            try {
                clazz = Class.forName("org.w3c.dom.Node");
                method = clazz.getMethod("supported", twoStringArgs);
                h2.put("ERROR.version.DOM.draftlevel", "2.0wd");
                h2.put(ERROR, ERROR_FOUND);
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName("org.w3c.dom.Node");
                    method = clazz.getMethod("isSupported", twoStringArgs);
                    h2.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception exception2) {
                    h2.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                    h2.put(ERROR, ERROR_FOUND);
                }
            }
        }
        catch (Exception e10) {
            h2.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + e10.toString());
            h2.put(ERROR, ERROR_FOUND);
        }
    }

    public boolean checkEnvironment(PrintWriter pw) {
        Hashtable hash;
        boolean environmentHasErrors;
        if (pw != null) {
            this.outWriter = pw;
        }
        if (environmentHasErrors = this.writeEnvironmentReport(hash = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (this.outWriter != null) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# YAHOO! Your environment seems to be OK.");
        if (this.outWriter != null) {
            this.outWriter.flush();
        }
        return true;
    }

    protected void checkJAXPVersion(Hashtable h2) {
        if (h2 == null) {
            h2 = new Hashtable<String, String>();
        }
        Class[] noArgs = new Class[]{};
        Class<?> clazz = null;
        try {
            String JAXP1_CLASS = "javax.xml.parsers.DocumentBuilder";
            String JAXP11_METHOD = "getDOMImplementation";
            clazz = Class.forName("javax.xml.parsers.DocumentBuilder");
            Method method = clazz.getMethod("getDOMImplementation", noArgs);
            h2.put("version.JAXP", "1.1");
        }
        catch (Exception exception) {
            if (clazz != null) {
                h2.put("ERROR.version.JAXP", "1.0.1");
                h2.put(ERROR, ERROR_FOUND);
            }
            h2.put("ERROR.version.JAXP", CLASS_NOTPRESENT);
            h2.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkParserVersion(Hashtable h2) {
        Field f2;
        Class<?> clazz;
        if (h2 == null) {
            h2 = new Hashtable<String, String>();
        }
        String XERCES1_VERSION_CLASS = "org.apache.xerces.framework.Version";
        String XERCES2_VERSION_CLASS = "org.apache.xerces.impl.Version";
        try {
            clazz = Class.forName("org.apache.xerces.framework.Version");
            f2 = clazz.getField("fVersion");
            String parserVersion = (String)f2.get(null);
            h2.put("version.xerces", parserVersion);
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName("org.apache.xerces.impl.Version");
                f2 = clazz.getField("fVersion");
                String parserVersion = (String)f2.get(null);
                h2.put("version.xerces", parserVersion);
            }
            catch (Exception exception2) {
                h2.put("version.xerces", CLASS_NOTPRESENT);
            }
            h2.put("version.xerces", CLASS_NOTPRESENT);
        }
        try {
            String CRIMSON_CLASS = "org.apache.crimson.Parser2";
            Class<?> clazz2 = Class.forName("org.apache.crimson.Parser2");
            h2.put("version.crimson", CLASS_PRESENT);
        }
        catch (Exception exception) {
            h2.put("version.crimson", CLASS_NOTPRESENT);
        }
    }

    protected Vector checkPathForJars(String cp2, String[] jars) {
        if (cp2 == null || jars == null || cp2.length() == 0 || jars.length == 0) {
            return null;
        }
        Vector v2 = new Vector();
        StringTokenizer st = new StringTokenizer(cp2, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken().toLowerCase();
            int i2 = 0;
            while (i2 < jars.length) {
                if (filename.indexOf(jars[i2]) > -1) {
                    Hashtable<String, String> h2;
                    File f2 = new File(filename);
                    if (f2.exists()) {
                        try {
                            h2 = new Hashtable(2);
                            h2.put(String.valueOf(jars[i2]) + "-path", f2.getAbsolutePath());
                            h2.put(String.valueOf(jars[i2]) + "-apparent.version", this.getApparentVersion(jars[i2], f2.length()));
                            v2.addElement(h2);
                        }
                        catch (Exception exception) {}
                    } else {
                        h2 = new Hashtable<String, String>(2);
                        h2.put(String.valueOf(jars[i2]) + "-path", "WARNING. Classpath entry: " + filename + " does not exist");
                        h2.put(String.valueOf(jars[i2]) + "-apparent.version", CLASS_NOTPRESENT);
                        v2.addElement(h2);
                    }
                }
                ++i2;
            }
        }
        return v2;
    }

    protected void checkProcessorVersion(Hashtable h2) {
        Field f2;
        StringBuffer buf;
        Class<?> clazz;
        if (h2 == null) {
            h2 = new Hashtable<String, String>();
        }
        try {
            String XALAN1_VERSION_CLASS = "org.apache.xalan.xslt.XSLProcessorVersion";
            clazz = Class.forName("org.apache.xalan.xslt.XSLProcessorVersion");
            buf = new StringBuffer();
            f2 = clazz.getField("PRODUCT");
            buf.append(f2.get(null));
            buf.append(';');
            f2 = clazz.getField("LANGUAGE");
            buf.append(f2.get(null));
            buf.append(';');
            f2 = clazz.getField("S_VERSION");
            buf.append(f2.get(null));
            buf.append(';');
            h2.put("version.xalan1", buf.toString());
        }
        catch (Exception exception) {
            h2.put("version.xalan1", CLASS_NOTPRESENT);
        }
        try {
            String XALAN2_VERSION_CLASS = "org.apache.xalan.processor.XSLProcessorVersion";
            clazz = Class.forName("org.apache.xalan.processor.XSLProcessorVersion");
            buf = new StringBuffer();
            f2 = clazz.getField("PRODUCT");
            buf.append(f2.get(null));
            buf.append(";");
            f2 = clazz.getField("LANGUAGE");
            buf.append(f2.get(null));
            buf.append(";");
            f2 = clazz.getField("S_VERSION");
            buf.append(f2.get(null));
            buf.append(";");
            h2.put("version.xalan2", buf.toString());
        }
        catch (Exception exception) {
            h2.put("version.xalan2", CLASS_NOTPRESENT);
        }
    }

    protected void checkSAXVersion(Hashtable h2) {
        if (h2 == null) {
            h2 = new Hashtable<String, String>();
        }
        String SAX_VERSION1_CLASS = "org.xml.sax.Parser";
        String SAX_VERSION1_METHOD = "parse";
        String SAX_VERSION2_CLASS = "org.xml.sax.XMLReader";
        String SAX_VERSION2_METHOD = "parse";
        String SAX_VERSION2BETA_CLASSNF = "org.xml.sax.helpers.AttributesImpl";
        String SAX_VERSION2BETA_METHODNF = "setAttributes";
        Class[] oneStringArg = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EnvironmentCheck.class$("java.lang.String"))};
        Class[] attributesArg = new Class[]{class$org$xml$sax$Attributes != null ? class$org$xml$sax$Attributes : (class$org$xml$sax$Attributes = EnvironmentCheck.class$("org.xml.sax.Attributes"))};
        try {
            Class<?> clazz = Class.forName("org.xml.sax.helpers.AttributesImpl");
            Method method = clazz.getMethod("setAttributes", attributesArg);
            h2.put("version.SAX", "2.0");
        }
        catch (Exception e10) {
            h2.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e10.toString());
            h2.put(ERROR, ERROR_FOUND);
            try {
                Class<?> clazz = Class.forName("org.xml.sax.XMLReader");
                Method method = clazz.getMethod("parse", oneStringArg);
                h2.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception exception) {
                h2.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e10.toString());
                h2.put(ERROR, ERROR_FOUND);
                try {
                    Class<?> clazz = Class.forName("org.xml.sax.Parser");
                    Method method = clazz.getMethod("parse", oneStringArg);
                    h2.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception e32) {
                    h2.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + e32.toString());
                }
            }
        }
    }

    protected void checkSystemProperties(Hashtable h2) {
        if (h2 == null) {
            h2 = new Hashtable<String, Object>();
        }
        try {
            String javaVersion = System.getProperty("java.version");
            h2.put("java.version", javaVersion);
        }
        catch (SecurityException securityException) {
            h2.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String othercp;
            String cp2 = System.getProperty("java.class.path");
            h2.put("java.class.path", cp2);
            Vector classpathJars = this.checkPathForJars(cp2, this.jarNames);
            if (classpathJars != null) {
                h2.put("foundclasses.java.class.path", classpathJars);
            }
            if ((othercp = System.getProperty("sun.boot.class.path")) != null) {
                h2.put("sun.boot.class.path", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (classpathJars != null) {
                    h2.put("foundclasses.sun.boot.class.path", classpathJars);
                }
            }
            if ((othercp = System.getProperty("java.ext.dirs")) != null) {
                h2.put("java.ext.dirs", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (classpathJars != null) {
                    h2.put("foundclasses.java.ext.dirs", classpathJars);
                }
            }
        }
        catch (SecurityException securityException) {
            h2.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected String getApparentVersion(String jarName, long jarSize) {
        Hashtable<Long, String> jarVersions = new Hashtable<Long, String>();
        jarVersions.put(new Long(857192L), "xalan.jar from xalan-j_1_1");
        jarVersions.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        jarVersions.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        jarVersions.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        jarVersions.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(872241L), "xalan.jar from xalan-j_2_2_D10");
        jarVersions.put(new Long(857171L), "xalan.jar from lotusxsl-j_1_0_1");
        jarVersions.put(new Long(802165L), "xalan.jar from lotusxsl-j_2_0_0");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_2");
        jarVersions.put(new Long(424490L), "xalan.jar from Xerces Tools releases - ERROR:DO NOT USE!");
        jarVersions.put(new Long(1591855L), "xerces.jar from xalan-j_1_1 from xerces-1...");
        jarVersions.put(new Long(1498679L), "xerces.jar from xalan-j_1_2 from xerces-1_2_0.bin");
        jarVersions.put(new Long(1484896L), "xerces.jar from xalan-j_1_2_1 from xerces-1_2_1.bin");
        jarVersions.put(new Long(804460L), "xerces.jar from xalan-j_1_2_2 from xerces-1_2_2.bin");
        jarVersions.put(new Long(1499244L), "xerces.jar from xalan-j_2_0_0 from xerces-1_2_3.bin");
        jarVersions.put(new Long(1605266L), "xerces.jar from xalan-j_2_0_1 from xerces-1_3_0.bin");
        jarVersions.put(new Long(1190776L), "xerces.jar from lotusxsl_1_0_1 apparently-from xerces-1_0_3.bin");
        jarVersions.put(new Long(1489400L), "xerces.jar from lotusxsl-j_2_0_0 from XML4J-3_1_1");
        jarVersions.put(new Long(1787796L), "xerces.jar from lotusxsl-j_2_2 or xerces-1_4_1.bin");
        jarVersions.put(new Long(904030L), "xerces.jar from xerces-1_4_0.bin");
        jarVersions.put(new Long(1802885L), "xerces.jar from xerces-1_4_2.bin");
        jarVersions.put(new Long(1808883L), "xerces.jar from xalan-j_2_2_D10 or xerces-1_4_3.bin");
        jarVersions.put(new Long(1803877L), "xerces.jar from XML4J-3_2_1");
        jarVersions.put(new Long(37485L), "xalanj1compat.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(38100L), "xalanj1compat.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(18779L), "xalanservlet.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(21453L), "xalanservlet.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(5618L), "jaxp.jar from jaxp1.0.1");
        jarVersions.put(new Long(136133L), "parser.jar from jaxp1.0.1");
        jarVersions.put(new Long(28404L), "jaxp.jar from jaxp-1.1");
        jarVersions.put(new Long(187162L), "crimson.jar from jaxp-1.1");
        jarVersions.put(new Long(801714L), "xalan.jar from jaxp-1.1");
        jarVersions.put(new Long(5537L), "jaxp.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(136198L), "parser.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(120274L), "lotusxsl.jar from lotusxsl-0_16_4");
        jarVersions.put(new Long(120293L), "lotusxsl.jar from lotusxsl-0_16_5");
        jarVersions.put(new Long(283777L), "lotusxsl.jar from lotusxsl-0_17_2");
        jarVersions.put(new Long(305577L), "lotusxsl.jar from lotusxsl-0_17_3");
        jarVersions.put(new Long(304500L), "lotusxsl.jar from lotusxsl-0_17_4");
        jarVersions.put(new Long(714959L), "lotusxsl.jar from lotusxsl-0_18_1");
        jarVersions.put(new Long(717674L), "lotusxsl.jar from lotusxsl-0_18_2");
        jarVersions.put(new Long(752343L), "lotusxsl.jar from lotusxsl-0_18_3");
        jarVersions.put(new Long(907101L), "lotusxsl.jar from lotusxsl-0_18_4");
        String foundSize = (String)jarVersions.get(new Long(jarSize));
        if (foundSize != null && foundSize.startsWith(jarName)) {
            return foundSize;
        }
        if ("xerces.jar".equalsIgnoreCase(jarName) || "xalan.jar".equalsIgnoreCase(jarName)) {
            return String.valueOf(jarName) + " " + WARNING + CLASS_PRESENT;
        }
        return String.valueOf(jarName) + " " + CLASS_PRESENT;
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hash = new Hashtable();
        this.checkJAXPVersion(hash);
        this.checkProcessorVersion(hash);
        this.checkParserVersion(hash);
        this.checkDOMVersion(hash);
        this.checkSAXVersion(hash);
        this.checkSystemProperties(hash);
        return hash;
    }

    protected boolean logFoundJars(Vector v2, String desc) {
        if (v2 == null || v2.size() < 1) {
            return false;
        }
        boolean errors = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + desc + " ----");
        int i2 = 0;
        while (i2 < v2.size()) {
            Hashtable subhash = (Hashtable)v2.elementAt(i2);
            Enumeration enumeration = subhash.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                String keyStr = (String)key;
                try {
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    this.logMsg(String.valueOf(keyStr) + "=" + subhash.get(keyStr));
                }
                catch (Exception e10) {
                    errors = true;
                    this.logMsg("Reading-" + key + "= threw: " + e10.toString());
                }
            }
            ++i2;
        }
        this.logMsg("#----- END Listing XML-related jars in: " + desc + " -----");
        return errors;
    }

    protected void logMsg(String s2) {
        this.outWriter.println(s2);
    }

    public static void main(String[] args) {
        PrintWriter sendOutputTo = new PrintWriter(System.out, true);
        int i2 = 0;
        while (i2 < args.length) {
            if ("-out".equalsIgnoreCase(args[i2])) {
                if (++i2 < args.length) {
                    try {
                        sendOutputTo = new PrintWriter(new FileWriter(args[i2], true));
                    }
                    catch (Exception e10) {
                        System.err.println("# WARNING: -out " + args[i2] + " threw " + e10.toString());
                    }
                } else {
                    System.err.println("# WARNING: -out argument should have a filename, output sent to console");
                }
            }
            ++i2;
        }
        EnvironmentCheck app = new EnvironmentCheck();
        app.checkEnvironment(sendOutputTo);
    }

    protected boolean writeEnvironmentReport(Hashtable h2) {
        if (h2 == null) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean errors = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport($Revision: 1.7 $): Useful properties found: ----");
        Enumeration enumeration = h2.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            String keyStr = (String)key;
            try {
                if (keyStr.startsWith(FOUNDCLASSES)) {
                    Vector v2 = (Vector)h2.get(keyStr);
                    errors |= this.logFoundJars(v2, keyStr);
                    continue;
                }
                if (keyStr.startsWith(ERROR)) {
                    errors = true;
                }
                this.logMsg(String.valueOf(keyStr) + "=" + h2.get(keyStr));
            }
            catch (Exception e10) {
                this.logMsg("Reading-" + key + "= threw: " + e10.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return errors;
    }
}

