/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMConfigurationException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;

public abstract class DTMManager {
    private static final String defaultPropName = "org.apache.xml.dtm.DTMManager";
    protected XMLStringFactory m_xsf = null;
    public static boolean m_incremental = false;
    private static String foundFactory = null;
    private static boolean debug;
    public static final int IDENT_DTM_NODE_BITS = 22;
    public static final int IDENT_NODE_DEFAULT = 0x3FFFFF;
    public static final int IDENT_DTM_DEFAULT = -4194304;
    public static final int IDENT_MAX_DTMS = 1024;
    static /* synthetic */ Class class$org$apache$xml$dtm$DTMManager;

    static {
        try {
            debug = System.getProperty("dtm.debug") != null;
        }
        catch (SecurityException securityException) {}
    }

    protected DTMManager() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public abstract DTMIterator createDTMIterator(int var1);

    public abstract DTMIterator createDTMIterator(int var1, DTMFilter var2, boolean var3);

    public abstract DTMIterator createDTMIterator(Object var1, int var2);

    public abstract DTMIterator createDTMIterator(String var1, PrefixResolver var2);

    public abstract DTM createDocumentFragment();

    private static String findFactory(String factoryId, String defaultFactory) {
        block19: {
            block18: {
                try {
                    String systemProp = null;
                    try {
                        systemProp = System.getProperty(factoryId);
                    }
                    catch (SecurityException securityException) {}
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("DTM: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException securityException) {}
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f2 = new File(configFile);
                    if (f2.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f2));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println("DTM: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex2) {
                    if (!debug) break block18;
                    ex2.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                ClassLoader cl2 = (class$org$apache$xml$dtm$DTMManager != null ? class$org$apache$xml$dtm$DTMManager : (class$org$apache$xml$dtm$DTMManager = DTMManager.class$(defaultPropName))).getClassLoader();
                InputStream is = null;
                is = cl2 == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl2.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("DTM: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("DTM: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex3) {
                if (!debug) break block19;
                ex3.printStackTrace();
            }
        }
        return defaultFactory;
    }

    public abstract DTM getDTM(int var1);

    public abstract DTM getDTM(Source var1, boolean var2, DTMWSFilter var3, boolean var4, boolean var5);

    public abstract int getDTMHandleFromNode(Node var1);

    public abstract int getDTMIdentity(DTM var1);

    public int getDTMIdentityMask() {
        return -4194304;
    }

    public static synchronized boolean getIncremental() {
        return m_incremental;
    }

    public int getNodeIdentityMask() {
        return 0x3FFFFF;
    }

    public XMLStringFactory getXMLStringFactory() {
        return this.m_xsf;
    }

    public static DTMManager newInstance(XMLStringFactory xsf) throws DTMConfigurationException {
        DTMManager factoryImpl;
        String classname = DTMManager.findFactory(defaultPropName, "org.apache.xml.dtm.ref.DTMManagerDefault");
        if (classname == null) {
            throw new DTMConfigurationException(XSLMessages.createMessage(156, null));
        }
        try {
            Class<?> clazz = Class.forName(classname);
            factoryImpl = (DTMManager)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new DTMConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new DTMConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new DTMConfigurationException(ie);
        }
        factoryImpl.setXMLStringFactory(xsf);
        return factoryImpl;
    }

    public abstract boolean release(DTM var1, boolean var2);

    public static synchronized void setIncremental(boolean incremental) {
        m_incremental = incremental;
    }

    public void setXMLStringFactory(XMLStringFactory xsf) {
        this.m_xsf = xsf;
    }
}

