/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    protected DTM[] m_dtms = new DTM[1024];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;

    public void addDTM(DTM dtm, int id) {
        this.m_dtms[id] = dtm;
        dtm.documentRegistration();
    }

    public DTMIterator createDTMIterator(int node) {
        return null;
    }

    public DTMIterator createDTMIterator(int whatToShow, DTMFilter filter, boolean entityReferenceExpansion) {
        return null;
    }

    public DTMIterator createDTMIterator(Object xpathCompiler, int pos) {
        return null;
    }

    public DTMIterator createDTMIterator(String xpathString, PrefixResolver presolver) {
        return null;
    }

    public DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            Document doc = db2.newDocument();
            DocumentFragment df2 = doc.createDocumentFragment();
            return this.getDTM(new DOMSource(df2), true, null, false, false);
        }
        catch (Exception e10) {
            throw new DTMException(e10);
        }
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_dtms[nodeHandle >>> 22];
    }

    public DTM getDTM(Source source, boolean unique, DTMWSFilter whiteSpaceFilter, boolean incremental, boolean doIndexing) {
        boolean isStreamSource;
        XMLStringFactory xstringFactory = this.m_xsf;
        int dtmPos = this.getFirstFreeDTMID();
        int documentID = dtmPos << 22;
        if (source != null && source instanceof DOMSource) {
            DOM2DTM dtm = new DOM2DTM((DTMManager)this, (DOMSource)source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos);
            return dtm;
        }
        boolean isSAXSource = source != null ? source instanceof SAXSource : true;
        boolean bl2 = isStreamSource = source != null ? source instanceof StreamSource : false;
        if (isSAXSource || isStreamSource) {
            boolean haveXercesParser;
            XMLReader reader;
            InputSource xmlSource;
            if (source == null) {
                xmlSource = null;
                reader = null;
            } else {
                reader = this.getXMLReader(source);
                xmlSource = SAXSource.sourceToInputSource(source);
                String urlOfSource = xmlSource.getSystemId();
                if (urlOfSource != null) {
                    try {
                        urlOfSource = SystemIDResolver.getAbsoluteURI(urlOfSource);
                    }
                    catch (Exception exception) {
                        System.err.println("Can not absolutize URL: " + urlOfSource);
                    }
                    xmlSource.setSystemId(urlOfSource);
                }
            }
            SAX2DTM dtm = new SAX2DTM(this, source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos);
            boolean bl3 = haveXercesParser = reader != null && reader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (haveXercesParser) {
                incremental = true;
            }
            if (DTMManager.m_incremental && incremental) {
                IncrementalSAXSource coParser = null;
                if (haveXercesParser) {
                    try {
                        Class<?> c10 = Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces");
                        coParser = (IncrementalSAXSource)c10.newInstance();
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                        coParser = null;
                    }
                }
                if (coParser == null) {
                    if (reader == null) {
                        coParser = new IncrementalSAXSource_Filter();
                    } else {
                        IncrementalSAXSource_Filter filter = new IncrementalSAXSource_Filter();
                        filter.setXMLReader(reader);
                        coParser = filter;
                    }
                }
                dtm.setIncrementalSAXSource(coParser);
                if (xmlSource == null) {
                    return dtm;
                }
                reader.setDTDHandler(dtm);
                reader.setErrorHandler(dtm);
                try {
                    coParser.startParse(xmlSource);
                }
                catch (RuntimeException re) {
                    dtm.clearCoRoutine();
                    throw re;
                }
                catch (Exception e10) {
                    dtm.clearCoRoutine();
                    throw new WrappedRuntimeException(e10);
                }
            }
            if (reader == null) {
                return dtm;
            }
            reader.setContentHandler(dtm);
            reader.setDTDHandler(dtm);
            reader.setErrorHandler(dtm);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", dtm);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            try {
                reader.parse(xmlSource);
            }
            catch (RuntimeException re) {
                dtm.clearCoRoutine();
                throw re;
            }
            catch (Exception e11) {
                dtm.clearCoRoutine();
                throw new WrappedRuntimeException(e11);
            }
            return dtm;
        }
        throw new DTMException(XSLMessages.createMessage(171, new Object[]{source}));
    }

    public int getDTMHandleFromNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage(172, null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int max = this.m_dtms.length;
        int i2 = 0;
        while (i2 < max) {
            int handle;
            DTM thisDTM = this.m_dtms[i2];
            if (thisDTM != null && thisDTM instanceof DOM2DTM && (handle = ((DOM2DTM)thisDTM).getHandleOfNode(node)) != -1) {
                return handle;
            }
            ++i2;
        }
        Node root = node;
        Node p2 = root.getParentNode();
        while (p2 != null) {
            root = p2;
            p2 = p2.getParentNode();
        }
        DTM dtm = this.getDTM(new DOMSource(root), false, null, true, true);
        int handle = ((DOM2DTM)dtm).getHandleOfNode(node);
        if (handle == -1) {
            throw new RuntimeException(XSLMessages.createMessage(173, null));
        }
        return handle;
    }

    public int getDTMIdentity(DTM dtm) {
        int n2 = this.m_dtms.length;
        int i2 = 0;
        while (i2 < n2) {
            DTM tdtm = this.m_dtms[i2];
            if (tdtm == dtm) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dtm) {
        return this.m_expandedNameTable;
    }

    public int getFirstFreeDTMID() {
        int n2 = this.m_dtms.length;
        int i2 = 1;
        while (i2 < n2) {
            if (this.m_dtms[i2] == null) {
                return i2;
            }
            ++i2;
        }
        throw new DTMException(XSLMessages.createMessage(170, null));
    }

    public XMLReader getXMLReader(Source inputSource) {
        try {
            boolean isUserReader;
            XMLReader reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            boolean bl2 = isUserReader = reader != null;
            if (reader == null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex2) {
                    throw new SAXException(ex2);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {}
            return reader;
        }
        catch (SAXException se) {
            throw new DTMException(se.getMessage(), se);
        }
    }

    public boolean release(DTM dtm, boolean shouldHardDelete) {
        int i2;
        if (dtm instanceof SAX2DTM) {
            ((SAX2DTM)dtm).clearCoRoutine();
        }
        if ((i2 = this.getDTMIdentity(dtm)) >= 0) {
            this.m_dtms[i2] = null;
        }
        dtm.documentRelease();
        return true;
    }
}

