/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.IOException;
import java.io.Serializable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.ref.CoroutineManager;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class IncrementalSAXSource_Filter
implements IncrementalSAXSource,
ContentHandler,
LexicalHandler,
ErrorHandler,
Runnable {
    boolean DEBUG = false;
    private CoroutineManager fCoroutineManager = null;
    private int fControllerCoroutineID = -1;
    private int fSourceCoroutineID = -1;
    private ContentHandler clientContentHandler = null;
    private LexicalHandler clientLexicalHandler = null;
    private ErrorHandler clientErrorHandler = null;
    private int eventcounter;
    private int frequency = 5;
    private boolean fNoMoreEvents = false;
    private XMLReader fXMLReader = null;
    private InputSource fXMLReaderInputSource = null;

    public IncrementalSAXSource_Filter() {
        this.init(new CoroutineManager(), -1, -1);
    }

    public IncrementalSAXSource_Filter(CoroutineManager co2, int controllerCoroutineID) {
        this.init(co2, controllerCoroutineID, -1);
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.characters(ch2, start, length);
        }
    }

    private void co_entry_pause() throws SAXException {
        if (this.fCoroutineManager == null) {
            this.init(null, -1, -1);
        }
        try {
            Object arg = this.fCoroutineManager.co_entry_pause(this.fSourceCoroutineID);
            if (arg == Boolean.FALSE) {
                this.co_yield(false);
            }
        }
        catch (NoSuchMethodException e10) {
            if (this.DEBUG) {
                e10.printStackTrace();
            }
            throw new SAXException(e10);
        }
    }

    private void co_yield(boolean moreRemains) throws SAXException {
        if (this.fNoMoreEvents) {
            return;
        }
        try {
            Object arg = Boolean.FALSE;
            if (moreRemains) {
                arg = this.fCoroutineManager.co_resume(Boolean.TRUE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
            if (arg == Boolean.FALSE) {
                this.fNoMoreEvents = true;
                if (this.fXMLReader != null) {
                    throw new StopException();
                }
                this.fCoroutineManager.co_exit_to(Boolean.FALSE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
        }
        catch (NoSuchMethodException e10) {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
            throw new SAXException(e10);
        }
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.comment(ch2, start, length);
        }
    }

    protected void count_and_yield(boolean moreExpected) throws SAXException {
        if (!moreExpected) {
            this.eventcounter = 0;
        }
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
    }

    public static IncrementalSAXSource createIncrementalSAXSource(CoroutineManager co2, int controllerCoroutineID) {
        return new IncrementalSAXSource_Filter(co2, controllerCoroutineID);
    }

    public Object deliverMoreNodes(boolean parsemore) {
        if (this.fNoMoreEvents) {
            return Boolean.FALSE;
        }
        try {
            Object result = this.fCoroutineManager.co_resume(parsemore ? Boolean.TRUE : Boolean.FALSE, this.fControllerCoroutineID, this.fSourceCoroutineID);
            if (result == Boolean.FALSE) {
                this.fCoroutineManager.co_exit(this.fControllerCoroutineID);
            }
            return result;
        }
        catch (NoSuchMethodException e10) {
            return e10;
        }
    }

    public void endCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endDocument();
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endElement(namespaceURI, localName, qName);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endPrefixMapping(prefix);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    public int getControllerCoroutineID() {
        return this.fControllerCoroutineID;
    }

    public CoroutineManager getCoroutineManager() {
        return this.fCoroutineManager;
    }

    public int getSourceCoroutineID() {
        return this.fSourceCoroutineID;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.ignorableWhitespace(ch2, start, length);
        }
    }

    public void init(CoroutineManager co2, int controllerCoroutineID, int sourceCoroutineID) {
        if (co2 == null) {
            co2 = new CoroutineManager();
        }
        this.fCoroutineManager = co2;
        this.fControllerCoroutineID = co2.co_joinCoroutineSet(controllerCoroutineID);
        this.fSourceCoroutineID = co2.co_joinCoroutineSet(sourceCoroutineID);
        if (this.fControllerCoroutineID == -1 || this.fSourceCoroutineID == -1) {
            throw new RuntimeException(XSLMessages.createMessage(161, null));
        }
        this.fNoMoreEvents = false;
        this.eventcounter = this.frequency;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.processingInstruction(target, data);
        }
    }

    public void run() {
        if (this.fXMLReader == null) {
            return;
        }
        if (this.DEBUG) {
            System.out.println("IncrementalSAXSource_Filter parse thread launched");
        }
        Serializable arg = Boolean.FALSE;
        try {
            this.fXMLReader.parse(this.fXMLReaderInputSource);
        }
        catch (IOException ex2) {
            arg = ex2;
        }
        catch (StopException stopException) {
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
            }
        }
        catch (SAXException ex3) {
            Exception inner = ex3.getException();
            if (inner instanceof StopException) {
                if (this.DEBUG) {
                    System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
                }
            }
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter UNEXPECTED SAX exception: " + inner);
                inner.printStackTrace();
            }
            arg = ex3;
        }
        this.fXMLReader = null;
        try {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit_to(arg, this.fSourceCoroutineID, this.fControllerCoroutineID);
        }
        catch (NoSuchMethodException e10) {
            e10.printStackTrace(System.err);
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.clientContentHandler = handler;
    }

    public void setDocumentLocator(Locator locator) {
        if (--this.eventcounter <= 0) {
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.setDocumentLocator(locator);
        }
    }

    public void setErrHandler(ErrorHandler handler) {
        this.clientErrorHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.clientLexicalHandler = handler;
    }

    public void setReturnFrequency(int events) {
        if (events < 1) {
            events = 1;
        }
        this.frequency = this.eventcounter = events;
    }

    public void setXMLReader(XMLReader eventsource) {
        this.fXMLReader = eventsource;
        eventsource.setContentHandler(this);
        eventsource.setErrorHandler(this);
        try {
            eventsource.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
    }

    public void skippedEntity(String name) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.skippedEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void startDocument() throws SAXException {
        this.co_entry_pause();
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startDocument();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startEntity(name);
        }
    }

    public void startParse(InputSource source) throws SAXException {
        if (this.fNoMoreEvents) {
            throw new SAXException(XSLMessages.createMessage(214, null));
        }
        if (this.fXMLReader == null) {
            throw new SAXException(XSLMessages.createMessage(215, null));
        }
        this.fXMLReaderInputSource = source;
        TransformerImpl.runTransformThread(this);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(exception);
        }
    }

    class StopException
    extends RuntimeException {
        StopException() {
        }
    }
}

