/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xml.utils.XMLCharacterRecognizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FastStringBuffer {
    static final int DEBUG_FORCE_INIT_BITS = 0;
    int m_chunkBits = 15;
    int m_maxChunkBits = 15;
    int m_rebundleBits = 2;
    int m_chunkSize;
    int m_chunkMask;
    char[][] m_array;
    int m_lastChunk = 0;
    int m_firstFree = 0;
    FastStringBuffer m_innerFSB = null;
    static char[] m_oneChar = new char[]{' '};

    public FastStringBuffer() {
        this(10, 15, 2);
    }

    public FastStringBuffer(int initChunkBits) {
        this(initChunkBits, 15, 2);
    }

    public FastStringBuffer(int initChunkBits, int maxChunkBits) {
        this(initChunkBits, maxChunkBits, 2);
    }

    public FastStringBuffer(int initChunkBits, int maxChunkBits, int rebundleBits) {
        this.m_array = new char[16][];
        if (initChunkBits > maxChunkBits) {
            initChunkBits = maxChunkBits;
        }
        this.m_chunkBits = initChunkBits;
        this.m_maxChunkBits = maxChunkBits;
        this.m_rebundleBits = rebundleBits;
        this.m_chunkSize = 1 << initChunkBits;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_array[0] = new char[this.m_chunkSize];
    }

    private FastStringBuffer(FastStringBuffer source) {
        this.m_chunkBits = source.m_chunkBits;
        this.m_maxChunkBits = source.m_maxChunkBits;
        this.m_rebundleBits = source.m_rebundleBits;
        this.m_chunkSize = source.m_chunkSize;
        this.m_chunkMask = source.m_chunkMask;
        this.m_array = source.m_array;
        this.m_innerFSB = source.m_innerFSB;
        this.m_lastChunk = source.m_lastChunk - 1;
        this.m_firstFree = source.m_chunkSize;
        source.m_array = new char[16][];
        source.m_innerFSB = this;
        source.m_lastChunk = 1;
        source.m_firstFree = 0;
        source.m_chunkBits += this.m_rebundleBits;
        source.m_chunkSize = 1 << source.m_chunkBits;
        source.m_chunkMask = source.m_chunkSize - 1;
    }

    public final void append(char value) {
        char[] chunk;
        boolean lastchunk;
        boolean bl2 = lastchunk = this.m_lastChunk + 1 == this.m_array.length;
        if (this.m_firstFree < this.m_chunkSize) {
            chunk = this.m_array[this.m_lastChunk];
        } else {
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            this.m_firstFree = 0;
        }
        chunk[this.m_firstFree++] = value;
    }

    public final void append(String value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, copyfrom + available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(StringBuffer value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, copyfrom + available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(FastStringBuffer value) {
        int strlen = value.length();
        if (strlen == 0) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            int sourcechunk = copyfrom + value.m_chunkSize - 1 >>> value.m_chunkBits;
            int sourcecolumn = copyfrom & value.m_chunkMask;
            int runlength = value.m_chunkSize - sourcecolumn;
            if (runlength > available) {
                runlength = available;
            }
            System.arraycopy(value.m_array[sourcechunk], sourcecolumn, this.m_array[this.m_lastChunk], this.m_firstFree, runlength);
            if (runlength != available) {
                System.arraycopy(value.m_array[sourcechunk + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + runlength, available - runlength);
            }
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(char[] chars, int start, int length) {
        int strlen = length;
        if (strlen == 0) {
            return;
        }
        int copyfrom = start;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            System.arraycopy(chars, copyfrom, this.m_array[this.m_lastChunk], this.m_firstFree, available);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i2 = this.m_array.length;
            if (this.m_lastChunk + 1 == i2) {
                char[][] newarray = new char[i2 + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i2);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public char charAt(int pos) {
        int startChunk = pos >>> this.m_chunkBits;
        if (startChunk == 0 && this.m_innerFSB != null) {
            return this.m_innerFSB.charAt(pos & this.m_chunkMask);
        }
        return this.m_array[startChunk][pos & this.m_chunkMask];
    }

    private void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
    }

    public String getString(int start, int length) {
        return this.getString(new StringBuffer(length), start >>> this.m_chunkBits, start & this.m_chunkMask, length).toString();
    }

    StringBuffer getString(StringBuffer sb, int start, int length) {
        return this.getString(sb, start >>> this.m_chunkBits, start & this.m_chunkMask, length);
    }

    StringBuffer getString(StringBuffer sb, int startChunk, int startColumn, int length) {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        int i2 = startChunk;
        while (i2 < stopChunk) {
            if (i2 == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.getString(sb, startColumn, this.m_chunkSize - startColumn);
            } else {
                sb.append(this.m_array[i2], startColumn, this.m_chunkSize - startColumn);
            }
            startColumn = 0;
            ++i2;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.getString(sb, startColumn, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            sb.append(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
        return sb;
    }

    public boolean isWhitespace(int start, int length) {
        int sourcechunk = start >>> this.m_chunkBits;
        int sourcecolumn = start & this.m_chunkMask;
        int available = this.m_chunkSize - sourcecolumn;
        while (length > 0) {
            int runlength = length <= available ? length : available;
            boolean chunkOK = sourcechunk == 0 && this.m_innerFSB != null ? this.m_innerFSB.isWhitespace(sourcecolumn, runlength) : XMLCharacterRecognizer.isWhiteSpace(this.m_array[sourcechunk], sourcecolumn, runlength);
            if (!chunkOK) {
                return false;
            }
            length -= runlength;
            ++sourcechunk;
            sourcecolumn = 0;
            available = this.m_chunkSize;
        }
        return true;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
        FastStringBuffer innermost = this;
        while (innermost.m_innerFSB != null) {
            innermost = innermost.m_innerFSB;
        }
        this.m_chunkBits = innermost.m_chunkBits;
        this.m_chunkSize = innermost.m_chunkSize;
        this.m_chunkMask = innermost.m_chunkMask;
        this.m_innerFSB = null;
        this.m_array = new char[16][0];
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public void sendNormalizedSAXcharacters(ContentHandler ch2, int start, int length) throws SAXException {
        int stop = start + length;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        int i2 = startChunk;
        while (i2 < stopChunk) {
            if (i2 == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.sendNormalizedSAXcharacters(ch2, startColumn, this.m_chunkSize - startColumn);
            } else {
                FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[i2], startColumn, this.m_chunkSize - startColumn, ch2);
            }
            startColumn = 0;
            ++i2;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.sendNormalizedSAXcharacters(ch2, startColumn, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[stopChunk], startColumn, stopColumn - startColumn, ch2);
        }
    }

    public static void sendNormalizedSAXcharacters(char[] ch2, int start, int length, ContentHandler handler) throws SAXException {
        int len;
        int end = length + start;
        int s2 = start;
        while (s2 < end) {
            char c10 = ch2[s2];
            if (!XMLCharacterRecognizer.isWhiteSpace(c10)) break;
            ++s2;
        }
        boolean whiteSpaceFound = false;
        boolean needToFlushSpace = false;
        int d10 = s2;
        while (s2 < end) {
            char c11 = ch2[s2];
            if (XMLCharacterRecognizer.isWhiteSpace(c11)) {
                if (!whiteSpaceFound) {
                    whiteSpaceFound = true;
                    if (c11 != ' ') {
                        int len2 = s2 - d10;
                        if (len2 > 0) {
                            if (needToFlushSpace) {
                                handler.characters(m_oneChar, 0, 1);
                            }
                            handler.characters(ch2, d10, len2);
                            needToFlushSpace = true;
                        }
                        d10 = s2 + 1;
                    }
                } else {
                    int z2 = s2 + 1;
                    while (z2 < end) {
                        c11 = ch2[z2];
                        if (!XMLCharacterRecognizer.isWhiteSpace(c11)) break;
                        ++z2;
                    }
                    int len3 = s2 - d10;
                    if (z2 == end) {
                        end = s2;
                        break;
                    }
                    if (len3 > 0) {
                        if (needToFlushSpace) {
                            handler.characters(m_oneChar, 0, 1);
                            needToFlushSpace = false;
                        }
                        handler.characters(ch2, d10, len3);
                    }
                    whiteSpaceFound = false;
                    d10 = s2 = z2;
                }
            } else {
                whiteSpaceFound = false;
            }
            ++s2;
        }
        if (whiteSpaceFound) {
            --s2;
        }
        if ((len = s2 - d10) > 0) {
            if (needToFlushSpace) {
                handler.characters(m_oneChar, 0, 1);
            }
            handler.characters(ch2, d10, len);
        }
    }

    public void sendSAXComment(LexicalHandler ch2, int start, int length) throws SAXException {
        String comment = this.getString(start, length);
        ch2.comment(comment.toCharArray(), 0, length);
    }

    public void sendSAXcharacters(ContentHandler ch2, int start, int length) throws SAXException {
        int stop = start + length;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        int i2 = startChunk;
        while (i2 < stopChunk) {
            if (i2 == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.sendSAXcharacters(ch2, startColumn, this.m_chunkSize - startColumn);
            } else {
                ch2.characters(this.m_array[i2], startColumn, this.m_chunkSize - startColumn);
            }
            startColumn = 0;
            ++i2;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.sendSAXcharacters(ch2, startColumn, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            ch2.characters(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
    }

    public final void setLength(int l2) {
        this.m_lastChunk = l2 >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l2, this);
        } else {
            this.m_firstFree = l2 & this.m_chunkMask;
        }
    }

    private final void setLength(int l2, FastStringBuffer rootFSB) {
        this.m_lastChunk = l2 >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l2, rootFSB);
        } else {
            rootFSB.m_chunkBits = this.m_chunkBits;
            rootFSB.m_maxChunkBits = this.m_maxChunkBits;
            rootFSB.m_rebundleBits = this.m_rebundleBits;
            rootFSB.m_chunkSize = this.m_chunkSize;
            rootFSB.m_chunkMask = this.m_chunkMask;
            rootFSB.m_array = this.m_array;
            rootFSB.m_innerFSB = this.m_innerFSB;
            rootFSB.m_lastChunk = this.m_lastChunk;
            rootFSB.m_firstFree = l2 & this.m_chunkMask;
        }
    }

    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final String toString() {
        int length = (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
        return this.getString(new StringBuffer(length), 0, 0, length).toString();
    }
}

